/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.dingding;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiDepartmentListRequest;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiReportListRequest;
import com.dingtalk.api.request.OapiUserListbypageRequest;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiReportListResponse;
import com.dingtalk.api.response.OapiUserListbypageResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DingdingUtils {
    @Value(value="${dingding.appkey}")
    private String appkey;
    @Value(value="${dingding.appsecret}")
    private String appsecret;
    @Autowired
    private RedisService redisService;

    public BaseJsonVo<String> getAccessToken() {
        String accessToken;
        String redisKey = "dingding_" + this.appkey + this.appsecret;
        Object o = this.redisService.get(redisKey);
        String string = accessToken = o != null ? o.toString() : "";
        if (StringUtils.isEmpty((String)accessToken)) {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
            OapiGettokenRequest request = new OapiGettokenRequest();
            request.setAppkey(this.appkey);
            request.setAppsecret(this.appsecret);
            request.setHttpMethod("GET");
            try {
                OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
                if (response != null) {
                    accessToken = response.getAccessToken();
                    this.redisService.save(redisKey, accessToken, 7000L);
                }
            }
            catch (ApiException e) {
                e.printStackTrace();
                return BaseJsonVo.error((String)e.getMessage());
            }
        }
        return BaseJsonVo.success((Object)accessToken);
    }

    public BaseJsonVo<List<OapiUserListbypageResponse.Userlist>> getUsers(Long offset) {
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/listbypage");
        OapiUserListbypageRequest request = new OapiUserListbypageRequest();
        request.setDepartmentId(Long.valueOf(1L));
        request.setOffset(offset);
        request.setSize(Long.valueOf(100L));
        request.setOrder("entry_desc");
        request.setHttpMethod("GET");
        try {
            OapiUserListbypageResponse execute = (OapiUserListbypageResponse)client.execute((TaobaoRequest)request, accessToken);
            return BaseJsonVo.success((Object)execute.getUserlist());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u7528\u6237\u5217\u8868\u5f02\u5e38");
        }
    }

    public BaseJsonVo<List<OapiDepartmentListResponse.Department>> getDepts() {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/department/list");
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId("1");
        request.setFetchChild(Boolean.valueOf(true));
        request.setHttpMethod("GET");
        try {
            OapiDepartmentListResponse response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, accessToken);
            return BaseJsonVo.success((Object)response.getDepartment());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u90e8\u95e8\u5217\u8868\u5f02\u5e38");
        }
    }

    public BaseJsonVo<List<OapiReportListResponse.PageVo>> getReport(String templateName, Date sdate, Date edate, Long cursor) {
        BaseJsonVo<String> jsonVo = this.getAccessToken();
        if (!jsonVo.isSuccess()) {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        String accessToken = (String)jsonVo.getValue();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/report/list");
        OapiReportListRequest request = new OapiReportListRequest();
        request.setStartTime(Long.valueOf(sdate.getTime()));
        request.setEndTime(Long.valueOf(edate.getTime()));
        request.setTemplateName(templateName);
        request.setCursor(cursor);
        request.setSize(Long.valueOf(20L));
        try {
            OapiReportListResponse response = (OapiReportListResponse)client.execute((TaobaoRequest)request, accessToken);
            return BaseJsonVo.success((Object)response.getResult());
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u83b7\u53d6\u65e5\u5fd7\u5217\u8868\u5f02\u5e38");
        }
    }
}

