/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.file;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.weixin.MessageRemainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MallMessageRemainInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MallImportExcelService {
    private static final Logger log = LoggerFactory.getLogger(MallImportExcelService.class);
    @Autowired
    private MallMessageRemainInterface mallMessageRemainInterface;
    @Autowired
    private CustomerInterface customerInterface;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseJsonVo importCustomerInfoUrl(MultipartFile file, String actionId) {
        long startTime = System.currentTimeMillis();
        log.info("=============importCustomerInfoUrl============startTime={}", (Object)startTime);
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        String filename = file.getOriginalFilename();
        if (StringUtils.isEmpty((String)filename) || !filename.endsWith(".xls") && !filename.endsWith(".xlsx")) {
            BaseJsonVo.error((String)"\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u53ea\u80fd\u4e3a .xls \u7ed3\u5c3e\u6216 .xlsx \u7ed3\u5c3e\u7684 excel \u6587\u4ef6\uff01\uff01\uff01\uff01\uff01");
            return baseJsonVo;
        }
        try {
            List<String> idList = this.readExcelContentByList(file);
            StringBuffer sqlSb = new StringBuffer();
            if (idList.size() <= 0) return BaseJsonVo.success((Object)"\u6587\u6863\u4e3a\u7a7a");
            final ArrayList<MessageRemainEntity> messageRemainEntityList = new ArrayList<MessageRemainEntity>();
            List<CustomerDetailVo> customerDetailVoList = this.customerInterface.getCustomerDetailByOpenIds(idList, 1);
            if (customerDetailVoList.size() > 0) {
                int i = this.mallMessageRemainInterface.deleteAll();
                for (CustomerDetailVo customerDetailVo : customerDetailVoList) {
                    MessageRemainEntity messageRemainEntity = new MessageRemainEntity();
                    messageRemainEntity.setChannelCustomerId(customerDetailVo.getOpenId());
                    messageRemainEntity.setNickName(customerDetailVo.getNickName());
                    messageRemainEntity.setStatus(0);
                    messageRemainEntity.setAction(actionId);
                    messageRemainEntity.setCreateTime(new Date());
                    messageRemainEntity.setType("");
                    messageRemainEntity.setUpdateTime(new Date());
                    messageRemainEntityList.add(messageRemainEntity);
                }
            } else {
                List<CustomerEntity> customerEntityList = this.customerInterface.getCustomerByCustomerIds(idList);
                if (customerEntityList.size() > 0) {
                    int i = this.mallMessageRemainInterface.deleteAll();
                    for (CustomerEntity customerEntity : customerEntityList) {
                        MessageRemainEntity messageRemainEntity = new MessageRemainEntity();
                        messageRemainEntity.setChannelCustomerId(customerEntity.getChannelCustomerId());
                        messageRemainEntity.setNickName(customerEntity.getNickName());
                        messageRemainEntity.setStatus(0);
                        messageRemainEntity.setAction(actionId);
                        messageRemainEntity.setCreateTime(new Date());
                        messageRemainEntity.setType("");
                        messageRemainEntity.setUpdateTime(new Date());
                        messageRemainEntityList.add(messageRemainEntity);
                    }
                } else {
                    List<CustomerEntity> customerVoList = this.customerInterface.getCustomerBySignIds(idList);
                    if (customerVoList.size() > 0) {
                        int i = this.mallMessageRemainInterface.deleteAll();
                        for (CustomerEntity customerEntity : customerVoList) {
                            MessageRemainEntity messageRemainEntity = new MessageRemainEntity();
                            messageRemainEntity.setChannelCustomerId(customerEntity.getChannelCustomerId());
                            messageRemainEntity.setNickName(customerEntity.getNickName());
                            messageRemainEntity.setStatus(0);
                            messageRemainEntity.setAction(actionId);
                            messageRemainEntity.setCreateTime(new Date());
                            messageRemainEntity.setType("");
                            messageRemainEntity.setUpdateTime(new Date());
                            messageRemainEntityList.add(messageRemainEntity);
                        }
                    }
                }
            }
            if (messageRemainEntityList == null || messageRemainEntityList.size() <= 0) return BaseJsonVo.success((Object)"\u6839\u636e\u6587\u6863\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            int forNum = messageRemainEntityList.size() / 1000;
            if (messageRemainEntityList.size() % 1000 != 0) {
                ++forNum;
            }
            ExecutorService pool = Executors.newFixedThreadPool(forNum);
            int i = 1;
            while (i <= forNum) {
                final int n = i++;
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        long startTimeTow = System.currentTimeMillis();
                        log.info("=============importCustomerInfoUrl============startTimeTow={}", (Object)startTimeTow);
                        Page page = PageHelper.startPage((int)n, (int)1000);
                        PageInfo pg = page.toPageInfo();
                        pg.setList(messageRemainEntityList);
                        MallImportExcelService.this.mallMessageRemainInterface.insertMessageRemainBatch(pg.getList());
                        long endTimeTwo = System.currentTimeMillis();
                        long timeTwo = (endTimeTwo - startTimeTow) / 1000L;
                        log.info("=============importCustomerInfoUrl============endTimeTwo={},timeTwo={}", (Object)endTimeTwo, (Object)timeTwo);
                    }
                });
            }
            pool.shutdown();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseJsonVo.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458");
        }
        long endTime = System.currentTimeMillis();
        long time = (endTime - startTime) / 1000L;
        log.info("*************************importCustomerInfoUrl.Time*************************time={}", (Object)time);
        return BaseJsonVo.success((Object)"\u4e0a\u4f20\u6210\u529f");
    }

    public void sqlPackage(List<MessageRemainEntity> messageRemainEntityList, StringBuffer sqlSb) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (MessageRemainEntity messageRemainEntity : messageRemainEntityList) {
            String sqlSbStr = "insert into t_mall_template_message_remain (CHANNEL_CUSTOMER_ID,NICK_NAME,STATUS,ACTION,CREATE_TIME,TYPE,UPDATE_TIME) values ('" + messageRemainEntity.getChannelCustomerId() + "','" + messageRemainEntity.getNickName() + "','" + messageRemainEntity.getStatus() + "','" + messageRemainEntity.getAction() + "','" + sf.format(messageRemainEntity.getCreateTime()) + "','" + messageRemainEntity.getType() + "','" + sf.format(messageRemainEntity.getUpdateTime()) + "')";
            sqlSb.append(sqlSbStr).append(";");
        }
    }

    public List<String> readExcelContentByList(MultipartFile file) {
        long startTime = System.currentTimeMillis();
        log.info("=============readExcelContentByList============startTime={}", (Object)startTime);
        Object workbook = null;
        boolean isExcel2003 = file.getOriginalFilename().endsWith(".xls");
        ArrayList<String> list = new ArrayList<String>();
        try {
            workbook = isExcel2003 ? new HSSFWorkbook(file.getInputStream()) : new XSSFWorkbook(file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < rowNum; ++i) {
                String cellValue = "";
                Row rowHead = sheet.getRow(i);
                HashMap map = new HashMap();
                Cell cell = rowHead.getCell(0);
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case 1: {
                            cellValue = cell.getStringCellValue();
                            break;
                        }
                        case 4: {
                            cellValue = Boolean.toString(cell.getBooleanCellValue());
                            break;
                        }
                        case 2: {
                            cellValue = new BigDecimal(cell.getNumericCellValue()).toPlainString();
                            break;
                        }
                        case 0: {
                            cellValue = new BigDecimal(cell.getNumericCellValue()).toPlainString();
                            break;
                        }
                        case 3: {
                            cellValue = "";
                            break;
                        }
                        case 5: {
                            cellValue = "\u975e\u6cd5\u5b57\u7b26";
                            break;
                        }
                        default: {
                            cellValue = "\u672a\u77e5\u7c7b\u578b";
                        }
                    }
                }
                list.add(cellValue);
            }
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            log.info("*************************readExcelContentByList.Time*************************time={}", (Object)time);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }
}

