/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketUserInfoMapper;
import cc.lechun.mall.entity.cashticket.CashticketUserInfoEntity;
import cc.lechun.mall.iservice.cashticket.CashticketUserInfoInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketUserInfoService
extends BaseService
implements CashticketUserInfoInterface {
    @Autowired
    private CashticketUserInfoMapper cashticketUserInfoMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public CashticketUserInfoEntity getCashticketUserInfo(@ParameterValueKeyProvider String userId) {
        CashticketUserInfoEntity cashticketUserInfoEntity = new CashticketUserInfoEntity();
        cashticketUserInfoEntity.setUserId(userId);
        return (CashticketUserInfoEntity)CollectionUtils.listToEntiy((List)this.cashticketUserInfoMapper.getList(cashticketUserInfoEntity));
    }

    @Override
    public BaseJsonVo saveCashticketUserInfo(CashticketUserInfoEntity cashticketUserInfoEntity) {
        cashticketUserInfoEntity.setCreateTime(DateUtils.now());
        this.cashticketUserInfoMapper.insertSelective(cashticketUserInfoEntity);
        this.removeCache(cashticketUserInfoEntity.getUserId());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateCashticketUserInfo(CashticketUserInfoEntity cashticketUserInfoEntity) {
        this.cashticketUserInfoMapper.updateByPrimaryKeySelective(cashticketUserInfoEntity);
        this.removeCache(cashticketUserInfoEntity.getUserId());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getCashticketUserInfoList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        CashticketUserInfoEntity cashticketUserInfoEntity = new CashticketUserInfoEntity();
        if (!StringUtil.isEmpty((String)userId)) {
            cashticketUserInfoEntity.setUserId(userId);
        }
        this.cashticketUserInfoMapper.getList(cashticketUserInfoEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private void removeCache(String userId) {
        this.memcachedService.delete("getCashticketUserInfo", userId);
    }
}

