/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cil;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.service.trade.MallOrderSyncInfoService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EDBLib {
    private static Logger logger = LoggerFactory.getLogger(EDBLib.class);
    public static String dbhost;
    public static String appkey;
    public static String appscret;
    public static String token;
    public static String serviceUrl;
    private static Comparator<String> comparator;

    @Value(value="${edb2.dbhost}")
    public void setDbhost(String dbhost) {
        EDBLib.dbhost = dbhost;
    }

    @Value(value="${edb2.appkey}")
    public void setAppkey(String appkey) {
        EDBLib.appkey = appkey;
    }

    @Value(value="${edb2.appscret}")
    public void setAppscret(String appscret) {
        EDBLib.appscret = appscret;
    }

    @Value(value="${edb2.token}")
    public void setToken(String token) {
        EDBLib.token = token;
    }

    @Value(value="${edb2.serviceUrl}")
    public void setServiceUrl(String serviceUrl) {
        EDBLib.serviceUrl = serviceUrl;
    }

    public static Map<String, String> edbGetCommonParams(String method) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("method", method);
        map.put("dbhost", dbhost);
        map.put("appkey", appkey);
        map.put("format", "JSON");
        map.put("timestamp", new SimpleDateFormat("yyyyMMddHHmm").format(new Date()));
        map.put("v", "2.0");
        map.put("slencry", "1");
        map.put("ip", "192.168.1.153");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseJsonVo edbRequstPost(String method, Map<String, String> params, MallOrderSyncInfoEntity entity) {
        params.putAll(EDBLib.edbGetCommonParams(method));
        HttpURLConnection connection = null;
        try {
            StringBuilder builder = new StringBuilder();
            for (String key : params.keySet()) {
                String val = "xmlValues".equalsIgnoreCase(key) ? URLEncoder.encode(params.get(key), "UTF-8") : params.get(key);
                builder.append(String.format("%1$s=%2$s&", key, URLEncoder.encode(val, "UTF-8")));
            }
            builder.append("sign=" + EDBLib.edbSignature(params));
            System.out.println("\u670d\u52a1\u5730\u5740 :" + serviceUrl);
            System.out.println("\u8bf7\u6c42\u6570\u636e :" + URLDecoder.decode(URLDecoder.decode(builder.toString(), "utf-8"), "utf-8"));
            System.out.println("\u5b9e\u9645\u53d1\u9001 :" + builder);
            connection = (HttpURLConnection)new URL(serviceUrl).openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "utf-8");
            out.write(builder.toString());
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            builder.setLength(0);
            String line = "";
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            reader.close();
            System.out.println("\u56de\u5e94\u6570\u636e :" + builder);
            MallOrderSyncInfoInterface orderSyncInfoService = (MallOrderSyncInfoInterface)SpringContextUtil.getBean(MallOrderSyncInfoService.class);
            if (entity == null) {
                entity = new MallOrderSyncInfoEntity();
            }
            entity.setApiName(method);
            entity.setApiParam(JsonUtils.toJson(params, (boolean)false));
            entity.setApiReturn(builder.toString());
            entity.setWarnLevel(5);
            entity.setDirection(0);
            entity.setCreateTime(DateUtils.now());
            entity.setSyncName("MALL");
            if (builder.toString() != null && (builder.toString().contains("True") || builder.toString().contains("true"))) {
                entity.setSuccess(1);
                orderSyncInfoService.recordInfo(entity);
                BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)builder.toString());
                return baseJsonVo;
            }
            entity.setSuccess(0);
            orderSyncInfoService.recordInfo(entity);
            BaseJsonVo baseJsonVo = BaseJsonVo.error((String)builder.toString());
            return baseJsonVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bf7\u6c42EDB\u63a5\u53e3\u53d1\u9001\u5f02\u5e38", (Throwable)e);
            BaseJsonVo baseJsonVo = BaseJsonVo.error((String)("\u5f02\u5e38\uff1a" + e.getMessage()));
            return baseJsonVo;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String edbSignature(Map<String, String> params) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(comparator);
        treeMap.putAll(params);
        treeMap.put("appscret", appscret);
        treeMap.put("token", token);
        StringBuilder builder = new StringBuilder(appkey);
        for (String key : treeMap.keySet()) {
            if ("".equals(key) || "".equals(treeMap.get(key))) continue;
            builder.append(key).append((String)treeMap.get(key));
        }
        System.out.println("\u7b7e\u540d\u660e\u6587:" + builder);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(builder.toString().getBytes("utf-8"));
            builder.setLength(0);
            for (byte b : bytes) {
                String hx = Integer.toHexString(b & 0xFF);
                builder.append(hx.length() == 1 ? "0" + hx : hx);
            }
            return builder.toString().toUpperCase();
        }
        catch (Exception e) {
            return "\u7b7e\u540d\u5f02\u5e38";
        }
    }

    static {
        comparator = new Comparator<String>(){

            @Override
            public int compare(String k1, String k2) {
                return k1.compareToIgnoreCase(k2);
            }
        };
    }
}

