/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerInfoDetailMapper;
import cc.lechun.mall.entity.customer.CustomerInfoDetailEntity;
import cc.lechun.mall.iservice.customer.CustomerInfoDetailInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerInfoDetailService
extends BaseService
implements CustomerInfoDetailInterface {
    @Autowired
    private CustomerInfoDetailMapper customerInfoDetailMapper;
    @Autowired
    private MallVipInterface vipService;

    @Override
    @ReadThroughSingleCache(namespace="getCustomerInfoDetail", expiration=7200)
    public CustomerInfoDetailEntity getCustomerInfoDetail(@ParameterValueKeyProvider String customerId) {
        return (CustomerInfoDetailEntity)this.customerInfoDetailMapper.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    @Override
    @InvalidateSingleCache(namespace="getCustomerInfoDetail")
    public CustomerInfoDetailEntity updateCustomerInfoDetail(@ParameterValueKeyProvider String customerId, CustomerInfoDetailEntity customerInfoDetailEntity) {
        customerInfoDetailEntity.setCustomerId(customerId);
        CustomerInfoDetailEntity customerInfoDetailEntity1 = (CustomerInfoDetailEntity)this.customerInfoDetailMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (customerInfoDetailEntity1 == null) {
            this.customerInfoDetailMapper.insertSelective(customerInfoDetailEntity);
        } else {
            this.customerInfoDetailMapper.updateByPrimaryKeySelective(customerInfoDetailEntity);
        }
        this.vipService.finishTaskImproveInfo(customerId);
        return customerInfoDetailEntity;
    }
}

