/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallDeliverMapper;
import cc.lechun.mall.dao.kw.SysKwMapper;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.deliver.DeliverDateVo;
import cc.lechun.mall.entity.deliver.DeliverFreightVo;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.deliver.MallDeliverEntity;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.IndexItemEntity;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.kw.SysKwEntity;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.DeliverFreightInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.deliver.DeliverEntity;
import cc.lechun.mall.service.deliver.DeliverProductVo;
import cc.lechun.mall.service.deliver.GroupProductEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeliverService
extends BaseService
implements DeliverInterface {
    @Value(value="${lechun.oldapi.domain}")
    private String oldApiHost;
    @Autowired
    private DeliverFreightInterface freightInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private SysKwMapper sysKwMapper;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private CustomerAddressInterface addressService;
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MallProductSalesInterface productSalesService;
    @Autowired
    private MallDeliverMapper deliverMapper;
    @Autowired
    private MallProductMapper mallProductMapper;
    @Value(value="${erp.orderDeliver.url}")
    private String orderDeliverUrl;

    @Override
    public DeliverVo getDeliverByErp(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, int speedUp) {
        this.logger.info("****************\u8fdb\u5165\u65b0\u7684\u83b7\u53d6\u914d\u9001\u65e5\u671f\u65b9\u6cd5getDeliverByErp**************************");
        DeliverVo deliverVo = new DeliverVo();
        this.getProductDeliverByErp(deliverVo, shoppingcartVO, addressVo, deliverDate, speedUp);
        return deliverVo;
    }

    public DeliverVo getProductDeliverByErp(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, int speedUp) {
        this.logger.info("***********getProductDeliverByErp************deliverVo={},shoppingcartVO={},addressVo={},deliverDate={}", new Object[]{JSON.toJSONString((Object)deliverVo), JSON.toJSONString((Object)shoppingcartVO), JSON.toJSONString((Object)addressVo), deliverDate});
        if (addressVo == null || StringUtils.isEmpty((CharSequence)addressVo.getAddrId())) {
            deliverVo.setNomalInventory(0);
            deliverVo.setInventory(-2);
            return deliverVo;
        }
        String result = this.getDeliverByErpThr(shoppingcartVO, addressVo);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.getNoSeepUpProductDeliverByErp(deliverVo, shoppingcartVO, addressVo, deliverDate, result);
            if (!deliverVo.isBaseSuccess()) {
                this.logger.info("******\u8fd4\u56de\u5931\u8d25getNoSeepUpProductDeliverByErp******");
                return deliverVo;
            }
            if ("1".equals(addressVo.getSpeedUp())) {
                if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
                    return deliverVo;
                }
                this.getSeepUpProductDeliverByErp(deliverVo, shoppingcartVO, addressVo, deliverDate);
            }
            return deliverVo;
        }
        deliverVo.setInventory(-1);
        return deliverVo;
    }

    public String getDeliverByErpThr(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("privinceName", addressVo.getProvinceName());
        mapParam.put("cityName", addressVo.getCityName());
        mapParam.put("areaName", addressVo.getAreaName());
        mapParam.put("address", addressVo.getAddress());
        int transportType = this.productInterface.getTransportType(shoppingcartVO);
        if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            transportType = 1;
        } else if (transportType == 1) {
            transportType = 13;
        }
        mapParam.put("deliverType", String.valueOf(transportType));
        JSONArray jsonArrayProduct = new JSONArray();
        if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0) {
            shoppingcartVO.getProductsPool().forEach(productVO -> {
                HashMap<String, String> productMap = new HashMap<String, String>();
                productMap.put("barCode", productVO.getBarCode());
                productMap.put("productName", productVO.getProName());
                productMap.put("productCount", String.valueOf(productVO.getCount()));
                jsonArrayProduct.add(productMap);
            });
            mapParam.put("wxProductForms", (String)jsonArrayProduct);
        }
        this.logger.info("*************************getProductDeliverByErp********************\u8c03\u7528ERP3.0\u4f20\u9012\u7684\u53c2\u6570*************mapParam={}\uff0corderDeliverUrl={}", (Object)JSON.toJSONString(mapParam), (Object)this.orderDeliverUrl);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.orderDeliverUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        this.logger.info("*************************getProductDeliverByErp********************\u8c03\u7528ERP3.0\u8fd4\u56de\u7684\u6570\u636e*************result={}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public DeliverVo getSeepUpProductDeliverByErp(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate) {
        this.logger.info("*************************\u8fdb\u5165getSeepUpProductDeliverByErp***********");
        DeliverDateVo deliverDateVo = new DeliverDateVo();
        deliverDateVo.setDeliverDate(DateUtils.date());
        deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)DateUtils.date()));
        if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0 && this.getPrepositionCartProductsStock(addressVo.getSpeedUpWcId(), shoppingcartVO.getProductsPool()).isSuccess()) {
            deliverDateVo.setInventory(1);
        } else {
            deliverDateVo.setInventory(0);
        }
        deliverDateVo.setSpeedUp(1);
        deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)DateUtils.date(), (String)"yyyy-MM-dd")));
        deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)DateUtils.date(), (String)"yyyy-MM-dd")));
        deliverVo.getDeliverDateVos().add(deliverDateVo);
        deliverVo.getDeliverDateVos().sort((f1, f2) -> f1.getDeliverDate().compareTo(f2.getDeliverDate()));
        if ("1".equals(deliverDateVo.getInventory()) && (StringUtils.isEmpty((CharSequence)deliverDate) || DateUtils.date().equals(deliverDate))) {
            deliverVo.setDeliverId("0");
            deliverVo.setDeliverName("\u7f8e\u56e2\u914d\u9001");
            deliverVo.setDeliverDate(DateUtils.date());
            deliverVo.setDeliverDateShow("\u7acb\u5373\u914d\u9001");
            deliverVo.setPickDate(DateUtils.date());
            deliverVo.setDeliverEndTime("22:00");
            deliverVo.setDelay(0);
            deliverVo.setDcId(addressVo.getSpeedUpWcId());
            deliverVo.setInventory(1);
            deliverVo.setSpeedupInventory(1);
        }
        return deliverVo;
    }

    public DeliverVo getNoSeepUpProductDeliverByErp(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, String result) {
        JSONObject jsonObject = JSON.parseObject((String)result);
        this.logger.info("*************************getNoSeepUpProductDeliverByErp***********jsonObject************jsonObject={}", (Object)jsonObject);
        boolean success = (Boolean)jsonObject.get((Object)"success");
        int status = (Integer)jsonObject.get((Object)"status");
        ArrayList<DeliverDateVo> deliverDateVos = new ArrayList<DeliverDateVo>();
        if (success && status == 200) {
            JSONObject objectResult = (JSONObject)jsonObject.get((Object)"result");
            JSONObject deliverDates = (JSONObject)objectResult.get((Object)"dates");
            JSONArray jsonArrayProduct = (JSONArray)objectResult.get((Object)"wxProductForms");
            String earliestPickupDate = (String)objectResult.get((Object)"earliestPickupDate");
            String earliestDeliverDate = (String)objectResult.get((Object)"earliestDeliverDate");
            String finishTime = (String)objectResult.get((Object)"finishTime");
            String weekSetPickup = (String)objectResult.get((Object)"weekSetPickup");
            String deliverId = (String)objectResult.get((Object)"deliverId");
            String kwId = (String)objectResult.get((Object)"kwId");
            String kwName = (String)objectResult.get((Object)"kwName");
            String edbStoreId = (String)objectResult.get((Object)"edbStoreId");
            if (deliverDates != null) {
                for (String k : deliverDates.keySet()) {
                    DeliverDateVo deliverDateVo = new DeliverDateVo();
                    deliverDateVo.setDeliverDate(k.split("\\|")[0]);
                    deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDateVo.getDeliverDate()));
                    deliverDateVo.setInventory((Integer)deliverDates.get((Object)k));
                    deliverDateVo.setSpeedUp(deliverDateVo.getDeliverDate().equals(DateUtils.date()) ? 1 : 0);
                    deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                    deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                    deliverDateVos.add(deliverDateVo);
                }
                deliverVo.setDeliverId(deliverId);
                if (StringUtils.isNotEmpty((CharSequence)deliverDate)) {
                    deliverVo.setDeliverDate(deliverDate);
                    deliverVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDate));
                } else {
                    deliverVo.setDeliverDate(earliestDeliverDate);
                    deliverVo.setDeliverDateShow(DateUtils.getDateName((String)earliestDeliverDate));
                }
                deliverVo.setPickDate(earliestPickupDate);
                deliverVo.setDeliverEndTime(finishTime);
                deliverVo.setDelay(0);
                deliverVo.setDcId(kwId);
                int nomalInventory = 1;
                if (StringUtils.isEmpty((CharSequence)earliestDeliverDate)) {
                    nomalInventory = 0;
                }
                deliverVo.setNomalInventory(nomalInventory);
                int speedupInventory = 1;
                if ("0".equals(addressVo.getSpeedUp())) {
                    speedupInventory = 0;
                }
                if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0) {
                    speedupInventory = 0;
                }
                deliverVo.setSpeedupInventory(speedupInventory);
                int inventory = 1;
                if (nomalInventory != 1 && speedupInventory != 1) {
                    inventory = 0;
                }
                deliverVo.setInventory(inventory);
                deliverVo.setDeliverWeekShow(weekSetPickup);
                deliverDateVos.sort((f1, f2) -> f1.getDeliverDate().compareTo(f2.getDeliverDate()));
            } else {
                deliverVo.setDeliverDate(earliestDeliverDate);
                deliverVo.setPickDate(earliestPickupDate);
                deliverVo.setDeliverDateShow(DateUtils.getDateName((String)earliestDeliverDate));
                deliverVo.setDeliverEndTime(finishTime);
                deliverVo.setDeliverWeekShow(weekSetPickup);
            }
            deliverVo.setDeliverDateVos(deliverDateVos);
            if (jsonArrayProduct != null && jsonArrayProduct.size() > 0) {
                List deliverProductVoList = JSON.parseArray((String)jsonArrayProduct.toJSONString(), DeliverProductVo.class);
                this.logger.info("++++++++++++++++++++!!!!!!!!!!!!!getNoSeepUpProductDeliverByErp!!!!!!!!!!!!+++++++++++++++++++deliverProductVoList={}", (Object)JSON.toJSONString((Object)deliverProductVoList));
                if (deliverProductVoList != null && deliverProductVoList.size() > 0) {
                    DeliverEntity deliverEntity = new DeliverEntity();
                    ArrayList<GroupProductEntity> gpList = new ArrayList<GroupProductEntity>();
                    for (DeliverProductVo deliverProductVo : deliverProductVoList) {
                        GroupProductEntity groupProductEntity = new GroupProductEntity();
                        groupProductEntity.setDelay(deliverProductVo.getDelayDays());
                        groupProductEntity.setDelayDate(deliverProductVo.getDeliverDate());
                        groupProductEntity.setInventoryCount(deliverProductVo.getSalesCount());
                        groupProductEntity.setProductName(deliverProductVo.getProductName());
                        if (StringUtils.isNotEmpty((CharSequence)deliverProductVo.getBarCode())) {
                            groupProductEntity.setProductId(deliverProductVo.getProId());
                            if (deliverProductVo.getSalesCount() > 0) {
                                groupProductEntity.setInventory(1);
                            } else {
                                groupProductEntity.setInventory(0);
                            }
                        } else {
                            groupProductEntity.setInventory(-2);
                        }
                        gpList.add(groupProductEntity);
                    }
                    deliverEntity.setGpList(gpList);
                    this.gpListConvertCartVo(deliverEntity.getGpList(), shoppingcartVO, deliverVo);
                }
            }
            return deliverVo;
        }
        this.logger.info("*************************getNoSeepUpProductDeliverByErp************\u8c03\u7528erp3\u30020\u83b7\u53d6\u914d\u9001\u65e5\u671f\u5931\u8d25****success={},status={}", (Object)success, (Object)status);
        deliverVo.setInventory(-1);
        return deliverVo;
    }

    @Override
    public DeliverVo getDeliver(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo) {
        return this.getDeliverNew(shoppingcartVO, addressVo, "", true, -1);
    }

    @Override
    public DeliverVo getDeliver(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, int speedUp) {
        return this.getDeliverNew(shoppingcartVO, addressVo, "", true, speedUp);
    }

    @Override
    public DeliverVo getDeliver(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, Date deliverDate, int speedUp) {
        return this.getDeliverNew(shoppingcartVO, addressVo, DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd"), false, speedUp);
    }

    private DeliverVo getDeliverNew(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, boolean isCurrentDate, int speedUp) {
        DeliverVo deliverVo = new DeliverVo();
        switch (speedUp) {
            case -1: {
                this.getNomalDeliver(deliverVo, shoppingcartVO, addressVo, deliverDate, isCurrentDate);
                this.getDeliverSpeedup(deliverVo, shoppingcartVO, addressVo, deliverDate, isCurrentDate);
                break;
            }
            case 0: {
                this.getNomalDeliver(deliverVo, shoppingcartVO, addressVo, deliverDate, isCurrentDate);
                deliverVo.setSpeedupInventory(this.getDeliverSpeedup(new DeliverVo(), shoppingcartVO, addressVo, deliverDate, isCurrentDate).getSpeedupInventory());
                break;
            }
            case 1: {
                this.getDeliverSpeedup(deliverVo, shoppingcartVO, addressVo, deliverDate, isCurrentDate);
                deliverVo.setNomalInventory(this.getNomalDeliver(new DeliverVo(), shoppingcartVO, addressVo, deliverDate, isCurrentDate).getNomalInventory());
                break;
            }
        }
        return deliverVo;
    }

    private DeliverVo getDeliverSpeedup(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, boolean isCurrentDate) {
        if (addressVo == null || "0".equals(addressVo.getSpeedUp())) {
            return deliverVo;
        }
        if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0 && !this.getPrepositionCartProductsStock(addressVo.getSpeedUpWcId(), shoppingcartVO.getProductsPool()).isSuccess()) {
            return deliverVo;
        }
        deliverVo = deliverVo == null ? new DeliverVo() : deliverVo;
        deliverVo.setDeliverId("0");
        deliverVo.setDeliverName("\u7f8e\u56e2\u914d\u9001");
        deliverVo.setDeliverDate(DateUtils.date());
        deliverVo.setDeliverDateShow("\u7acb\u5373\u914d\u9001");
        deliverVo.setPickDate(DateUtils.date());
        deliverVo.setDeliverEndTime("22:00");
        deliverVo.setDelay(0);
        deliverVo.setDcId(addressVo.getSpeedUpWcId());
        deliverVo.setInventory(1);
        deliverVo.setSpeedupInventory(1);
        return deliverVo;
    }

    private DeliverVo getNomalDeliver(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, boolean isCurrentDate) {
        if (addressVo == null || StringUtils.isEmpty((CharSequence)addressVo.getAddrId())) {
            deliverVo.setNomalInventory(0);
            deliverVo.setInventory(-2);
        } else {
            BaseJsonVo checkResult;
            if (!addressVo.isEnable() && shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0) {
                Boolean[] hasCold = new Boolean[]{false};
                shoppingcartVO.getProductsPool().forEach(productVO -> {
                    if (productVO.getTransportType() == 1) {
                        deliverVo.setNomalInventory(0);
                        deliverVo.setInventory(-2);
                        hasCold[0] = true;
                        return;
                    }
                });
                if (hasCold[0].booleanValue()) {
                    deliverVo.setNomalInventory(0);
                    deliverVo.setInventory(-1);
                    return deliverVo;
                }
            }
            if ((checkResult = this.getDeliverProductSaleCheck(shoppingcartVO, addressVo, deliverDate, isCurrentDate)).isSuccess()) {
                deliverVo.setDeliverId("0");
                deliverVo.setDeliverName("");
                if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
                    deliverVo.setDeliverDate(StringUtils.isNotEmpty((CharSequence)deliverDate) ? deliverDate : DateUtils.date());
                    if (StringUtils.isEmpty((CharSequence)deliverDate)) {
                        ArrayList<DeliverDateVo> deliverDateVos = new ArrayList<DeliverDateVo>();
                        for (int i = 0; i < 7; ++i) {
                            DeliverDateVo deliverDateVo = new DeliverDateVo();
                            deliverDateVo.setInventory(1);
                            deliverDateVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)i), (String)"yyyy-MM-dd"));
                            deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((int)i));
                            deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)i)));
                            deliverDateVo.setSpeedUp(0);
                            deliverDateVo.setDeliverDateShow(DateUtils.formatDateChina((String)deliverDateVo.getDeliverDate(), (String)""));
                            deliverDateVos.add(deliverDateVo);
                        }
                        deliverVo.setDeliverDateVos(deliverDateVos);
                    }
                } else {
                    deliverVo.setDeliverDate(DateUtils.date());
                }
                deliverVo.setDeliverDateShow("\u5c3d\u5feb\u53d1\u8d27");
                if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
                    deliverVo.setPickDate(deliverDate);
                } else {
                    deliverVo.setPickDate(DateUtils.date());
                }
                deliverVo.setDeliverEndTime("24:00");
                deliverVo.setNomalInventory(1);
                deliverVo.setInventory(1);
            } else {
                deliverVo.setNomalInventory(0);
                deliverVo.setInventory(0);
            }
        }
        return deliverVo;
    }

    private BaseJsonVo getDeliverProductSaleCheck(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, boolean isCurrentDate) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0) {
            List<MallProductVO> productPool = shoppingcartVO.getProductsPool();
            for (MallProductVO product : productPool) {
                if (map.containsKey(product.getProId())) {
                    map.put(product.getProId(), (Integer)map.get(product.getProId()) + product.getCount());
                    continue;
                }
                map.put(product.getProId(), product.getCount());
            }
        }
        return this.productSalesService.checkSalesNum(map, addressVo.getCityId());
    }

    @Override
    public DeliverVo getDeliver(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, boolean isCurrentDate) {
        DeliverVo deliverVo = new DeliverVo();
        int transTypeId = this.productInterface.getTransportType(shoppingcartVO);
        if (isCurrentDate) {
            deliverDate = DateUtils.date();
        }
        if (shoppingcartVO.getOrderSource() == OrderSourceEnum.PLEASE_MILK.getValue() || shoppingcartVO.getOrderSource() == OrderSourceEnum.STORE_BUY.getValue()) {
            deliverVo.setDeliverDate(deliverDate);
            deliverVo.setPickDate(deliverDate);
            deliverVo.setInventory(1);
            return deliverVo;
        }
        boolean addressEnable = addressVo == null ? false : addressVo.isEnable();
        String address = addressVo == null ? "" : addressVo.getAddress();
        int areaId = addressVo == null ? 0 : addressVo.getAreaId();
        String url = this.oldApiHost + "malldeliver/getdelivernew";
        DeliverParamVo paramVo = new DeliverParamVo();
        paramVo.setAddress(address);
        paramVo.setAreaId(String.valueOf(areaId));
        if (shoppingcartVO != null) {
            paramVo.setChannelId(String.valueOf(this.tradeCommonInterface.platformConvertChannel(shoppingcartVO.getPlatFormId())));
            if (paramVo.getChannelId().equals("0")) {
                deliverVo.setBaseError("\u6e20\u9053\u6ca1\u6709\u5b9a\u4e49");
                return deliverVo;
            }
        } else {
            paramVo.setChannelId("1");
        }
        paramVo.setIsCurrentDate(String.valueOf(isCurrentDate));
        paramVo.setDevliverDate(deliverDate);
        if (shoppingcartVO != null) {
            paramVo.setLongPeriod(shoppingcartVO.getDeliverCount() > 1 ? "1" : "0");
        } else {
            paramVo.setLongPeriod("0");
        }
        paramVo.setGroupProductEntities(this.convertToGroupProduct(shoppingcartVO));
        String param = ObjectConvert.objectConvertToUrpParam((Object)paramVo);
        param = param.replace("transport_TYPE", "transportType");
        String result = "";
        if (result == null || result.isEmpty()) {
            HashMap<String, String> param1 = new HashMap<String, String>();
            param1.put("areaId", String.valueOf(areaId));
            param1.put("devliverDate", deliverDate);
            param1.put("isCurrentDate", String.valueOf(isCurrentDate));
            param1.put("address", address);
            param1.put("channelId", String.valueOf(this.tradeCommonInterface.platformConvertChannel(shoppingcartVO.getPlatFormId())));
            param1.put("longPeriod", shoppingcartVO.getDeliverCount() > 1 ? "1" : "0");
            String groupProductEntitiesKey = IDGenerate.getUniqueIdStr();
            if (this.oldApiHost.contains("apitest.lechun.cc")) {
                groupProductEntitiesKey = "test" + groupProductEntitiesKey;
            }
            this.logger.info("\u5e93\u5b58key\uff1a" + groupProductEntitiesKey);
            this.memcachedService.set(groupProductEntitiesKey, (Object)JsonUtils.toJson(this.convertToGroupProduct(shoppingcartVO), (boolean)false).replace("transport_TYPE", "transportType"));
            param1.put("groupProductEntitiesKey", groupProductEntitiesKey.replace("test", ""));
            if (((String)param1.get("channelId")).equals("0")) {
                deliverVo.setBaseError("\u6e20\u9053\u6ca1\u6709\u5b9a\u4e49");
                return deliverVo;
            }
            HttpRequest request = new HttpRequest(url, param1);
            request.setMethod("POST");
            request.setConnectTimeout(30000);
            result = HttpComponentUtil.execute((HttpRequest)request);
        }
        this.logger.info("\u7528\u6237" + shoppingcartVO.getCustomerId() + "\u8c03\u7528getDeliverNew\uff0c\u8bf7\u6c42\u7ed3\u679c \uff1a" + result);
        try {
            if ((result == null || result.isEmpty()) && ((result = HttpRequest.post((String)url, (String)param)) == null || result.isEmpty())) {
                deliverVo.setBaseError("\u5f97\u5230\u914d\u9001\u6570\u636e\u4e3a\u7a7a");
                return deliverVo;
            }
            DeliverEntity deliverEntity = (DeliverEntity)JSONObject.toJavaObject((JSON)JSON.parseObject((String)result), DeliverEntity.class);
            if (deliverEntity != null) {
                ArrayList<DeliverDateVo> deliverDateVos = new ArrayList<DeliverDateVo>();
                if (deliverEntity.getDates() != null) {
                    for (String k : deliverEntity.getDates().keySet()) {
                        DeliverDateVo deliverDateVo = new DeliverDateVo();
                        deliverDateVo.setDeliverDate(k.split("\\|")[0]);
                        deliverDateVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDateVo.getDeliverDate()));
                        deliverDateVo.setInventory(Integer.parseInt(deliverEntity.getDates().get(k)));
                        deliverDateVo.setSpeedUp(deliverDateVo.getDeliverDate().equals(DateUtils.date()) ? 1 : 0);
                        deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                        deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverDateVo.getDeliverDate(), (String)"yyyy-MM-dd")));
                        deliverDateVos.add(deliverDateVo);
                        deliverDateVos.sort((f1, f2) -> f1.getDeliverDate().compareTo(f2.getDeliverDate()));
                    }
                }
                if (deliverDateVos != null && deliverDateVos.size() == 8 && ((DeliverDateVo)deliverDateVos.get(0)).getInventory() == 1) {
                    deliverEntity.setDelviverDate(DateUtils.date());
                }
                deliverVo.setDelay(deliverEntity.getDelay());
                deliverVo.setDeliverDate(deliverEntity.getDelviverDate());
                if (deliverEntity.getDelviverDate() != null) {
                    deliverVo.setDeliverDateShow(DateUtils.getDateName((String)deliverEntity.getDelviverDate()));
                    if (transTypeId == TransportTypeEnum.NORMAL_CHAIN.getValue()) {
                        deliverVo.setDeliverDateShow("\u9884\u8ba1" + DateUtils.getDateName((String)deliverEntity.getPickDate()) + "\u53d1\u8d27");
                    }
                    deliverVo.setDeliverWeekShow(DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverEntity.getDelviverDate(), (String)"yyyy-MM-dd")));
                }
                deliverVo.setDeliverDateVos(deliverDateVos);
                deliverVo.setDeliverEndTime(deliverEntity.getAddressEndTime());
                deliverVo.setDeliverId(String.valueOf(deliverEntity.getDeliverId()));
                deliverVo.setDeliverName(deliverEntity.getDelivername());
                DeliverFreightVo deliverFreightVo = new DeliverFreightVo();
                if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
                    deliverVo.setPickDate(deliverDate);
                } else {
                    deliverVo.setPickDate(DateUtils.date());
                }
                deliverVo.setDcId(StringUtils.isEmpty((CharSequence)deliverEntity.getPrepositionId()) ? deliverEntity.getDcId() : deliverEntity.getPrepositionId());
                if (deliverEntity.getDeliverId() == 0) {
                    if (areaId == 0) {
                        deliverVo.setInventory(-2);
                    } else {
                        if (deliverEntity.getErrMessage().equals("100") || !addressEnable) {
                            deliverVo.setInventory(-1);
                        }
                        if (deliverEntity.getErrMessage().equals("101")) {
                            deliverVo.setInventory(0);
                        }
                    }
                } else if (!addressEnable) {
                    deliverVo.setInventory(-1);
                } else {
                    deliverVo.setInventory(1);
                }
                this.gpListConvertCartVo(deliverEntity.getGpList(), shoppingcartVO, deliverVo);
            } else {
                deliverVo.setInventory(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            this.logger.error("\u5f97\u5230\u914d\u9001\u6570\u636e\u9519\u8bef", (Throwable)e);
            deliverVo.setBaseError("\u5f97\u5230\u914d\u9001\u6570\u636e\u9519\u8bef");
        }
        return deliverVo;
    }

    private void gpListConvertCartVo(List<GroupProductEntity> gpList, MallShoppingcartVO shoppingcartVO, DeliverVo deliverVo) {
        this.logger.info("~~~~~~~~~~~~~~~~\u8fdb\u5165gpListConvertCartVo\u7684\u53c2\u6570~~~~~~~~~~~~~~~~~~~~~~~gpList={},shoppingcartVO={},deliverVo={}", new Object[]{JSON.toJSONString(gpList), JSON.toJSONString((Object)shoppingcartVO), JSON.toJSONString((Object)deliverVo)});
        for (GroupProductEntity g : gpList) {
            MallProductVO productVO;
            List<MallProductVO> productVOs;
            List productVOs2;
            if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0 && (productVOs2 = shoppingcartVO.getProductsPool().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() > 0) {
                this.getProductVoDeliver((MallProductVO)productVOs2.get(0), g, deliverVo);
            }
            if (shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() > 0 && (productVOs2 = shoppingcartVO.getProducts().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() > 0) {
                this.getProductVoDeliver((MallProductVO)productVOs2.get(0), g, deliverVo);
            }
            if (shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
                for (MallGroupVO group : shoppingcartVO.getGroups()) {
                    productVOs = group.getProductList().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList());
                    if (productVOs.size() <= 0) continue;
                    productVO = productVOs.get(0);
                    this.getProductVoDeliver(productVO, g, deliverVo);
                    this.getGroupVoDeliver(group, productVO, g, deliverVo);
                }
            }
            if (shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
                for (MallPromotionVO p : shoppingcartVO.getPromotions()) {
                    if (p.getProduct() != null) {
                        this.getProductVoDeliver(p.getProduct(), g, deliverVo);
                        this.getPromotionVoDeliver(p, p.getProduct(), g, deliverVo);
                    }
                    if (p.getGroup() == null || (productVOs = p.getGroup().getProductList().stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() <= 0) continue;
                    productVO = productVOs.get(0);
                    this.getGroupVoDeliver(p.getGroup(), productVO, g, deliverVo);
                    this.getPromotionVoDeliver(p, p.getGroup(), g, deliverVo);
                }
            }
            if (shoppingcartVO.getFrees() == null || shoppingcartVO.getFrees().size() <= 0) continue;
            for (MallFreeVO f : shoppingcartVO.getFrees()) {
                productVOs = f.getProductList();
                if ((productVOs = productVOs.stream().filter(c -> c.getProId().equals(g.getProductId())).collect(Collectors.toList())).size() <= 0) continue;
                productVO = productVOs.get(0);
                this.getFreeVoDeliver(f, productVO, g, deliverVo);
            }
        }
    }

    private void getProductVoDeliver(MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo) {
        this.logger.info("=========_+++++++++++++++getProductVoDeliver++++++++++++++++++==========productVO={},GroupProductEntity={},deliverVo={}", new Object[]{JSON.toJSONString((Object)productVO), JSON.toJSONString((Object)g), JSON.toJSONString((Object)deliverVo)});
        if (productVO != null) {
            if (deliverVo.getInventory() == 0) {
                productVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                productVO.setShort(g.getInventoryCount() < 5);
            } else {
                productVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                productVO.setShort(g.getInventoryCount() < 5);
            }
            productVO.setDelay(g.getDelay() > 0);
            productVO.setDelayDays(g.getDelay());
            productVO.setDelayDate(g.getDelayDate());
        }
    }

    private void getGroupVoDeliver(MallGroupVO groupVO, MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo) {
        if (productVO != null) {
            if (groupVO.getSoldOut() == null || !groupVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    groupVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    groupVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (groupVO.getShort() == null || !groupVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    groupVO.setShort(g.getInventoryCount() < 5);
                } else {
                    groupVO.setShort(false);
                }
            }
            if (groupVO.getDelay() == null || !groupVO.getDelay().booleanValue()) {
                groupVO.setDelay(g.getDelay() > 0);
            }
            if (groupVO.getDelayDays() == null || groupVO.getDelayDays() < g.getDelay()) {
                groupVO.setDelayDays(g.getDelay());
                groupVO.setDelayDate(g.getDelayDate());
            }
        }
    }

    private void getFreeVoDeliver(MallFreeVO freeVO, MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo) {
        if (productVO != null) {
            if (freeVO.getSoldOut() == null || !freeVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    freeVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    freeVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (freeVO.getShort() == null || !freeVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    freeVO.setShort(g.getInventoryCount() < 5);
                } else {
                    freeVO.setShort(false);
                }
            }
        }
    }

    private void getPromotionVoDeliver(MallPromotionVO promotionVO, MallGroupVO productVO, GroupProductEntity g, DeliverVo deliverVo) {
        if (productVO != null) {
            if (promotionVO.getSoldOut() == null || !promotionVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    promotionVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (promotionVO.getShort() == null || !promotionVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setShort(g.getInventoryCount() < 5);
                } else {
                    promotionVO.setShort(false);
                }
            }
            if (promotionVO.getDelay() == null || !promotionVO.getDelay().booleanValue()) {
                promotionVO.setDelay(g.getDelay() > 0);
            }
            if (promotionVO.getDelayDays() == null || promotionVO.getDelayDays() < g.getDelay()) {
                promotionVO.setDelayDays(g.getDelay());
                promotionVO.setDelayDate(g.getDelayDate());
            }
        }
    }

    private void getPromotionVoDeliver(MallPromotionVO promotionVO, MallProductVO productVO, GroupProductEntity g, DeliverVo deliverVo) {
        if (productVO != null) {
            if (promotionVO.getSoldOut() == null || !promotionVO.getSoldOut().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                } else {
                    promotionVO.setSoldOut(g.getInventory() == 0 || productVO.getCount() > g.getInventoryCount());
                }
            }
            if (promotionVO.getShort() == null || !promotionVO.getShort().booleanValue()) {
                if (deliverVo.getInventory() == 0) {
                    promotionVO.setShort(g.getInventoryCount() < 5);
                } else {
                    promotionVO.setShort(false);
                }
            }
            if (promotionVO.getDelay() == null || !promotionVO.getDelay().booleanValue()) {
                promotionVO.setDelay(g.getDelay() > 0);
            }
            if (promotionVO.getDelayDays() == null || promotionVO.getDelayDays() < g.getDelay()) {
                promotionVO.setDelayDays(g.getDelay());
                promotionVO.setDelayDate(g.getDelayDate());
            }
        }
    }

    private List<GroupProductEntity> convertToGroupProduct(MallShoppingcartVO shoppingcartVO) {
        ArrayList<GroupProductEntity> groupProductEntities = new ArrayList<GroupProductEntity>();
        int transportType = this.productInterface.getTransportType(shoppingcartVO);
        if (shoppingcartVO == null) {
            return null;
        }
        if (shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
            shoppingcartVO.getGroups().forEach(c -> {
                List gplist = groupProductEntities.stream().filter(g -> g.getGroupId().equals(c.getGroupId())).collect(Collectors.toList());
                if (gplist != null && gplist.size() > 0) {
                    ((GroupProductEntity)gplist.get(0)).setQuantity(((GroupProductEntity)gplist.get(0)).getQuantity() + c.getCount());
                }
                GroupProductEntity groupProductEntity = new GroupProductEntity();
                groupProductEntity.setBindCode(shoppingcartVO.getBindCode());
                groupProductEntity.setFactPrice(c.getFactPrice().floatValue());
                groupProductEntity.setDeliverCount(shoppingcartVO.getDeliverCount());
                groupProductEntity.setGroupType(2);
                groupProductEntity.setPrice(c.getSalePrice().floatValue());
                groupProductEntity.setGroupId(c.getGroupId());
                groupProductEntity.setProductName(c.getGroupName());
                groupProductEntity.setProOtherName(c.getGroupOtherName());
                groupProductEntity.setProState(c.getStatus());
                groupProductEntity.setQuantity(c.getCount());
                groupProductEntity.setTRANSPORT_TYPE(transportType);
                groupProductEntity.setUnit(c.getGroupUnit());
                groupProductEntities.add(groupProductEntity);
            });
        }
        if (shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
            shoppingcartVO.getPromotions().forEach(c -> {
                List gplist = groupProductEntities.stream().filter(g -> g.getPromotionId().equals(c.getPromotionId())).collect(Collectors.toList());
                if (gplist != null && gplist.size() > 0) {
                    ((GroupProductEntity)gplist.get(0)).setQuantity(((GroupProductEntity)gplist.get(0)).getQuantity() + c.getCount());
                }
                GroupProductEntity groupProductEntity = new GroupProductEntity();
                groupProductEntity.setBindCode(shoppingcartVO.getBindCode());
                groupProductEntity.setFactPrice(c.getFactPrice().floatValue());
                groupProductEntity.setDeliverCount(shoppingcartVO.getDeliverCount());
                groupProductEntity.setGroupType(1);
                groupProductEntity.setPrice(c.getOriginPrice().floatValue());
                String productIds = "";
                String groupId = "";
                if (c.getProduct() != null) {
                    productIds = c.getProduct().getProId();
                    groupProductEntity.setProductId(productIds);
                } else if (c.getGroup() != null) {
                    groupId = c.getGroup().getGroupId();
                    groupProductEntity.setGroupId(groupId);
                } else {
                    return;
                }
                groupProductEntity.setProductName(c.getPromotionName());
                groupProductEntity.setProOtherName(c.getPromotionName());
                groupProductEntity.setProState(c.getStatus());
                groupProductEntity.setQuantity(c.getCount());
                groupProductEntity.setTRANSPORT_TYPE(transportType);
                groupProductEntity.setUnit(c.getPromotionUnit());
                groupProductEntity.setPromotionId(c.getPromotionId());
                MallPromotionProductEntity promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(c.getPromotionId());
                groupProductEntity.setPromotionProductId(promotionProductEntity != null ? promotionProductEntity.getPromotionProductId() : "");
                groupProductEntities.add(groupProductEntity);
            });
        }
        if (shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() > 0) {
            shoppingcartVO.getProducts().forEach(c -> {
                List gplist = groupProductEntities.stream().filter(g -> g.getProductId().equals(c.getProId())).collect(Collectors.toList());
                if (gplist != null && gplist.size() > 0) {
                    ((GroupProductEntity)gplist.get(0)).setQuantity(((GroupProductEntity)gplist.get(0)).getQuantity() + c.getCount());
                }
                GroupProductEntity groupProductEntity = new GroupProductEntity();
                groupProductEntity.setBindCode(shoppingcartVO.getBindCode());
                groupProductEntity.setFactPrice(c.getFactPrice().floatValue());
                groupProductEntity.setDeliverCount(shoppingcartVO.getDeliverCount());
                groupProductEntity.setGroupType(4);
                groupProductEntity.setPrice(Float.parseFloat(c.getProPrice()));
                groupProductEntity.setProductId(c.getProId());
                groupProductEntity.setProductName(c.getProName());
                groupProductEntity.setProductTypeId(c.getProTypeId());
                groupProductEntity.setProOtherName(c.getProOtherName());
                groupProductEntity.setProState(c.getProState());
                groupProductEntity.setQuantity(c.getCount());
                groupProductEntity.setTRANSPORT_TYPE(transportType);
                groupProductEntity.setUnit(c.getProDw());
                groupProductEntities.add(groupProductEntity);
            });
        }
        if (shoppingcartVO.getFrees() != null && shoppingcartVO.getFrees().size() > 0) {
            shoppingcartVO.getFrees().forEach(c -> {
                for (MallProductVO v : c.getProductList()) {
                    GroupProductEntity groupProductEntity = new GroupProductEntity();
                    groupProductEntity.setBindCode(shoppingcartVO.getBindCode());
                    groupProductEntity.setFactPrice(v.getFactPrice().floatValue());
                    groupProductEntity.setDeliverCount(shoppingcartVO.getDeliverCount());
                    groupProductEntity.setGroupType(4);
                    groupProductEntity.setPrice(Float.parseFloat(v.getProPrice()));
                    groupProductEntity.setProductId(v.getProId());
                    groupProductEntity.setProductName(v.getProName());
                    groupProductEntity.setProductTypeId(v.getProTypeId());
                    groupProductEntity.setProOtherName(v.getProOtherName());
                    groupProductEntity.setProState(v.getProState());
                    groupProductEntity.setQuantity(v.getCount());
                    groupProductEntity.setTRANSPORT_TYPE(transportType);
                    groupProductEntity.setUnit(v.getProDw());
                    groupProductEntities.add(groupProductEntity);
                }
            });
        }
        return groupProductEntities;
    }

    @Override
    public void orderPackage(String orderNos) {
        String url = this.oldApiHost + "mallorder/orderPackage";
        HashMap<String, String> param1 = new HashMap<String, String>();
        param1.put("orderNos", orderNos);
        HttpRequest request = new HttpRequest(url, param1);
        String result = HttpComponentUtil.execute((HttpRequest)request);
        this.logger.info(orderNos + "\u62c6\u5305\u5b8c\u6210\uff0c\u62c6\u5305\u7ed3\u679c\u4e3a\uff1a" + result);
    }

    @Override
    public BaseJsonVo createPrepositionOrder(String orderMainNo) {
        try {
            List<MallOrderEntity> ls = this.mallOrderInterface.findOrders(orderMainNo);
            if (ls != null && ls.size() > 0) {
                for (MallOrderEntity mallOrderEntity : ls) {
                    SysKwEntity kw;
                    if (!StringUtils.isNotEmpty((CharSequence)mallOrderEntity.getDcId()) || (kw = (SysKwEntity)this.sysKwMapper.selectByPrimaryKey((Serializable)((Object)mallOrderEntity.getDcId()))) == null || kw.getIspreposition() != 1) continue;
                    String url = this.oldApiHost + "preposition/mtCreateOrderByShop";
                    HashMap<String, String> param1 = new HashMap<String, String>();
                    param1.put("orderid", mallOrderEntity.getOrderNo());
                    param1.put("shopid", mallOrderEntity.getDcId());
                    HttpRequest request = new HttpRequest(url, param1);
                    String result = HttpComponentUtil.execute((HttpRequest)request);
                    this.logger.info("\u521b\u5efa\u524d\u7f6e\u4ed3\u8ba2\u5355orderMainNo : " + result);
                    Map map = null;
                    if (StringUtils.isNotEmpty((CharSequence)result)) {
                        map = (Map)JsonUtils.fromJson((String)result, Map.class);
                    }
                    if (map == null || "0".equals(String.valueOf(map.get("code")))) continue;
                    this.logger.error("\u521b\u5efa\u524d\u7f6e\u4ed3\u8ba2\u5355\u5931\u8d25", (Object)result);
                    return BaseJsonVo.error((String)String.valueOf(map.get("code")));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u524d\u7f6e\u4ed3\u8ba2\u5355", (Throwable)e);
            return BaseJsonVo.error((String)"\u521b\u5efa\u524d\u7f6e\u4ed3\u8ba2\u5355\u5931\u8d25");
        }
        this.logger.info("\u521b\u5efa\u524d\u7f6e\u4ed3\u8ba2\u53553");
        return BaseJsonVo.success((Object)"\u521b\u5efa\u524d\u7f6e\u4ed3\u8ba2\u5355\u6210\u529f");
    }

    @Override
    public BaseJsonVo cacelPrepositionOrder(String orderMainNo) {
        try {
            List<MallOrderEntity> ls = this.mallOrderInterface.findOrders(orderMainNo);
            if (ls != null && ls.size() > 0) {
                for (MallOrderEntity mallOrderEntity : ls) {
                    SysKwEntity kw = (SysKwEntity)this.sysKwMapper.selectByPrimaryKey((Serializable)((Object)mallOrderEntity.getDcId()));
                    if (kw.getIspreposition() != 1) continue;
                    String url = this.oldApiHost + "preposition/mtCancelOrder";
                    HashMap<String, String> param1 = new HashMap<String, String>();
                    param1.put("orderid", mallOrderEntity.getOrderNo());
                    HttpRequest request = new HttpRequest(url, param1);
                    String result = HttpComponentUtil.execute((HttpRequest)request);
                    this.logger.info("\u53d6\u6d88\u524d\u7f6e\u4ed3\u8ba2\u5355" + result);
                    if ("0".equals(result)) continue;
                    this.logger.error("\u53d6\u6d88\u524d\u7f6e\u4ed3\u8ba2\u5355", (Object)result);
                    return BaseJsonVo.error((String)"\u53d6\u6d88\u524d\u7f6e\u4ed3\u8ba2\u5355\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u53d6\u6d88\u524d\u7f6e\u4ed3\u8ba2\u5355", (Throwable)e);
            return BaseJsonVo.error((String)"\u53d6\u6d88\u524d\u7f6e\u4ed3\u8ba2\u5355\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"\u53d6\u6d88\u524d\u7f6e\u4ed3\u8ba2\u5355\u6210\u529f");
    }

    @Override
    public BaseJsonVo getPrepositionKW(@ParameterValueKeyProvider(order=0) String areaId, @ParameterValueKeyProvider(order=1) String addr) {
        String addrMD5 = DigestUtils.md5Hex((String)addr);
        String jsonreturn = (String)this.memcachedService.get("SPEEDUP_GET_KW_", areaId + "|" + addrMD5);
        if (StringUtils.isNotEmpty((CharSequence)jsonreturn)) {
            if ("-1".equals(jsonreturn)) {
                return BaseJsonVo.error((String)"\u5730\u5740\u6216\u533aID\u4e3a\u7a7a");
            }
            if ("-2".equals(jsonreturn)) {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u524d\u7f6e\u4ed3\u6216\u4e0d\u5728\u524d\u7f6e\u4ed3\u8303\u56f4\u5185");
            }
            return BaseJsonVo.success((Object)jsonreturn);
        }
        if (StringUtils.isEmpty((CharSequence)areaId) || StringUtils.isEmpty((CharSequence)addr)) {
            this.memcachedService.set("SPEEDUP_GET_KW_", areaId + "|" + addrMD5, (Object)"-1", 900);
            return BaseJsonVo.error((String)"\u5730\u5740\u6216\u533aID\u4e3a\u7a7a");
        }
        String kwUrl = this.oldApiHost + "malldeliver/getJishudaKw";
        DeliverParamVo paramVo = new DeliverParamVo();
        paramVo.setAddress(addr);
        paramVo.setAreaId(areaId);
        HttpRequest request = new HttpRequest(kwUrl, (Object)paramVo);
        request.setMethod("POST");
        request.setConnectTimeout(30000);
        String kwResult = "";
        kwResult = HttpComponentUtil.execute((HttpRequest)request);
        if (StringUtils.isNotBlank((CharSequence)kwResult)) {
            String kwIdStr = "";
            try {
                JSONObject kwIdJson = JSON.parseObject((String)kwResult);
                kwIdStr = kwIdJson.getString("kw_id");
            }
            catch (Exception e) {
                this.logger.error(">>>>>>>>>>>>>>>>>>getPrepositionKW, \u5730\u5740\u4e3a\uff1a " + areaId + ";" + addr + ", \u8c03\u7528getJishudaKw\u8fd4\u56de\u503c \uff1a" + kwResult + ",err:" + e.getMessage());
                e.printStackTrace();
            }
            if (StringUtils.isNotEmpty((CharSequence)kwIdStr)) {
                Boolean b = this.memcachedService.set("SPEEDUP_GET_KW_", areaId + "|" + addrMD5, (Object)kwIdStr, 900);
                return BaseJsonVo.success((Object)kwIdStr);
            }
        }
        this.memcachedService.set("SPEEDUP_GET_KW_", areaId + "|" + addrMD5, (Object)"-2", 900);
        return BaseJsonVo.error((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u524d\u7f6e\u4ed3\u6216\u4e0d\u5728\u524d\u7f6e\u4ed3\u8303\u56f4\u5185");
    }

    @Override
    public BaseJsonVo getPrepositionProducts(@ParameterValueKeyProvider(order=0) String kwId) {
        this.logger.info(">>>>>>>>>>>>>>>>\u67e5\u8be2\u7684\u662f\u8fd9\u4e2a\u5e93\u7684\u5e93\u5b58:" + kwId);
        HashMap<String, String> map = new HashMap<String, String>();
        String productUrl = this.oldApiHost + "malldeliver/getJishudaProList";
        map.put("kw_id", kwId);
        HttpRequest prodRequest = new HttpRequest(productUrl, map);
        prodRequest.setMethod("POST");
        prodRequest.setConnectTimeout(30000);
        String prodResult = "";
        prodResult = HttpComponentUtil.execute((HttpRequest)prodRequest);
        this.logger.info("getProductStock, \u8c03\u7528getJishudaProList\u7684\u53c2\u6570\u3010" + kwId + "\u3011\uff0c\u8fd4\u56de\u503c \uff1a" + prodResult);
        ArrayList<Map> kwProductList = new ArrayList<Map>();
        if (StringUtils.isNotBlank((CharSequence)prodResult)) {
            JSONObject prodObject = JSON.parseObject((String)prodResult);
            JSONArray prodInfo = new ArrayList();
            prodInfo = prodObject.getJSONArray("proList");
            ArrayList objects = new ArrayList();
            if (prodInfo != null && prodInfo.size() > 0) {
                int i = 0;
                for (Object objectPro : prodInfo) {
                    ++i;
                    Map ret = (Map)objectPro;
                    kwProductList.add(ret);
                }
            }
        }
        return BaseJsonVo.success(kwProductList);
    }

    @Override
    public BaseJsonVo getPrepositionProductStock(String kwId, String productId) {
        List kwProductList;
        BaseJsonVo prosResult = this.getPrepositionProducts(kwId);
        if (prosResult.isSuccess() && (kwProductList = (List)prosResult.getValue()).size() > 0) {
            for (Map map : kwProductList) {
                if (!productId.equals(map.get("proid"))) continue;
                return BaseJsonVo.success((Object)(map.get("count") != null ? Integer.valueOf(map.get("count").toString()) : 0));
            }
        }
        return BaseJsonVo.success((Object)0);
    }

    @Override
    public int getProductStock(String customerId, String productId) {
        String kwId;
        HashMap proInfoMap = new HashMap();
        CustomerAddressEntity addressVo = null;
        try {
            addressVo = this.addressService.getCustomerDefaultAddress(customerId, "", "", "", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (addressVo == null || addressVo.getAreaId() == null || StringUtils.isEmpty((CharSequence)addressVo.getAddress()) || "0".equals(((CustomerAddressVo)addressVo).getSpeedUp())) {
            return 0;
        }
        BaseJsonVo kwResult = this.getPrepositionKW(String.valueOf(addressVo.getAreaId()), addressVo.getAddress());
        if (kwResult.isSuccess() && StringUtils.isNotBlank((CharSequence)(kwId = (String)kwResult.getValue()))) {
            return (Integer)this.getPrepositionProductStock(kwId, productId).getValue();
        }
        return 0;
    }

    @Override
    public BaseJsonVo getPrepositionIndexProductsStock(String customerId, int platformId, IndexNavVo vo) {
        BaseJsonVo prosResult;
        String kwId;
        this.logger.info("=======================getPrepositionIndexProductsStock========================{}", (Object)JSON.toJSONString((Object)vo));
        CustomerAddressEntity addressVo = null;
        try {
            addressVo = this.addressService.getCustomerDefaultAddress(customerId, "", "", "", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (addressVo == null || addressVo.getAreaId() == null || StringUtils.isEmpty((CharSequence)addressVo.getAddress())) {
            return BaseJsonVo.success((Object)vo);
        }
        BaseJsonVo kwResult = this.getPrepositionKW(String.valueOf(addressVo.getAreaId()), addressVo.getAddress());
        if (kwResult.isSuccess() && StringUtils.isNotBlank((CharSequence)(kwId = (String)kwResult.getValue())) && (prosResult = this.getPrepositionProducts(kwId)).isSuccess()) {
            List kwProductList = (List)prosResult.getValue();
            ArrayList<Object> objects = new ArrayList<Object>();
            if (kwProductList.size() > 0) {
                int i = 0;
                for (Object objectPro : kwProductList) {
                    ++i;
                    Map ret = (Map)objectPro;
                    String proid = ret.get("proid").toString();
                    String proCount = ret.get("count").toString();
                    this.logger.info("=====\u83b7\u53d6\u7684\u5546\u54c1\u4fe1\u606fproId={}\u548ccount={}=====", (Object)proid, (Object)proCount);
                    IndexItemEntity indexItemEntity = new IndexItemEntity();
                    indexItemEntity.setNavId(vo.getIndexNavId());
                    indexItemEntity.setItemType("4");
                    indexItemEntity.setItemSn(i);
                    indexItemEntity.setProId(proid);
                    indexItemEntity.setBuildPageId(129);
                    indexItemEntity.setDetailBuildPageId(0);
                    MallIndexProductVo indexProductVo = this.getIndexProduct(customerId, platformId, indexItemEntity);
                    if (indexProductVo == null) continue;
                    indexProductVo.setSpeedUp("1");
                    indexProductVo.setSpeedupStockNum(Integer.valueOf(proCount));
                    if (indexProductVo == null) continue;
                    objects.add(indexProductVo);
                }
                vo.setItems(objects);
            }
        }
        return BaseJsonVo.success((Object)vo);
    }

    @Override
    public BaseJsonVo getPrepositionCartProductsStock(String kwid, List<MallProductVO> productVos) {
        BaseJsonVo kwJson = this.getPrepositionProducts(kwid);
        if (kwJson.isSuccess()) {
            List kwProductList = (List)kwJson.getValue();
            Boolean exits = true;
            for (MallProductVO pro : productVos) {
                Optional<Map> aa1 = kwProductList.parallelStream().filter(kwPro -> pro.getProId().equals(kwPro.get("proid")) && Integer.valueOf((String)kwPro.get("count")) >= pro.getCount()).findAny();
                if (aa1.isPresent()) continue;
                return BaseJsonVo.error((String)("\u5546\u54c1" + pro.getProName() + "(" + pro.getProId() + ")\u5728\u524d\u7f6e\u4ed3" + kwid + "\u5e93\u5b58\u4e0d\u8db3"));
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u83b7\u53d6\u524d\u7f6e\u4ed3\u5546\u54c1\u9519\u8bef");
    }

    private MallIndexProductVo getIndexProduct(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        BaseJsonVo baseJsonVo;
        MallIndexProductVo indexProductVo = null;
        if (indexItemEntity != null && (baseJsonVo = this.productInterface.buildIndexProductVo(indexItemEntity.getProId(), customerId)).isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexProductVo = (MallIndexProductVo)baseJsonVo.getValue();
            indexProductVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexProductVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexProductVo.setModuleId(indexItemEntity.getBuildPageId());
            indexProductVo.setItemSn(indexItemEntity.getItemSn());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexProductVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexProductVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexProductVo;
    }

    public String getItemDetailUrl(String modulePath, int platformId, String navId, int itemType, String itemId) {
        return modulePath + platformId + "_" + navId + "_" + itemType + "_" + itemId + ".html";
    }

    @Override
    public MallDeliverEntity getDeliverSigle(int deliverId) {
        return (MallDeliverEntity)this.deliverMapper.selectByPrimaryKey(Integer.valueOf(deliverId));
    }

    @Override
    public MallDeliverEntity getDeliverSigle(MallDeliverEntity deliverEntity) {
        return (MallDeliverEntity)this.deliverMapper.getSingle(deliverEntity);
    }

    @Override
    public BaseJsonVo insertDeliver(MallDeliverEntity deliverEntity) {
        int i = this.deliverMapper.insertSelective(deliverEntity);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u6dfb\u52a0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo updateDeliver(MallDeliverEntity deliverEntity) {
        int i = this.deliverMapper.updateByPrimaryKeySelective(deliverEntity);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    public class DeliverParamVo
    implements Serializable {
        private String areaId;
        private String devliverDate;
        private String isCurrentDate;
        private String address;
        private String channelId;
        private String longPeriod;
        private List<GroupProductEntity> groupProductEntities;
        private static final long serialVersionUID = 1L;

        public String getAreaId() {
            return this.areaId;
        }

        public void setAreaId(String areaId) {
            this.areaId = areaId;
        }

        public String getDevliverDate() {
            return this.devliverDate;
        }

        public void setDevliverDate(String devliverDate) {
            this.devliverDate = devliverDate;
        }

        public String getIsCurrentDate() {
            return this.isCurrentDate;
        }

        public void setIsCurrentDate(String isCurrentDate) {
            this.isCurrentDate = isCurrentDate;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public String getLongPeriod() {
            return this.longPeriod;
        }

        public void setLongPeriod(String longPeriod) {
            this.longPeriod = longPeriod;
        }

        public List<GroupProductEntity> getGroupProductEntities() {
            return this.groupProductEntities;
        }

        public void setGroupProductEntities(List<GroupProductEntity> groupProductEntities) {
            this.groupProductEntities = groupProductEntities;
        }
    }
}

