/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.dictionary;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.mall.dao.dictionary.DictionaryTypeMapper;
import cc.lechun.mall.entity.dictionary.DictionaryTypeEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryTypeInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryTypeService
implements DictionaryTypeInterface {
    private static final Logger log = LoggerFactory.getLogger(DictionaryTypeService.class);
    @Autowired
    private DictionaryTypeMapper dictionaryTypeMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @WriteDataSource
    public DictionaryTypeEntity saveDictionaryType(int dictionaryTypeId, String typeName, String remark) {
        DictionaryTypeEntity dictionaryTypeEntity = new DictionaryTypeEntity();
        dictionaryTypeEntity.setDictionaryTypeId(dictionaryTypeId);
        dictionaryTypeEntity.setTypeName(typeName);
        dictionaryTypeEntity.setRemark(remark);
        this.dictionaryTypeMapper.insert(dictionaryTypeEntity);
        this.removeCache(dictionaryTypeId);
        return dictionaryTypeEntity;
    }

    @Override
    @WriteDataSource
    public DictionaryTypeEntity updateDictionaryType(int dictionaryTypeId, String typeName, String remark) {
        DictionaryTypeEntity dictionaryTypeEntity = this.getDictionaryType(dictionaryTypeId);
        dictionaryTypeEntity.setTypeName(typeName);
        dictionaryTypeEntity.setRemark(remark);
        this.dictionaryTypeMapper.updateByPrimaryKeySelective(dictionaryTypeEntity);
        this.removeCache(dictionaryTypeId);
        return dictionaryTypeEntity;
    }

    @Override
    @ReadThroughSingleCache(namespace="dictionaryType", expiration=7200)
    @ReadDataSource
    public DictionaryTypeEntity getDictionaryType(@ParameterValueKeyProvider int dictionaryTypeId) {
        return (DictionaryTypeEntity)this.dictionaryTypeMapper.selectByPrimaryKey(Integer.valueOf(dictionaryTypeId));
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="dictionaryTypelist", expiration=7200)
    @ReadDataSource
    public List<DictionaryTypeEntity> getDictionaryTypeList() {
        return this.dictionaryTypeMapper.getList(new DictionaryTypeEntity());
    }

    private void removeCache(Integer dictionaryTypeId) {
        this.memcachedService.delete("dictionaryType", dictionaryTypeId + "");
        this.memcachedService.delete("dictionaryTypelist", "list");
    }
}

