/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardDetailMapper;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailQueryVo;
import cc.lechun.mall.entity.prepay.PrepayCardDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardPlanDetailService
extends BaseService<PrepayCardDetailEntity, Integer>
implements PrepayCardPlanDetailInterface {
    @Resource
    PrepayCardDetailMapper prepayCardDetailMapper;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private CustomerInterface customerInterface;

    @Override
    public PageInfo<PrepayCardDetailVo> getPrepayCardDetailVoList(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        Page page = PageHelper.startPage((int)prepayCardDetailQueryVo.getCurrentPage(), (int)prepayCardDetailQueryVo.getPageSize());
        if (StringUtils.isNotEmpty((String)prepayCardDetailQueryVo.getOrderBy())) {
            page.setOrderBy(prepayCardDetailQueryVo.getOrderBy());
        }
        if (prepayCardDetailQueryVo.getOrderSource() != null && prepayCardDetailQueryVo.getOrderSource() == 0) {
            prepayCardDetailQueryVo.setOrderSource(null);
        }
        if (StringUtils.isEmpty((String)prepayCardDetailQueryVo.getCardId())) {
            prepayCardDetailQueryVo.setCardId(null);
        }
        this.prepayCardDetailMapper.getListByDate(prepayCardDetailQueryVo);
        List list = page.toPageInfo().getList();
        ArrayList resultList = new ArrayList();
        list.forEach(c -> {
            PrepayCardDetailVo prepayCardDetailVo = new PrepayCardDetailVo();
            BeanUtils.copyProperties((Object)c, (Object)prepayCardDetailVo);
            prepayCardDetailVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            CustomerAddressEntity customerAddressEntity = this.customerAddressInterface.getCustomerAddress(c.getAddrId());
            BeanUtils.copyProperties((Object)customerAddressEntity, (Object)prepayCardDetailVo);
            prepayCardDetailVo.setStatus(c.getStatus());
            prepayCardDetailVo.setStatusName(PrepayCardPlanStatusEnum.getName(c.getStatus()));
            prepayCardDetailVo.setCreateTime(c.getCreateTime());
            MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(c.getPromotionId());
            prepayCardDetailVo.setPromotionName(promotionEntity == null ? "" : promotionEntity.getPromotionName());
            prepayCardDetailVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            resultList.add(prepayCardDetailVo);
        });
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(page.getTotal());
        return pg2;
    }
}

