/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.quartz.job;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.quartz.AbstractJob;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPeriodService;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrgPeriodCreateJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(OrgPeriodCreateJob.class);
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private IOrgPaperService paperService;

    protected Object doExecute(JobExecutionContext context) {
        try {
            BaseJsonVo vo = this.periodService.createPeriods();
            if (!vo.isSuccess()) {
                log.error("\u6bcf\u5468\u521b\u5efa\u671f\u6b21\u5931\u8d25\uff1a" + vo.getError_msg());
            } else {
                BaseJsonVo<PeriodEntity> nextPeriod;
                this.paperService.buildPaper();
                BaseJsonVo<PeriodEntity> jsonVo = this.periodService.currentPeriod(0);
                if (jsonVo.isSuccess() && (nextPeriod = this.periodService.getNextPeriod(((PeriodEntity)jsonVo.getValue()).getId())).isSuccess()) {
                    this.paperService.buildPaper(((PeriodEntity)nextPeriod.getValue()).getId());
                }
                log.info("\u6bcf\u5468\u521b\u5efa\u671f\u6b21\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u6bcf\u5468\u521b\u5efa\u671f\u6b21\u5931\u8d25\uff1a", (Throwable)e);
        }
        return "";
    }
}

