/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.mall.dao.trade.MallPayTypeMapper;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPayTypeVo;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.service.trade.cache.MallPayTypeCacheService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPayTypeService
extends MallPayTypeCacheService
implements MallPayTypeInterface {
    @Autowired
    private MallPayTypeMapper mallPayTypeMapper;

    @Override
    @ReadDataSource
    @ReadThroughSingleCache(namespace="getPayType", expiration=86400)
    public MallPayTypeEntity getPayType(@ParameterValueKeyProvider int payTypeId) {
        return (MallPayTypeEntity)this.mallPayTypeMapper.selectByPrimaryKey(Integer.valueOf(payTypeId));
    }

    @Override
    public BaseJsonVo getOrderPayList(MallMainOrderVo mainOrderVo) {
        ArrayList<MallPayTypeVo> mallPayTypeEntities = new ArrayList<MallPayTypeVo>();
        HashMap<Integer, BigDecimal> pays = new HashMap<Integer, BigDecimal>();
        if (mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue()) {
            pays.put(PaySubTypeEnum.GIFT_SUB_PAY.getValue(), mainOrderVo.getTotalAmount());
        } else {
            if (mainOrderVo.getCouponAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                pays.put(PaySubTypeEnum.COUPON_SUB_PAY.getValue(), mainOrderVo.getCouponAmount());
            }
            if (mainOrderVo.getBalanceAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                pays.put(PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue(), mainOrderVo.getBalanceAmount());
            }
            if (mainOrderVo.getPayAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                pays.put(mainOrderVo.getOrderCacheVo().getPayType(), mainOrderVo.getPayAmount());
            }
        }
        if (pays.size() < 1) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u53ef\u7528\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
        for (Integer key : pays.keySet()) {
            MallPayTypeEntity payTypeEntity = this.getPayType(key);
            if (payTypeEntity == null) {
                return BaseJsonVo.error((String)"\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef");
            }
            if (payTypeEntity.getpPaytypeId() == 0 || payTypeEntity.getpPaytypeId() == 1) {
                return BaseJsonVo.error((String)"\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef");
            }
            if (payTypeEntity.getIsleaf().intValue() == 0) {
                return BaseJsonVo.error((String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u662f\u5b50\u652f\u4ed8\u65b9\u5f0f");
            }
            MallPayTypeEntity parentPayTypeEntity = this.getPayType(payTypeEntity.getpPaytypeId());
            if (parentPayTypeEntity == null) {
                return BaseJsonVo.error((String)"\u7236\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef");
            }
            MallPayTypeVo payTypeVo = new MallPayTypeVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)parentPayTypeEntity, (Object)payTypeVo);
                payTypeVo.setPayAmount((BigDecimal)pays.get(key));
                payTypeVo.setPaySubTypeId(key);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.toString());
                BaseJsonVo.error((String)"\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25");
            }
            mallPayTypeEntities.add(payTypeVo);
        }
        mallPayTypeEntities.stream().sorted((p1, p2) -> p1.getSort().compareTo(p2.getSort())).collect(Collectors.toList());
        return BaseJsonVo.success(mallPayTypeEntities);
    }

    @Override
    public MallPayTypeEntity getDefaultPayType() {
        return this.mallPayTypeMapper.getDefaultPayType();
    }
}

