/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.vip.MallVipMapper;
import cc.lechun.mall.dao.vip.MallVipdaylogMapper;
import cc.lechun.mall.entity.vip.MallVipdaylogEntity;
import cc.lechun.mall.iservice.vip.MallVipDayInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MallVipDayService
extends BaseService
implements MallVipDayInterface {
    @Autowired
    private MallVipMapper vipMapper;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private RedisService redisService;
    @Autowired
    MallVipdaylogMapper vipdaylogMapper;

    @Override
    public Boolean pushNoticeMQ(List<Integer> levels, Date sendTime) {
        this.saveVipDayNoticeLevelCount(levels);
        int pageNum = 1;
        int pageSize = 1000;
        int nameSize = 0;
        do {
            try {
                List<Map<String, Object>> nameList = this.getVipDayNoticeNameList(levels, pageNum, pageSize);
                System.out.println("\u63a8\u9001\u6d88\u606f\u961f\u5217\u540d\u5355\u662f\u5426\u4e3a\u7a7a\uff1a" + (nameList == null));
                if (nameList == null) break;
                nameSize = nameList.size();
                System.out.println("\u63a8\u9001\u6d88\u606f\u961f\u5217\u540d\u5355\uff1a" + JsonUtils.toJson(nameList, (boolean)true));
                if (DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)sendTime) < 30L) {
                    sendTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)180);
                }
                MessageResult mr = this.messageQueueService.sendTaskMessage(MessageQueueTagEnum.vipDayNotice, new MessageParam(String.valueOf(pageNum), nameList), sendTime);
                System.out.println("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a" + mr.isStatus() + "  " + mr.getMsg().toString());
                ++pageNum;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5468\u4e09\u4f1a\u5458\u7528\u6237\u51fa\u9519", (Throwable)e);
                ++pageNum;
            }
        } while (nameSize >= pageSize);
        return true;
    }

    private Boolean saveVipDayNoticeLevelCount(List<Integer> levels) {
        List<Map<String, Object>> levelCounts = this.getVipDayNoticeLevelCount(levels);
        List<MallVipdaylogEntity> logs = this.vipdaylogMapper.getSendRecord(DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
        if (logs == null || logs.size() == 0) {
            levelCounts.forEach(level -> {
                MallVipdaylogEntity entity = new MallVipdaylogEntity();
                entity.setLevel((Integer)level.get("LEVEL"));
                entity.setMessage("");
                entity.setTotalNum(((Long)level.get("LEVEL_NUM")).intValue());
                entity.setSuccNum(0);
                entity.setFailNum(0);
                entity.setCreateTime(DateUtils.now());
                this.vipdaylogMapper.insert(entity);
            });
        } else {
            levelCounts.forEach(level -> {
                Optional<MallVipdaylogEntity> MallVipdaylogEntityOptional = logs.stream().filter(log -> log.getLevel().intValue() == ((Integer)level.get("LEVEL")).intValue()).findFirst();
                MallVipdaylogEntity entity = new MallVipdaylogEntity();
                if (MallVipdaylogEntityOptional != null && MallVipdaylogEntityOptional.isPresent() && (entity = MallVipdaylogEntityOptional.get()) != null && entity.getLevel() != null && entity.getLevel().intValue() == ((Integer)level.get("LEVEL")).intValue()) {
                    entity.setTotalNum(((Long)level.get("LEVEL_NUM")).intValue());
                    this.vipdaylogMapper.updateByPrimaryKey(entity);
                    return;
                }
                entity.setLevel((Integer)level.get("LEVEL"));
                entity.setMessage("");
                entity.setTotalNum(((Long)level.get("LEVEL_NUM")).intValue());
                entity.setSuccNum(0);
                entity.setFailNum(0);
                entity.setCreateTime(DateUtils.now());
                this.vipdaylogMapper.insert(entity);
            });
        }
        return true;
    }

    private List<Map<String, Object>> getVipDayNoticeLevelCount(List<Integer> levels) {
        return this.vipMapper.getVipDayNoticeLevelCount(levels);
    }

    private List<Map<String, Object>> getVipDayNoticeNameList(List<Integer> levels, int pageNum, int pageSize) {
        return this.vipMapper.getVipDayNoticeNameList(levels, (pageNum - 1) * pageSize, pageSize);
    }

    @Override
    public Boolean sendNotice(List<Map<String, Object>> param) {
        System.out.println("\u6536\u5230\u4e86\u6d88\u606f\u961f\u5217\uff1a" + JsonUtils.toJson(param, (boolean)true));
        ExecutorService pool = Executors.newFixedThreadPool(6);
        for (final Map<String, Object> customer : param) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("nickName", String.valueOf(customer.get("NICK_NAME")));
                    boolean setResult = MallVipDayService.this.redisService.sadd("VIP_DAY_SEND_OPENID_LIST_TEMP" + customer.get("LEVEL"), customer.get("OPEN_ID"));
                    if (!setResult) {
                        return;
                    }
                    BaseJsonVo result = MallVipDayService.this.messageService.sendWechatMessage(1, "vipday_v" + String.valueOf(customer.get("LEVEL")), String.valueOf(customer.get("OPEN_ID")), map);
                    System.out.println("\u63a8\u9001\u6a21\u677f\u6d88\u606f\u7ed3\u679c\uff1a" + result.isSuccess() + "  " + result.getMessage());
                    if (result.isSuccess()) {
                        Long l = MallVipDayService.this.redisService.increment("VIP_DAY_SEND_COUNT_SUCC_TEMP" + customer.get("LEVEL"), 1L);
                        MallVipDayService.this.logger.info("\u4fdd\u5b58\u7ed3\u679c\uff1a" + l);
                    }
                    MallVipDayService.this.redisService.setExpire("VIP_DAY_SEND_OPENID_LIST_TEMP" + customer.get("LEVEL"), 86400L, TimeUnit.SECONDS);
                    MallVipDayService.this.redisService.setExpire("VIP_DAY_SEND_COUNT_SUCC_TEMP" + customer.get("LEVEL"), 86400L, TimeUnit.SECONDS);
                }
            });
        }
        pool.shutdown();
        return true;
    }

    @Override
    public List<MallVipdaylogEntity> getVipSendCount(String sendDate) {
        List<MallVipdaylogEntity> logs = this.vipdaylogMapper.getSendRecord(sendDate);
        logs.forEach(log -> {
            Object o = this.redisService.get("VIP_DAY_SEND_COUNT_SUCC_TEMP" + String.valueOf(log.getLevel()));
            this.logger.info("value : " + o);
            log.setSuccNum(o == null ? 0 : (Integer)o);
            MallVipdaylogEntity entity = new MallVipdaylogEntity();
            entity.setId(log.getId());
            entity.setSuccNum(log.getSuccNum());
            entity.setFailNum(this.redisService.sSize("VIP_DAY_SEND_OPENID_LIST_TEMP" + log.getLevel(), new Object[0]).intValue());
            this.vipdaylogMapper.updateByPrimaryKeySelective(entity);
        });
        return logs;
    }

    @Override
    public void testRedisExpire() {
        this.redisService.sadd("testRedisExpire", "abcdefg");
        this.redisService.sadd("testRedisExpire", "12345");
        this.redisService.sadd("testRedisExpire", "54321");
        this.redisService.sadd("testRedisExpire", "lllll");
        this.redisService.setExpire("testRedisExpire", 86400L, TimeUnit.SECONDS);
    }
}

