/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils;

import cc.lechun.utils.ExcelListener;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.github.pagehelper.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    protected static Logger logger = LoggerFactory.getLogger((String)"ExcelUtil");

    public static <T extends BaseRowModel> List<T> readExcel(InputStream inputStream, Class<? extends BaseRowModel> clazz) {
        if (null == inputStream) {
            throw new NullPointerException("the inputStream is null!");
        }
        ExcelListener listener = new ExcelListener();
        ExcelReader reader = new ExcelReader(inputStream, ExcelUtil.valueOf(inputStream), null, listener);
        reader.read(new com.alibaba.excel.metadata.Sheet(1, 1, clazz));
        return listener.getRows();
    }

    public static void writeExcel(File file, List<? extends BaseRowModel> list) {
        try (FileOutputStream out = new FileOutputStream(file);){
            ExcelWriter writer = new ExcelWriter((OutputStream)out, ExcelTypeEnum.XLSX);
            Class<?> t = list.get(0).getClass();
            com.alibaba.excel.metadata.Sheet sheet = new com.alibaba.excel.metadata.Sheet(1, 0, t);
            writer.write(list, sheet);
            writer.finish();
        }
        catch (IOException e) {
            logger.warn("fail to write to excel file: file[{}]", (Object)file.getName(), (Object)e);
        }
    }

    public static ExcelTypeEnum valueOf(InputStream inputStream) {
        try {
            FileMagic fileMagic = FileMagic.valueOf((InputStream)inputStream);
            if (FileMagic.OLE2.equals((Object)fileMagic)) {
                return ExcelTypeEnum.XLS;
            }
            if (FileMagic.OOXML.equals((Object)fileMagic)) {
                return ExcelTypeEnum.XLSX;
            }
            throw new IllegalArgumentException("excelTypeEnum can not null");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exportExcel(HttpServletResponse response, String fileName, String title, String[] headers, List<LinkedHashMap<String, String>> dataset, String pattern) {
        boolean flag = false;
        XSSFWorkbook workbook = null;
        if (fileName.endsWith("xlsx")) {
            workbook = new XSSFWorkbook();
        } else if (fileName.endsWith("xls")) {
            workbook = new HSSFWorkbook();
        } else {
            try {
                throw new Exception("invalid file name, should be xls or xlsx");
            }
            catch (Exception e) {
                logger.info("\u5fc5\u987b\u662fxls\u6216\u8005xlsx\u7ed3\u5c3e\u7684\u6587\u4ef6.");
                e.printStackTrace();
            }
        }
        Sheet sheet = workbook.createSheet(title);
        CellStyle style = workbook.createCellStyle();
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            sheet.setColumnWidth(i, 5000);
            cell.setCellValue(headers[i]);
        }
        Iterator<LinkedHashMap<String, String>> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Map map = it.next();
            logger.info(map.toString());
            Set mapKey = map.keySet();
            logger.info(mapKey.toString());
            Iterator iterator = mapKey.iterator();
            logger.info(iterator.toString());
            int num = 0;
            while (iterator.hasNext()) {
                Cell cell = row.createCell(num);
                ++num;
                String key = (String)iterator.next();
                logger.info(key);
                Object obj = map.get(key);
                String v = obj == null ? "-" : obj.toString();
                cell.setCellValue(StringUtil.isEmpty((String)v) ? "-" : v);
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            workbook.write((OutputStream)fos);
            fos.close();
            flag = true;
            ExcelUtil.downloadLocal(response, fileName);
        }
        catch (FileNotFoundException e) {
            logger.info("\u6587\u4ef6\u4e0d\u5b58\u5728");
            flag = false;
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.info("\u6587\u4ef6\u5199\u5165\u9519\u8bef");
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    public static void downloadLocal(HttpServletResponse response, String fileName) throws FileNotFoundException, IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        response.reset();
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setContentType("bin");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "iso-8859-1"));
        byte[] b = new byte[100];
        try {
            int len;
            while ((len = ((InputStream)inStream).read(b)) > 0) {
                response.getOutputStream().write(b, 0, len);
            }
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

