/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.MallUrlMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveCommonService
extends ActiveBaseService
implements ActiveCommonInterface {
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private OssService ossService;
    @Autowired
    private MallUrlMapper mallUrlMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private DictionaryInterface dictionaryService;
    @Autowired
    protected MallOrderInterface mallOrderInterface;

    @Override
    public void pushActiveMessage(MallOrderMainEntity mallOrderMainEntity) {
        this.logger.info("\u6536\u5230\u6d3b\u52a8\u63a8\u9001\u6210\u529f\u6d88\u606f\u5f00\u59cb...");
        boolean pushFitMessage = true;
        try {
            pushFitMessage = this.pushOrderMessage(mallOrderMainEntity, pushFitMessage);
            if (mallOrderMainEntity.getOrderClass() == 1 || mallOrderMainEntity.getOrderClass() == 4) {
                this.pushPicMessage(mallOrderMainEntity, pushFitMessage);
                this.pushSmsMessage(mallOrderMainEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean pushOrderMessage(MallOrderMainEntity mallOrderMainEntity, boolean pushFitMessage) {
        if (StringUtils.isNotEmpty((String)mallOrderMainEntity.getActiveNo())) {
            this.logger.info("\u6d3b\u52a8:{}", (Object)mallOrderMainEntity.getActiveNo());
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(mallOrderMainEntity.getActiveNo());
            if (activeEntity != null) {
                pushFitMessage = false;
                if (activeEntity.getPayKeywordId() != null && activeEntity.getPayKeywordId() > 0) {
                    this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, activeEntity.getPayKeywordId(), mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId(), null);
                }
            }
        }
        return pushFitMessage;
    }

    private void pushPicMessage(MallOrderMainEntity mallOrderMainEntity, boolean pushFitMessage) {
        if (pushFitMessage) {
            DictionaryEntity dic = this.dictionaryService.getDictionary(mallOrderMainEntity.getPlatformGroupId(), 28, "1");
            String bindCode = "";
            if (dic != null && !StringUtils.isEmpty((String)dic.getDictionaryName())) {
                bindCode = dic.getDictionaryName();
                this.customerQrcodeService.getSaleQrcodeVo(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId(), bindCode);
            }
        }
    }

    private void pushSmsMessage(MallOrderMainEntity mallOrderMainEntity) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId());
        if (this.customerService.getUserSubscribe(customerDetailVo.getOpenId(), mallOrderMainEntity.getPlatformId()) == 0) {
            String phone = this.mallOrderInterface.getOrderList(mallOrderMainEntity.getOrderMainNo()).get(0).getConsigneePhone();
            if (StringUtils.isNotEmpty((String)phone)) {
                String result = SmsUtil.sendSms((String)phone, (String)"hi\uff0c\u5c0f\u4f19\u4f34\uff5e\u606d\u559c\u4f60\u4e0b\u5355\u6210\u529f\uff01\u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7\u300c\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec\u300d\u5373\u53ef\u81ea\u52a9\u67e5\u8be2\u8ba2\u5355\u7269\u6d41\u60c5\u51b5\u3002\u5982\u6709\u95ee\u9898\u53ef\u5728\u516c\u4f17\u53f7\u300c\u4e2a\u4eba\u4e2d\u5fc3-\u4eba\u5de5\u5ba2\u670d\u300d\u54a8\u8be2\u5728\u7ebf\u5ba2\u670d\u3002\u670d\u52a1\u65f6\u95f4\u6bcf\u5468\u4e00\u81f3\u5468\u65e510:00-22:00", (String)IDGenerate.getUniqueIdStr());
                if (result != null && !"".equals(result) && result.length() > 10) {
                    this.logger.info("\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f,\u624b\u673a\u53f7:{}\u6210\u529f", (Object)mallOrderMainEntity.getCustomerId(), (Object)phone);
                } else {
                    this.logger.info("\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f,\u624b\u673a\u53f7:{}\u5931\u8d25", (Object)mallOrderMainEntity.getCustomerId(), (Object)phone);
                }
            }
        } else {
            this.logger.info("\u672a\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f\uff0c\u7528\u6237\u5df2\u5173\u6ce8\u516c\u4f17\u53f7", (Object)mallOrderMainEntity.getCustomerId());
        }
    }
}

