/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCustomerMapper;
import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActiveCustomerVo;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveCustomerService
extends ActiveBaseService
implements ActiveCustomerInterface {
    @Autowired
    private ActiveCustomerMapper activeCustomerMapper;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;

    @Override
    public BaseJsonVo saveActiveCustomerRecord(ActiveCustomerVo activeCustomerVo) {
        try {
            ActiveCustomerEntity activeCustomerEntity = activeCustomerVo.getActiveCustomerEntity();
            ActiveCustomerEntity temp = new ActiveCustomerEntity();
            temp.setCustomerId(activeCustomerEntity.getCustomerId());
            temp.setBindCode(activeCustomerEntity.getBindCode());
            ActiveCustomerEntity temp2 = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp);
            this.logger.info("\u5f00\u59cb\u5199\u5165\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55:{}", (Object)activeCustomerEntity.toString());
            if (temp2 == null) {
                this.logger.info("\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u4e3a\u7a7a...");
                Integer level = 1;
                if (StringUtils.isNotEmpty((String)activeCustomerVo.getSourceUserId())) {
                    ActiveInviteEntity queryEntity = new ActiveInviteEntity();
                    queryEntity.setCustomerId(activeCustomerVo.getSourceUserId());
                    queryEntity.setBindCode(activeCustomerVo.getActiveCustomerEntity().getBindCode());
                    ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(queryEntity);
                    if (activeCustomerEntity != null && activeInviteEntity != null) {
                        temp.setCustomerId(activeInviteEntity.getCustomerId());
                        temp.setBindCode(activeCustomerEntity.getBindCode());
                        temp2 = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp);
                        if (temp2 != null) {
                            level = temp2.getLevel() + 1;
                        }
                    } else {
                        this.logger.info("\u6d3b\u52a8\u9080\u8bf7inviteId\u51fa\u9519,\u9080\u8bf7\u4ebacustomerId={}", (Object)activeCustomerVo.getSourceUserId());
                    }
                }
                activeCustomerEntity.setLevel(level);
                activeCustomerEntity.setStatus(0);
                activeCustomerEntity.setUpdateTime(DateUtils.now());
                this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeCustomerEntity.toString());
                int k = this.activeCustomerMapper.insert(activeCustomerEntity);
                if (k >= 1) {
                    this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeCustomerEntity.toString());
                } else {
                    this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u5931\u8d25:{}", (Object)activeCustomerEntity.toString());
                }
            } else if (temp2.getStatus() == 0) {
                ActiveCustomerEntity updateActiveCustomerEntity = new ActiveCustomerEntity();
                updateActiveCustomerEntity.setOrderMainNo(activeCustomerEntity.getOrderMainNo());
                updateActiveCustomerEntity.setUpdateTime(DateUtils.now());
                updateActiveCustomerEntity.setActiveNo(activeCustomerEntity.getActiveNo());
                updateActiveCustomerEntity.setActiveType(activeCustomerEntity.getActiveType());
                updateActiveCustomerEntity.setId(temp2.getId());
                this.activeCustomerMapper.updateByPrimaryKeySelective(updateActiveCustomerEntity);
            } else {
                this.logger.info("\u7528\u6237\u53c2\u4e0e\u6d3b\u52a8\u72b6\u6001\u4e3a:{}", (Object)temp2.getStatus());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional
    public BaseJsonVo saveActiveCustomerRecord(MallOrderMainEntity orderMain, String source, ActiveEntity activeEntity) {
        ActiveCustomerEntity temp2;
        ActiveCustomerEntity temp = new ActiveCustomerEntity();
        temp.setCustomerId(orderMain.getCustomerId());
        temp.setBindCode(orderMain.getBindCode());
        temp.setOrderMainNo(orderMain.getOrderMainNo());
        if (StringUtils.isNotEmpty((String)source)) {
            temp.setSourceCustomerId(source);
        }
        if ((temp2 = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp)) == null) {
            this.logger.info("\u7528\u6237{}\u53c2\u4e0e\u6d3b\u52a8:{}\u8bb0\u5f55\u4e3a\u7a7a...", (Object)orderMain.getCustomerId(), (Object)activeEntity.getActiveName());
            Integer level = 1;
            ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
            BeanUtils.copyProperties((Object)orderMain, (Object)activeCustomerEntity);
            activeCustomerEntity.setActiveType(activeEntity.getActiveType());
            activeCustomerEntity.setCityName("");
            activeCustomerEntity.setName("");
            activeCustomerEntity.setActiveNo(activeEntity.getActiveNo());
            activeCustomerEntity.setInviteNum(activeEntity.getInviteNum());
            activeCustomerEntity.setGiveShareCount(0);
            activeCustomerEntity.setIpCityId(0);
            activeCustomerEntity.setCreateTime(DateUtils.now());
            activeCustomerEntity.setThirdOpenId("");
            activeCustomerEntity.setIsFirstOrder(0);
            activeCustomerEntity.setQrcodeId(0);
            activeCustomerEntity.setSourceCustomerId(source == null ? "" : source);
            activeCustomerEntity.setReleaseSystemId("");
            activeCustomerEntity.setVersionDetailId("");
            if (StringUtils.isNotEmpty((String)source)) {
                ActiveCustomerEntity inviteCutomer = new ActiveCustomerEntity();
                inviteCutomer.setCustomerId(source);
                inviteCutomer.setActiveType(activeEntity.getActiveType());
                List<ActiveCustomerEntity> list = this.getActiveCustomerEntityList(inviteCutomer);
                if (list != null && list.size() >= 1) {
                    inviteCutomer = list.stream().filter(c -> c.getStatus() >= 1).findFirst().get();
                    if (inviteCutomer != null) {
                        level = inviteCutomer.getLevel() + 1;
                    }
                } else {
                    this.logger.info("\u67e5\u8be2\u6d3b\u52a8\u9080\u8bf7\u4ebalevel\u51fa\u9519,\u9080\u8bf7\u4ebacustomerId={}", (Object)source);
                }
            }
            activeCustomerEntity.setLevel(level);
            activeCustomerEntity.setStatus(0);
            activeCustomerEntity.setUpdateTime(DateUtils.now());
            int k = this.activeCustomerMapper.insert(activeCustomerEntity);
            if (k >= 1) {
                this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeCustomerEntity.toString());
                return BaseJsonVo.success((Object)"");
            }
            this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u5931\u8d25:{}", (Object)activeCustomerEntity.toString());
            return BaseJsonVo.error((String)"\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u5931\u8d25");
        }
        if (temp2.getStatus() != 0) {
            this.logger.info("\u7528\u6237\u53c2\u4e0e\u6d3b\u52a8\u72b6\u6001\u4e3a:{}", (Object)temp2.getStatus());
            return BaseJsonVo.success((Object)"");
        }
        ActiveCustomerEntity updateActiveCustomerEntity = new ActiveCustomerEntity();
        updateActiveCustomerEntity.setOrderMainNo(orderMain.getOrderMainNo());
        updateActiveCustomerEntity.setUpdateTime(DateUtils.now());
        updateActiveCustomerEntity.setActiveNo(orderMain.getActiveNo());
        updateActiveCustomerEntity.setSourceCustomerId(StringUtils.isNotEmpty((String)source) ? source : "");
        updateActiveCustomerEntity.setActiveType(activeEntity.getActiveType());
        updateActiveCustomerEntity.setId(temp2.getId());
        if (this.activeCustomerMapper.updateByPrimaryKeySelective(updateActiveCustomerEntity) >= 1) {
            this.logger.info("\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u66f4\u65b0\u6210\u529f.{}", (Object)updateActiveCustomerEntity.toString());
            return BaseJsonVo.success((Object)"");
        }
        this.logger.info("\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25.{}", (Object)updateActiveCustomerEntity.toString());
        return BaseJsonVo.success((Object)"");
    }

    private void updateActiveJoinRecord(MallOrderMainEntity mallOrderMainEntity) {
        ActiveCustomerEntity queryActiveCustomer = new ActiveCustomerEntity();
        queryActiveCustomer.setCustomerId(mallOrderMainEntity.getCustomerId());
        queryActiveCustomer.setBindCode(mallOrderMainEntity.getBindCode());
        queryActiveCustomer.setStatus(0);
        ActiveCustomerEntity activeCustomerEntity = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(queryActiveCustomer);
        if (activeCustomerEntity != null) {
            ActiveCustomerEntity updateActiveCustomerEntity = new ActiveCustomerEntity();
            updateActiveCustomerEntity.setId(activeCustomerEntity.getId());
            updateActiveCustomerEntity.setStatus(1);
            this.activeCustomerMapper.updateByPrimaryKeySelective(updateActiveCustomerEntity);
        }
    }

    @Override
    public List<ActiveCustomerEntity> getActiveCustomerEntityList(ActiveCustomerEntity activeCustomerEntity) {
        return this.activeCustomerMapper.getList(activeCustomerEntity);
    }

    @Override
    public int getInviteNum(ActiveCustomerEntity activeCustomerEntity) {
        List<ActiveCustomerEntity> list = this.getActiveCustomerEntityList(activeCustomerEntity);
        if (list != null && list.size() >= 1) {
            ActiveCustomerEntity temp = list.stream().filter(c -> c.getStatus() >= 1).findFirst().get();
            if (temp != null) {
                return temp.getInviteNum();
            }
            return 0;
        }
        return 0;
    }

    @Override
    public ActiveCustomerEntity getActiveCustomerEntity(ActiveCustomerEntity activeCustomerEntity) {
        return (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(activeCustomerEntity);
    }

    @Override
    public BaseJsonVo updateCustomerActiveRecordByOrderNo(ActiveCustomerEntity activeCustomerEntity) {
        return this.activeCustomerMapper.updateCustomerActiveRecord(activeCustomerEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public Integer getJoinActiveStatus(String customerId, Integer activeType) {
        Optional<ActiveCustomerEntity> optional;
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setActiveType(activeType);
        List list = this.activeCustomerMapper.getList(activeCustomerEntity);
        if (list != null && list.size() >= 1 && (optional = list.stream().max(Comparator.comparing(ActiveCustomerEntity::getStatus))).isPresent()) {
            return optional.get().getStatus();
        }
        return 0;
    }

    @Override
    public Integer getJoinActiveStatus(String customerId, String bindCode) {
        Optional<ActiveCustomerEntity> optional;
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setBindCode(bindCode);
        List list = this.activeCustomerMapper.getList(activeCustomerEntity);
        if (list != null && list.size() >= 1 && (optional = list.stream().max(Comparator.comparing(ActiveCustomerEntity::getStatus))).isPresent()) {
            return optional.get().getStatus();
        }
        return 0;
    }

    @Override
    public BaseJsonVo prizeActive(String customerId, String bindCode) {
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setBindCode(bindCode);
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setUpdateTime(DateUtils.now());
        activeCustomerEntity.setStatus(2);
        return this.activeCustomerMapper.setPrizeByBindCode(activeCustomerEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo prizeActive(String customerId, Integer activeType) {
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setActiveType(activeType);
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setUpdateTime(DateUtils.now());
        activeCustomerEntity.setStatus(2);
        return this.activeCustomerMapper.setPrize(activeCustomerEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }
}

