/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.refund;

import cc.lechun.common.enums.trade.RefundSourceEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.trade.ApplyRefundPayDetailVo;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.OrderRefundInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ActiveRefundBase
extends BaseService {
    @Autowired
    protected OrderRefundInterface orderRefundInterface;
    @Autowired
    protected MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;

    protected BaseJsonVo refundApply(String orderMainNo, String reason) {
        ArrayList<ApplyRefundPayDetailVo> refundPayDetailVos = new ArrayList<ApplyRefundPayDetailVo>();
        ApplyRefundPayDetailVo refundPayDetailVo = null;
        List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMainNo);
        BigDecimal amount = new BigDecimal(0);
        for (MallOrderPayEntity pay : orderPayEntities) {
            if (pay.getIssuccess() != 1) continue;
            refundPayDetailVo = new ApplyRefundPayDetailVo();
            refundPayDetailVo.setAmount(pay.getPayamount());
            refundPayDetailVo.setPayTypeId(pay.getPaytypeId());
            refundPayDetailVos.add(refundPayDetailVo);
            amount = amount.add(pay.getPayamount());
        }
        OrderRefundApplyVo refundApplyVo = new OrderRefundApplyVo();
        refundApplyVo.setOrderMainNo(orderMainNo);
        refundApplyVo.setOrderNo("");
        refundApplyVo.setSourceEnum(RefundSourceEnum.cms);
        refundApplyVo.setRefundOrderType(1);
        refundApplyVo.setReason(reason);
        refundApplyVo.setReturnAmount(amount);
        refundApplyVo.setPayDetailVos(refundPayDetailVos);
        refundApplyVo.setIsRefundCoupon(2);
        refundApplyVo.setOperator("system");
        BaseJsonVo baseJsonVo = this.orderRefundInterface.createRefundBill(refundApplyVo, false);
        return baseJsonVo;
    }

    protected BaseJsonVo payRefundCheck(String refundId) {
        return this.orderRefundInterface.passOrderRefund(refundId, "system", null);
    }
}

