/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.reserve;

import cc.lechun.active.dao.active.ActiveReserveMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveReserveEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ReserveService
extends ActiveBaseService
implements ReserveInterface {
    @Autowired
    private ActiveReserveMapper reserveMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ActiveCashticketInterface activeCashticketServcie;

    @Override
    public BaseJsonVo sendReserveCoupon(String bindCode) {
        final ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        ActiveReserveEntity activeReserveEntity = new ActiveReserveEntity();
        activeReserveEntity.setProType("5");
        activeReserveEntity.setProId(bindCode);
        final List list = this.reserveMapper.getList(activeReserveEntity);
        if (list == null || list.size() == 0) {
            return BaseJsonVo.error((String)"\u65e0\u9884\u7ea6\u7528\u6237");
        }
        ThreadPool.services.execute(new Runnable(){

            @Override
            public void run() {
                list.forEach(r -> {
                    try {
                        ReserveService.this.logger.info("\u9884\u7ea6\u7528\u6237:{}", (Object)r.toString());
                        ReserveService.this.activeCashticketServcie.sendTicket4BaseAsynchronous(r.getCustomerId(), activeEntity.getBindCode(), "", activeEntity.getPlatformId(), true, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        });
        return BaseJsonVo.success((Object)"\u4f18\u60e0\u5238\u53d1\u9001\u4e2d...\u8bf7\u7a0d\u540e");
    }

    @Override
    public PageInfo reserveList(int pageNum, int pageSize, String activeNo, String nickName) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List<ActiveReserveEntity> list = this.reserveMapper.getReserveList();
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    @Override
    public BaseJsonVo sendReserveMessage(String bindCode) {
        List<Map<String, Object>> customers = this.reserveMapper.findUnsend(bindCode);
        HashSet<Map<String, Object>> customersSet = new HashSet<Map<String, Object>>(customers);
        this.logger.info("\u8981\u53d1\u9001\u9884\u7ea6\u63d0\u9192\u4e86 : " + customers.size());
        ExecutorService pool = Executors.newCachedThreadPool();
        customersSet.forEach(customer -> pool.execute(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickName", (String)customer.get("NICK_NAME"));
            map.put("proName", (String)customer.get("PRO_NAME"));
            map.put("createTime", customer.get("CREATE_TIME") == null ? DateUtils.date() : DateUtils.formatDate((Date)((Date)customer.get("CREATE_TIME")), (String)"yyyy-MM-dd"));
            BaseJsonVo result = this.messageService.sendWechatMessage(1, "\u9884\u7ea6\u63d0\u9192\u6a21\u677f", (String)customer.get("CHANNEL_CUSTOMER_ID"), map);
            this.logger.info("\u63a8\u9001\u9884\u7ea6\u63d0\u9192\uff1a[" + customer.get("CHANNEL_CUSTOMER_ID") + "]\u7ed3\u679c \uff1a " + (result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25[" + result.getError_msg() + "]"));
        }));
        pool.shutdown();
        this.reserveMapper.updateSendStatus(bindCode);
        return BaseJsonVo.success((Object)"\u53d1\u9001\u5b8c\u6210");
    }
}

