/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activeType_6")
public class LimitSaleHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    private CustomerInterface customerService;

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        if (!this.checkIsWhite(customerId)) {
            List tt;
            MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
            orderMainEntity.setCustomerId(customerId);
            orderMainEntity.setBindCode(bindCode);
            List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
            if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getStatus() >= 3 && c.getStatus() < 20).collect(Collectors.toList())) != null && tt.size() >= 1) {
                return BaseJsonVo.error((String)"\u5662\u54e6~\u5df2\u53c2\u4e0e\u8fc7\u6d3b\u52a8");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        this.collectionActiveOrderData(orderMain);
        this.logger.info("\u5b9e\u7269\u9650\u65f6\u7279\u60e0\u8ba2\u5355{},\u6570\u636e\u57cb\u70b9\u5b8c\u6210", (Object)orderMain.getOrderMainNo());
        if (StringUtils.isNotEmpty((String)orderMain.getBindCode()) && orderMain.getBindCode().length() >= 32) {
            this.sendCoupon(orderMain.getCustomerId(), orderMain.getBindCode(), orderMain.getPlatformId());
            this.logger.info("{},\u53d1\u653e\u4f18\u60e0\u5238\u5b8c\u6210", (Object)orderMain.getOrderMainNo());
        }
        return BaseJsonVo.success((Object)"");
    }
}

