/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.tempqrcode;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.tempCode.CustomerQrcodeEntity;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.service.tempqrcode.TempQrcodeHandle;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="saleQrcode")
public class SaleQrcode
extends ActiveBaseService
implements TempQrcodeHandle {
    @Autowired
    private CustomerQrcodeInterface customerQrcodeInterface;
    @Autowired
    protected MessageInterface messageService;
    @Autowired
    private ActiveInviteInterface activeInviteService;
    @Autowired
    private CustomerInterface customerService;

    @Override
    public BaseJsonVo scanTempQrcode(String ticket, String openId, String scence, int platformId, Integer type) {
        CustomerQrcodeEntity sourceQrcode = this.customerQrcodeInterface.getCustomerQrcode(ticket, scence);
        if (sourceQrcode == null) {
            this.logger.error("\u672a\u77e5\u7684\u4e34\u65f6\u4e8c\u7ef4\u7801\uff0cticket={},scence={}", (Object)ticket, (Object)scence);
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u4e34\u65f6\u4e8c\u7ef4\u7801");
        }
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(sourceQrcode.getActiveNo());
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        ActiveQrcodeEntity qrcodeEntity = new ActiveQrcodeEntity();
        qrcodeEntity.setActiveNo(sourceQrcode.getActiveNo());
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(qrcodeEntity);
        if (activeQrcodeEntity == null) {
            this.logger.error("\u6d3b\u52a8:{},\u672a\u914d\u7f6e", (Object)activeEntity.getActiveNo());
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8\u4e8c\u7ef4\u7801");
        }
        ActiveInviteEntity activeInviteEntity = this.activeInviteService.getActiveInviteEntity(sourceQrcode.getCustomerId(), qrcodeEntity.getBindCode(), activeEntity);
        if (activeInviteEntity == null) {
            this.logger.error("\u67e5\u8be2\u7528\u6237\u9080\u8bf7\u8bb0\u5f55\u4e3a\u7a7a,customerId={},ActiveNo={}", (Object)sourceQrcode.getCustomerId(), (Object)activeEntity.getActiveNo());
            return BaseJsonVo.error((String)"\u672a\u77e5\u9519\u8bef");
        }
        CustomerDetailVo sourceCustomerDetailVo = this.customerService.getCustomerDetail(sourceQrcode.getCustomerId(), platformId);
        if (sourceCustomerDetailVo == null) {
            this.logger.error("\u67e5\u8be2\u9080\u8bf7\u7528\u6237\u51fa\u9519,customerId={}", (Object)sourceQrcode.getCustomerId());
            return BaseJsonVo.error((String)"\u672a\u77e5\u7528\u6237");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bindCode", activeQrcodeEntity.getBindCode());
        map.put("inviteId", activeInviteEntity.getInviteId());
        map.put("nickName", sourceCustomerDetailVo.getNickName());
        return this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, Integer.valueOf(sourceQrcode.getBuyKeywordId()), openId, map);
    }

    @Override
    public BaseJsonVo scanTempQrcode(String openId, String scence, int platformId) {
        return null;
    }
}

