/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.domain.qrcode;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.qrcode.QrcodeMapper;
import cc.lechun.mall.dao.qrcode.QrcodeSubMapper;
import cc.lechun.mall.entity.qrcode.QrExportVO;
import cc.lechun.mall.entity.qrcode.QrcodeEntity;
import cc.lechun.mall.entity.qrcode.QrcodeScanEntity;
import cc.lechun.mall.entity.qrcode.QrcodeSubEntity;
import cc.lechun.mall.entity.qrcode.QrcodeSubVO;
import cc.lechun.mall.entity.qrcode.QrcodeVO;
import cc.lechun.mall.entity.qrcode.SubQrCodeExportVO;
import cc.lechun.mall.entity.qrcode.SubQrLinkExportVO;
import cc.lechun.mall.idomain.qrcode.IQrcodeDomain;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeScanInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeSubInterface;
import cc.lechun.mall.iservice.weixin.WeixinLongUrl2ShortInterface;
import cc.lechun.utils.QRCodeUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class QrcodeDomain
implements IQrcodeDomain {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    QrcodeInterface qrcodeService;
    @Autowired
    QrcodeSubInterface qrcodeSubService;
    @Autowired
    QrcodeScanInterface qrcodeScanService;
    @Autowired
    QrcodeMapper qrcodeMapper;
    @Autowired
    QrcodeSubMapper qrcodeSubMapper;
    @Autowired
    WeixinLongUrl2ShortInterface weixinLongUrl2ShortInterface;
    @Autowired
    DictionaryInterface dictionaryService;
    @Autowired
    OssService ossService;
    @Autowired
    RedisService redisService;

    @Override
    public PageInfo<QrcodeVO> findQrList(PageForm pageForm, String qrName, Integer qrStatus) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.qrcodeMapper.findQrList(qrName, qrStatus);
        PageInfo rs = page.toPageInfo();
        rs.getList().forEach(e -> ((QrcodeVO)e).setQrImg(this.ossService.getImageResoure(((QrcodeVO)e).getQrImg())));
        return rs;
    }

    @Override
    public PageInfo<QrcodeSubEntity> findQrSubList(PageForm pageForm, Integer qrId, String subQrName) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.qrcodeSubMapper.getPageList(qrId, subQrName);
        PageInfo rs = page.toPageInfo();
        rs.getList().forEach(e -> ((QrcodeSubVO)e).setSubQrImg(this.ossService.getImageResoure(((QrcodeSubVO)e).getSubQrImg())));
        return rs;
    }

    @Override
    @Transactional
    public BaseJsonVo addOrEditQr(QrcodeEntity qr) {
        Boolean add = false;
        if (qr.getId() == null || qr.getId() <= 0) {
            BaseJsonVo jsonVo = this.qrcodeService.validateRepeat(qr, "qrName", "\u6d3b\u7801\u540d\u79f0");
            if (!jsonVo.isSuccess()) {
                return jsonVo;
            }
            add = true;
            qr.setQrStatus(1);
            qr.setQrShortLink("");
            qr.setQrFullLink("");
            qr.setQrImg("");
            int insertResult = this.qrcodeService.insert(qr);
            if (insertResult <= 0) {
                return BaseJsonVo.error((String)"\u6dfb\u52a0\u5931\u8d25");
            }
        } else {
            this.qrcodeService.updateByPrimaryKeySelective(qr);
            return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        this.redisService.sadd("Avilable_QR_IDS", qr.getId());
        if (add.booleanValue()) {
            String url = "";
            if (qr.getQrType() == 1) {
                url = this.dictionaryService.getDictionary(1000, 59, "LINK_URL").getDictionaryName();
            } else if (qr.getQrType() == 2) {
                url = this.dictionaryService.getDictionary(1000, 59, "WECHAT_URL").getDictionaryName();
            }
            if (StringUtils.isEmpty((String)url)) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25:\u8df3\u8f6c\u5730\u5740\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e");
            }
            url = url + "&qrcodeId=" + qr.getId();
            String shotUrl = "";
            BaseJsonVo shotUrlBaseJson = this.weixinLongUrl2ShortInterface.long2short(url);
            if (!shotUrlBaseJson.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return shotUrlBaseJson;
            }
            shotUrl = (String)shotUrlBaseJson.getValue();
            String qrImgUrl = "";
            BufferedImage bi = null;
            try {
                bi = QRCodeUtils.createImage(shotUrl, null, false);
            }
            catch (Exception e) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25:\u521b\u5efa\u4e8c\u7ef4\u7801\u56fe\u7247\u5931\u8d25");
            }
            try {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                ImageOutputStream imOut = null;
                imOut = ImageIO.createImageOutputStream(bs);
                ImageIO.write((RenderedImage)bi, "jpg", imOut);
                ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
                qrImgUrl = this.ossService.uploadFile(AliyunOSSDir.QRCODE_IMG_ROOT_STORAGE, String.valueOf(qr.getId()) + ".jpg", is);
            }
            catch (IOException e) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25:\u4e8c\u7ef4\u7801\u56fe\u7247\u4e0a\u4f20OSS\u5931\u8d25");
            }
            qr.setQrShortLink(shotUrl);
            qr.setQrFullLink(url);
            qr.setQrImg(qrImgUrl);
            this.qrcodeService.updateByPrimaryKey(qr);
        }
        return BaseJsonVo.success((Object)qr);
    }

    @Override
    public BaseJsonVo addOrEditQrSub(QrcodeSubEntity qrSub) {
        if (qrSub == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)qrSub.getSubQrName())) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u540d\u79f0");
        }
        if (qrSub.getQrSwitchNum() == null) {
            qrSub.setQrSwitchNum(0);
        }
        int insertOrUpdateResult = 0;
        qrSub.setSubQrImg(this.ossService.removeUrlDomain(qrSub.getSubQrImg()));
        Boolean add = qrSub.getId() == null;
        if (add.booleanValue()) {
            BaseJsonVo jsonVo = this.qrcodeSubService.validateRepeat(qrSub, "subQrName", "\u4e8c\u7ef4\u7801\u540d\u79f0");
            if (!jsonVo.isSuccess()) {
                return jsonVo;
            }
            qrSub.setQrScanNum(0);
            qrSub.setSubStatus(1);
            qrSub.setCreateTime(DateUtils.now());
            insertOrUpdateResult = this.qrcodeSubService.insert(qrSub);
        } else {
            insertOrUpdateResult = this.qrcodeSubService.updateByPrimaryKeySelective(qrSub);
        }
        QrcodeSubEntity current = (QrcodeSubEntity)this.redisService.get("CURRENT_QRCODE_" + qrSub.getQrId());
        if (!add.booleanValue() && insertOrUpdateResult > 0 && current != null && current.getId().intValue() == qrSub.getId().intValue()) {
            this.redisService.save("CURRENT_QRCODE_" + qrSub.getQrId(), qrSub);
            String redisKey = "CURRENT_QRCODEVO_" + qrSub.getId();
            this.redisService.delete(redisKey);
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo delQr(Integer qrId) {
        this.redisService.sremove("Avilable_QR_IDS", qrId);
        QrcodeSubEntity subParam = new QrcodeSubEntity();
        subParam.setQrId(qrId);
        List subList = this.qrcodeSubService.getList(subParam);
        if (subList == null || subList.size() == 0) {
            this.qrcodeService.deleteByPrimaryKey(qrId);
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        QrcodeEntity param = new QrcodeEntity();
        param.setId(qrId);
        param.setQrStatus(2);
        this.qrcodeService.updateByPrimaryKeySelective(param);
        BaseJsonVo succ = BaseJsonVo.success(null);
        succ.setMessage("\u6709\u5173\u8054\u5b50\u7801\uff0c\u505c\u7528\u6210\u529f");
        return succ;
    }

    @Override
    public BaseJsonVo delQrSub(Integer qrSubId) {
        QrcodeSubEntity qrSub = (QrcodeSubEntity)this.qrcodeSubService.selectByPrimaryKey(qrSubId);
        this.redisService.delete("CURRENT_QRCODE_" + qrSub.getQrId());
        String redisKey = "CURRENT_QRCODEVO_" + qrSub.getId();
        this.redisService.delete(redisKey);
        QrcodeScanEntity scanParam = new QrcodeScanEntity();
        scanParam.setSubQrId(qrSubId);
        List scanList = this.qrcodeScanService.getList(scanParam);
        if (scanList == null || scanList.size() == 0) {
            this.qrcodeSubService.deleteByPrimaryKey(qrSubId);
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        QrcodeSubEntity param = new QrcodeSubEntity();
        param.setId(qrSubId);
        param.setSubStatus(0);
        this.qrcodeSubService.updateByPrimaryKeySelective(param);
        BaseJsonVo succ = BaseJsonVo.success(null);
        succ.setMessage("\u6807\u8bb0\u4e3a\u5220\u9664\u72b6\u6001\u6210\u529f");
        return succ;
    }

    @Override
    public BaseJsonVo onoff(Integer qrId) {
        String succStr = "\u542f\u7528\u6210\u529f";
        QrcodeEntity qrcodeEntity = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey(qrId);
        if (qrcodeEntity.getQrStatus() == 0) {
            this.redisService.sadd("Avilable_QR_IDS", qrId);
            qrcodeEntity.setQrStatus(1);
        } else if (qrcodeEntity.getQrStatus() == 1) {
            this.redisService.sremove("Avilable_QR_IDS", qrId);
            qrcodeEntity.setQrStatus(2);
            succStr = "\u505c\u7528\u6210\u529f";
        } else if (qrcodeEntity.getQrStatus() == 2) {
            this.redisService.sadd("Avilable_QR_IDS", qrId);
            qrcodeEntity.setQrStatus(1);
        }
        this.qrcodeService.updateByPrimaryKey(qrcodeEntity);
        return BaseJsonVo.success((Object)succStr);
    }

    @Override
    public BaseJsonVo downloadQR(QrcodeEntity qr) {
        List<QrExportVO> data = this.qrcodeMapper.downloadQR(qr.getId());
        return data != null && data.size() > 0 ? BaseJsonVo.success(data) : BaseJsonVo.error();
    }

    @Override
    public BaseJsonVo downloadSubQR(QrcodeSubEntity qrSub) {
        QrcodeEntity qr = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey(qrSub.getQrId());
        if (qr.getQrType() == 1) {
            List<SubQrLinkExportVO> data = this.qrcodeMapper.downloadSubLink(qrSub.getId());
            return data != null && data.size() > 0 ? BaseJsonVo.success(data) : BaseJsonVo.error();
        }
        List<SubQrCodeExportVO> data = this.qrcodeMapper.downloadSubQrcode(qrSub.getId());
        return data != null && data.size() > 0 ? BaseJsonVo.success(data) : BaseJsonVo.error();
    }
}

