/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.deliver.MallFreightIntervalMapper;
import cc.lechun.mall.dao.deliver.MallFreightMapper;
import cc.lechun.mall.entity.deliver.MallFreightCalVo;
import cc.lechun.mall.entity.deliver.MallFreightEntity;
import cc.lechun.mall.entity.deliver.MallFreightIntervalEntity;
import cc.lechun.mall.entity.deliver.MallFreightPageVo;
import cc.lechun.mall.entity.deliver.MallFreightRuleVo;
import cc.lechun.mall.entity.deliver.MallFreightVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.user.SysUserService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallFreightService
implements MallFreightInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallFreightService.class);
    @Autowired
    private MallFreightMapper mallFreightMapper;
    @Autowired
    private MallFreightIntervalMapper mallFreightIntervalMapper;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @Override
    public List<MallFreightPageVo> getFreighList(MallFreightEntity mallFreightEntity) {
        List<MallFreightPageVo> mallFreightEntityList = this.mallFreightMapper.getFreighList(mallFreightEntity);
        return mallFreightEntityList;
    }

    @Override
    public PageInfo getFreighListByPage(int currentPage, int pageSize, MallFreightEntity mallFreightEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.getFreighList(mallFreightEntity);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                if (StringUtils.isNotEmpty((String)o.getCreateBy())) {
                    o.setCreateBy(this.sysUserService.getMallUserNickName(o.getCreateBy()));
                }
            });
        }
        return pg;
    }

    @Override
    public void saveMallFreight(MallFreightEntity mallFreightEntity) {
        this.mallFreightMapper.saveMallFreight(mallFreightEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo saveMallFreightRules(String mallFreightRulesJson, String unifyId, MallUserEntity user) {
        if (StringUtils.isNotEmpty((String)mallFreightRulesJson)) {
            BaseJsonVo vaseJsonVo;
            String json = null;
            try {
                json = URLDecoder.decode(mallFreightRulesJson, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            logger.info("===============\u4fdd\u5b58\u57ce\u5e02\u8fd0\u8d39\u89c4\u5219\u53c2\u6570   city freight rule==={}", (Object)json);
            if (StringUtils.isNotEmpty((String)unifyId)) {
                List<MallFreightEntity> freightIdList = this.mallFreightMapper.getFreighByFreightCityIds(unifyId, user.getPlatformGroupId());
                this.mallFreightMapper.deleteFreightByFreightCityIds(unifyId, user.getPlatformGroupId());
                if (freightIdList != null && freightIdList.size() > 0) {
                    for (MallFreightEntity mallFreightVo : freightIdList) {
                        this.mallFreightIntervalMapper.deleteFreightIntervalByFreightId(mallFreightVo.getId());
                    }
                }
            } else {
                unifyId = IDGenerate.getUniqueIdStr();
            }
            if (200 == (vaseJsonVo = this.ValiDateFreightRules(json, user.getPlatformGroupId())).getStatus()) {
                MallFreightVo mallFreightVo = (MallFreightVo)JSON.parseObject((String)json, MallFreightVo.class);
                if (mallFreightVo != null) {
                    List<MallFreightRuleVo> freightRuleList = null;
                    freightRuleList = mallFreightVo.getFreightRuleList();
                    if (freightRuleList != null) {
                        ArrayList<MallFreightEntity> mallFreightEntityList = new ArrayList<MallFreightEntity>();
                        for (MallFreightRuleVo mallFreightRuleVo : freightRuleList) {
                            MallFreightEntity mallFreightEntity = new MallFreightEntity();
                            mallFreightEntity.setFreightCityIds(mallFreightRuleVo.getFreightCityIds());
                            mallFreightEntity.setFreightCityNames(mallFreightRuleVo.getFreightCityNames());
                            mallFreightEntity.setStatus(1);
                            if (user != null) {
                                mallFreightEntity.setPlatformGroupId(user.getPlatformGroupId());
                                mallFreightEntity.setCreateBy(user.getUserId());
                                mallFreightEntity.setUpdateBy(user.getUserId());
                            }
                            mallFreightEntity.setCreateTime(new Date());
                            mallFreightEntity.setUpdateTime(new Date());
                            String id = IDGenerate.getUniqueIdStr();
                            mallFreightEntity.setId(id);
                            mallFreightEntity.setDeliveryType(mallFreightRuleVo.getDeliveryType());
                            mallFreightEntity.setSendAmount(mallFreightRuleVo.getSendAmount());
                            mallFreightEntity.setFreightFreeAmount(mallFreightRuleVo.getFreightFreeAmount());
                            List<MallFreightIntervalEntity> freightRules = null;
                            freightRules = mallFreightRuleVo.getFreightRules();
                            if (freightRules != null) {
                                for (MallFreightIntervalEntity mallFreightIntervalEntity : freightRules) {
                                    String freightIntervalId = IDGenerate.getUniqueIdStr();
                                    mallFreightIntervalEntity.setId(freightIntervalId);
                                    mallFreightIntervalEntity.setFreightId(id);
                                }
                                this.mallFreightIntervalMapper.saveBatchMallFreightInterval(freightRules);
                            } else if (StringUtils.isEmpty((String)mallFreightRuleVo.getSendAmount().toString()) && StringUtils.isEmpty((String)mallFreightRuleVo.getFreightFreeAmount().toString())) {
                                mallFreightEntity.setIsSet(0);
                            }
                            mallFreightEntity.setIsSet(1);
                            mallFreightEntity.setUnifyId(unifyId);
                            mallFreightEntityList.add(mallFreightEntity);
                        }
                        this.mallFreightMapper.saveBatchMallFreight(mallFreightEntityList);
                    }
                }
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            return vaseJsonVo;
        }
        logger.info("==mallFreightRulesJson \u4e3a null=============\u4fdd\u5b58\u57ce\u5e02\u8fd0\u8d39\u89c4\u5219\u53c2\u6570   city freight rule==={0}==", (Object)mallFreightRulesJson);
        return BaseJsonVo.error((String)"\u9a8c\u8bc1\u5931\u8d25\uff01\u63d0\u4ea4\u53c2\u6570\u4e3a\u7a7a");
    }

    public BaseJsonVo ValiDateFreightRules(String mallFreightRulesJson, int platformGroupId) {
        String message = "\u9a8c\u8bc1\u901a\u8fc7";
        if (StringUtils.isNotBlank((String)mallFreightRulesJson)) {
            List<Object> freightCityList = new ArrayList();
            MallFreightVo mallFreightVo = (MallFreightVo)JSON.parseObject((String)mallFreightRulesJson, MallFreightVo.class);
            if (mallFreightVo != null) {
                List<MallFreightRuleVo> freightRuleList = null;
                freightRuleList = mallFreightVo.getFreightRuleList();
                Pattern pattern = Pattern.compile("[0-9]*");
                if (freightRuleList != null) {
                    for (MallFreightRuleVo mallFreightRuleVo : freightRuleList) {
                        int i;
                        String freightFreeAmount;
                        boolean freightFreeAmountBoolean;
                        BigDecimal freightFreeAmountBig;
                        if (StringUtils.isEmpty((String)mallFreightRuleVo.getFreightCityIds())) {
                            logger.error("================\u9a8c\u8bc1\u5931\u8d25\uff01\u57ce\u5e02\u4e3a\u7a7a===================");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u57ce\u5e02\u4e3a\u7a7a";
                            return BaseJsonVo.error((String)message);
                        }
                        if (StringUtils.isNotEmpty((String)mallFreightRuleVo.getFreightCityIds())) {
                            String[] a;
                            String freightCityIds = mallFreightRuleVo.getFreightCityIds();
                            ArrayList<String> freightCityIdList = new ArrayList<String>();
                            for (String res : a = freightCityIds.split(",")) {
                                freightCityIdList.add(res);
                            }
                            freightCityList = this.mallFreightMapper.queryFreightCity(freightCityIdList, platformGroupId);
                            if (freightCityList != null && freightCityList.size() > 0) {
                                logger.error("================\u9a8c\u8bc1\u5931\u8d25\uff01\u57ce\u5e02\u89c4\u5219\u5df2\u7ecf\u5b58\u5728===================");
                                message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u57ce\u5e02\u89c4\u5219\u5df2\u7ecf\u5b58\u5728";
                                return BaseJsonVo.error((String)message);
                            }
                        }
                        if (mallFreightRuleVo.getSendAmount() != null && mallFreightRuleVo.getFreightFreeAmount() == null) {
                            logger.error("===============\u9a8c\u8bc1\u5931\u8d25\uff01\u514d\u8fd0\u8d39\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a=========================");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u514d\u8fd0\u8d39\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a";
                            return BaseJsonVo.error((String)message);
                        }
                        if (mallFreightRuleVo.getFreightFreeAmount() != null && mallFreightRuleVo.getSendAmount() == null) {
                            logger.error("===============\u9a8c\u8bc1\u5931\u8d25\uff01\u8d77\u9001\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a=========================");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u8d77\u9001\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a";
                            return BaseJsonVo.error((String)message);
                        }
                        if (mallFreightRuleVo.getSendAmount().compareTo(BigDecimal.ZERO) <= 0 && mallFreightRuleVo.getFreightFreeAmount().compareTo(BigDecimal.ZERO) <= 0) {
                            logger.error("=====================\u9a8c\u8bc1\u5931\u8d25\uff01\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6=============================");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6";
                            return BaseJsonVo.error((String)message);
                        }
                        BigDecimal sendAmountBig = mallFreightRuleVo.getSendAmount();
                        logger.info("--------------\u8d77\u9001\u91d1\u989d--=====sendAmount----===sendAmountBig={},mallFreightRuleVo.getSendAmount()={}", (Object)sendAmountBig, (Object)mallFreightRuleVo.getSendAmount());
                        if (sendAmountBig != null) {
                            String sendAmount = mallFreightRuleVo.getSendAmount().toString();
                            logger.info("--------------\u8d77\u9001\u91d1\u989d--=====sendAmount----====={}", (Object)sendAmount);
                            boolean sendAmountBoolean = pattern.matcher(sendAmount).matches();
                            logger.info("--------------\u8d77\u9001\u91d1\u989d--=====sendAmountBoolean={},sendAmount={}", (Object)sendAmountBoolean, (Object)sendAmount);
                            if (!sendAmountBoolean) {
                                logger.error("=====================\u9a8c\u8bc1\u5931\u8d25\uff01\u8d77\u9001\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e=============================");
                                message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u8d77\u9001\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e";
                                return BaseJsonVo.error((String)message);
                            }
                        }
                        if ((freightFreeAmountBig = mallFreightRuleVo.getFreightFreeAmount()) != null && !(freightFreeAmountBoolean = pattern.matcher(freightFreeAmount = mallFreightRuleVo.getFreightFreeAmount().toString()).matches())) {
                            logger.error("=====================\u9a8c\u8bc1\u5931\u8d25\uff01\u514d\u8fd0\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e=============================");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u514d\u8fd0\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e";
                            return BaseJsonVo.error((String)message);
                        }
                        if (mallFreightRuleVo.getFreightFreeAmount() != null && mallFreightRuleVo.getSendAmount() != null && (i = mallFreightRuleVo.getSendAmount().compareTo(mallFreightRuleVo.getFreightFreeAmount())) == 1) {
                            logger.error("===============\u9a8c\u8bc1\u5931\u8d25\uff01\u514d\u8fd0\u8d39\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u9001\u91d1\u989d=========================");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u514d\u8fd0\u8d39\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u9001\u91d1\u989d";
                            return BaseJsonVo.error((String)message);
                        }
                        List<MallFreightIntervalEntity> freightRules = null;
                        freightRules = mallFreightRuleVo.getFreightRules();
                        BigDecimal endAndNextBeginAmount = new BigDecimal("0");
                        int m = 0;
                        if (freightRules == null) continue;
                        for (MallFreightIntervalEntity mallFreightIntervalEntity : freightRules) {
                            int n;
                            ++m;
                            BigDecimal beginAmountBig = mallFreightIntervalEntity.getBeginAmount();
                            if (beginAmountBig == null) continue;
                            if (mallFreightIntervalEntity.getBeginAmount().compareTo(BigDecimal.ZERO) <= 0 && mallFreightIntervalEntity.getEndAmount().compareTo(BigDecimal.ZERO) <= 0 && mallFreightIntervalEntity.getFreightAmount().compareTo(BigDecimal.ZERO) <= 0) {
                                logger.error("=====================\u9a8c\u8bc1\u5931\u8d25\uff01\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6=============================");
                                message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6";
                                return BaseJsonVo.error((String)message);
                            }
                            String beginAmount = mallFreightIntervalEntity.getBeginAmount().toString();
                            String endAmount = mallFreightIntervalEntity.getEndAmount().toString();
                            if (m > 1 && (n = mallFreightIntervalEntity.getBeginAmount().compareTo(endAndNextBeginAmount)) == -1) {
                                logger.error("===========\u9a8c\u8bc1\u5931\u8d25\uff01\u8fd0\u8d39\u533a\u95f4\u4e0d\u80fd\u5305\u542b=============");
                                message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u8fd0\u8d39\u533a\u95f4\u4e0d\u80fd\u5305\u542b";
                                return BaseJsonVo.error((String)message);
                            }
                            endAndNextBeginAmount = mallFreightIntervalEntity.getEndAmount();
                            String freightAmount = mallFreightIntervalEntity.getFreightAmount().toString();
                            boolean beginAmountBoolean = pattern.matcher(beginAmount).matches();
                            boolean endAmountBoolean = pattern.matcher(endAmount).matches();
                            boolean freightAmountBoolean = pattern.matcher(freightAmount).matches();
                            if (!(beginAmountBoolean && endAmountBoolean && freightAmountBoolean)) {
                                logger.error("===========\u9a8c\u8bc1\u5931\u8d25\uff01\u63d0\u4ea4\u53c2\u6570\u683c\u5f0f\u4e0d\u5bf9=========");
                                message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u63d0\u4ea4\u53c2\u6570\u683c\u5f0f\u4e0d\u5bf9";
                                return BaseJsonVo.error((String)message);
                            }
                            int a = mallFreightIntervalEntity.getBeginAmount().compareTo(mallFreightIntervalEntity.getEndAmount());
                            if (a != 1) continue;
                            logger.error("===========\u9a8c\u8bc1\u5931\u8d25\uff01\u7ed3\u675f\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u59cb\u91d1\u989d======");
                            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u7ed3\u675f\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u59cb\u91d1\u989d";
                            return BaseJsonVo.error((String)message);
                        }
                    }
                }
            }
        } else {
            logger.error("==========\u9a8c\u8bc1\u5931\u8d25\uff01\u63d0\u4ea4\u53c2\u6570\u4e3a\u7a7a====");
            message = "\u9a8c\u8bc1\u5931\u8d25\uff01\u63d0\u4ea4\u53c2\u6570\u4e3a\u7a7a";
            return BaseJsonVo.error((String)message);
        }
        return BaseJsonVo.success((Object)message);
    }

    @Override
    public JSONArray queryEditDataByFreightId(String unifyId, MallUserEntity user) {
        List<MallFreightPageVo> mallFreightEntityList = this.mallFreightMapper.getFreighDetail(unifyId, user.getPlatformGroupId());
        JSONArray freightRuleArray = new JSONArray();
        if (mallFreightEntityList != null && mallFreightEntityList.size() > 0) {
            HashMap freightRuleMap = new HashMap();
            for (MallFreightPageVo mallFreightEntity : mallFreightEntityList) {
                JSONObject freightRuleObject = new JSONObject();
                HashMap freightRuleList = new HashMap();
                freightRuleObject.put("freightCityIds", (Object)mallFreightEntity.getFreightCityIds());
                freightRuleObject.put("freightCityNames", (Object)mallFreightEntity.getFreightCityNames());
                if (mallFreightEntity.getSendAmount() != null) {
                    freightRuleObject.put("sendAmount", (Object)mallFreightEntity.getSendAmount().toString());
                } else {
                    freightRuleObject.put("sendAmount", (Object)"");
                }
                if (mallFreightEntity.getFreightFreeAmount() != null) {
                    freightRuleObject.put("freightFreeAmount", (Object)mallFreightEntity.getFreightFreeAmount().toString());
                } else {
                    freightRuleObject.put("freightFreeAmount", (Object)"");
                }
                freightRuleObject.put("deliveryType", (Object)mallFreightEntity.getDeliveryType());
                MallFreightIntervalEntity mallFreightIntervalEntity = mallFreightEntity.getMallFreightIntervalEntity();
                JSONArray freightRulesArray = new JSONArray();
                HashMap<String, String> freightRules = new HashMap<String, String>();
                if (mallFreightIntervalEntity != null) {
                    if (mallFreightIntervalEntity.getBeginAmount() != null) {
                        freightRules.put("beginAmount", mallFreightIntervalEntity.getBeginAmount().toString());
                    } else {
                        freightRules.put("beginAmount", "");
                    }
                    if (mallFreightIntervalEntity.getEndAmount() != null) {
                        freightRules.put("endAmount", mallFreightIntervalEntity.getEndAmount().toString());
                    } else {
                        freightRules.put("endAmount", "");
                    }
                    if (mallFreightIntervalEntity.getFreightAmount() != null) {
                        freightRules.put("freightAmount", mallFreightIntervalEntity.getFreightAmount().toString());
                    } else {
                        freightRules.put("freightAmount", "");
                    }
                    freightRulesArray.add(freightRules);
                }
                String deliveryType = mallFreightEntity.getDeliveryType();
                int no = 0;
                if (freightRuleArray != null && freightRuleArray.size() > 0) {
                    for (JSONObject job : freightRuleArray) {
                        JSONArray freightRulesArr;
                        String deliveryTypeObject = job.getString("deliveryType");
                        if (deliveryType.equals(deliveryTypeObject)) {
                            ++no;
                            freightRulesArr = job.getJSONArray("freightRules");
                            freightRulesArr.add(freightRules);
                            freightRuleObject.put("freightRules", (Object)freightRulesArr);
                            break;
                        }
                        freightRulesArr = new JSONArray();
                        freightRulesArr.add(freightRules);
                        freightRuleObject.put("freightRules", (Object)freightRulesArr);
                    }
                } else {
                    JSONArray freightRulesArr = new JSONArray();
                    freightRulesArr.add(freightRules);
                    freightRuleObject.put("freightRules", (Object)freightRulesArr);
                }
                if (no != 0) {
                    freightRuleArray.remove(--no);
                }
                freightRuleArray.add(0, (Object)freightRuleObject);
            }
        }
        return freightRuleArray;
    }

    @Override
    @Transactional
    public BaseJsonVo deleteFreightRules(String unifyId, MallUserEntity user) {
        String message = "\u5220\u9664\u6210\u529f";
        if (StringUtils.isEmpty((String)unifyId)) {
            logger.error("========\u5220\u9664\u5931\u8d25\uff01\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e===");
            message = "\u5220\u9664\u5931\u8d25\uff01\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e";
            return BaseJsonVo.success((Object)message);
        }
        List<MallFreightEntity> freightIdList = this.mallFreightMapper.getFreighByFreightCityIds(unifyId, user.getPlatformGroupId());
        if (freightIdList == null || freightIdList.size() <= 0) {
            logger.error("========\u5220\u9664\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u6b63\u786e\u6027===");
            message = "\u5220\u9664\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u6b63\u786e\u6027";
            return BaseJsonVo.success((Object)message);
        }
        this.mallFreightMapper.deleteFreightByFreightCityIds(unifyId, user.getPlatformGroupId());
        for (MallFreightEntity mallFreightVo : freightIdList) {
            this.mallFreightIntervalMapper.deleteFreightIntervalByFreightId(mallFreightVo.getId());
        }
        return BaseJsonVo.success((Object)message);
    }

    @Override
    public JSONArray getFreightByCityAmountDeliveryType(List<MallFreightCalVo> mallFreightCalVoList, Boolean coldGroups, Boolean nomalGroups) {
        JSONArray freightArray = new JSONArray();
        if (mallFreightCalVoList != null && mallFreightCalVoList.size() > 0) {
            BigDecimal freightAmount = new BigDecimal("0");
            for (MallFreightCalVo mallFreightCalVo : mallFreightCalVoList) {
                this.freightRulesCal(mallFreightCalVo, freightArray, freightAmount, mallFreightCalVo.getCityId(), mallFreightCalVo.getDeliverId(), mallFreightCalVo.getAmount(), coldGroups, nomalGroups);
            }
        }
        return freightArray;
    }

    @ReadThroughSingleCache(namespace="cityFreight", expiration=180)
    private void freightRulesCal(MallFreightCalVo mallFreightCalVo, JSONArray freightArray, BigDecimal freightAmount, @ParameterValueKeyProvider(order=0) String cityId, @ParameterValueKeyProvider(order=1) String deliverId, @ParameterValueKeyProvider(order=2) BigDecimal amount, Boolean coldGroups, Boolean nomalGroups) {
        List<DictionaryEntity> dics;
        logger.info("\u8ba1\u7b97\u8fd0\u8d39\u53c2\u6570mallFreightCalVo={}", (Object)JSON.toJSONString((Object)mallFreightCalVo));
        boolean isFreeFreight = false;
        if ((mallFreightCalVo.getPromotionId() != null && !mallFreightCalVo.getPromotionId().isEmpty() || mallFreightCalVo.getBindCode() != null && !mallFreightCalVo.getBindCode().isEmpty()) && (dics = this.dictionaryInterface.getValidDictionaryList(mallFreightCalVo.getPlatFormGroupId(), 104)) != null && dics.size() > 0) {
            for (DictionaryEntity d : dics) {
                if (mallFreightCalVo.getPromotionId() != null && !mallFreightCalVo.getPromotionId().isEmpty() && d.getDictionaryName() != null && !d.getDictionaryName().isEmpty() && mallFreightCalVo.getPromotionId().contains(d.getDictionaryName())) {
                    isFreeFreight = true;
                    break;
                }
                if (mallFreightCalVo.getBindCode() == null || mallFreightCalVo.getBindCode().isEmpty() || d.getDictionaryName() == null || d.getDictionaryName().isEmpty() || !mallFreightCalVo.getBindCode().equals(d.getDictionaryName())) continue;
                isFreeFreight = true;
                break;
            }
        }
        if (mallFreightCalVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK.getValue() || mallFreightCalVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() || mallFreightCalVo.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue() || isFreeFreight) {
            freightArray = null;
        } else {
            JSONObject jsonObject = new JSONObject();
            MallFreightEntity mallFreightEntity = new MallFreightEntity();
            mallFreightEntity = this.mallFreightMapper.getFreighByCityIds(mallFreightCalVo.getCityId(), mallFreightCalVo.getDeliverId(), mallFreightCalVo.getPlatFormGroupId());
            logger.info("=======\u8fd0\u8d39freightRulesCal==mallFreightEntity============{}", (Object)JSON.toJSONString((Object)mallFreightEntity));
            if (mallFreightEntity == null) {
                mallFreightEntity = this.mallFreightMapper.getFreighByCityIds("-1", mallFreightCalVo.getDeliverId(), mallFreightCalVo.getPlatFormGroupId());
            } else if (mallFreightEntity.getSendAmount() == null && (mallFreightEntity = this.mallFreightMapper.getFreighByCityIds("-1", mallFreightCalVo.getDeliverId(), mallFreightCalVo.getPlatFormGroupId())) == null) {
                freightArray = null;
                logger.info("_____\u6ca1\u6709\u67e5\u5230\u8fd0\u8d39\uff0c\u67e5\u8be2\u6761\u4ef6\uff1acityId:" + mallFreightCalVo.getCityId() + ",deliverId:" + mallFreightCalVo.getDeliverId() + ",platformGroupId:" + mallFreightCalVo.getPlatFormGroupId());
                return;
            }
            String freightId = mallFreightEntity.getId();
            List<MallFreightIntervalEntity> mallFreightIntervalEntityList = this.mallFreightIntervalMapper.getFreighByAmount(freightId, mallFreightCalVo.getAmount());
            if (mallFreightIntervalEntityList != null && mallFreightIntervalEntityList.size() > 0) {
                MallFreightIntervalEntity mallFreightIntervalEntity = mallFreightIntervalEntityList.get(0);
                freightAmount = mallFreightIntervalEntity.getFreightAmount();
            }
            Boolean quickBalanceStatus = true;
            Boolean coldBalanceStatus = true;
            Boolean nomalBalanceStatus = true;
            if ("3".equals(mallFreightCalVo.getDeliverId())) {
                if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getSendAmount()) < 0) {
                    quickBalanceStatus = false;
                    jsonObject.put("quickNotice", (Object)("\u6ee1" + mallFreightEntity.getSendAmount() + "\u5143\u8d77\u9001\uff0c\u5f53\u524d\u8fd8\u5dee" + mallFreightEntity.getSendAmount().subtract(mallFreightCalVo.getAmount()) + "\u5143"));
                } else if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getFreightFreeAmount()) >= 0) {
                    jsonObject.put("quickNotice", (Object)("\u5df2\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    freightAmount = new BigDecimal(0);
                } else {
                    jsonObject.put("quickNotice", (Object)("\u672a\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143,\u9700" + freightAmount + "\u5143\u8fd0\u8d39"));
                }
            } else {
                if ("1".equals(mallFreightCalVo.getDeliverId())) {
                    if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getSendAmount()) < 0) {
                        coldBalanceStatus = false;
                        jsonObject.put("coldchainNotice", (Object)("\u6ee1" + mallFreightEntity.getSendAmount() + "\u5143\u8d77\u9001\uff0c\u5f53\u524d\u8fd8\u5dee" + mallFreightEntity.getSendAmount().subtract(mallFreightCalVo.getAmount()) + "\u5143"));
                    } else if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getFreightFreeAmount()) >= 0) {
                        jsonObject.put("coldchainNotice", (Object)("\u5df2\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                        freightAmount = new BigDecimal(0);
                    } else {
                        jsonObject.put("coldchainNotice", (Object)("\u672a\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143,\u9700" + freightAmount + "\u5143\u8fd0\u8d39"));
                    }
                }
                if ("2".equals(mallFreightCalVo.getDeliverId())) {
                    if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getSendAmount()) < 0) {
                        nomalBalanceStatus = false;
                        jsonObject.put("nomalNotice", (Object)("\u6ee1" + mallFreightEntity.getSendAmount() + "\u5143\u8d77\u9001\uff0c\u5f53\u524d\u8fd8\u5dee" + mallFreightEntity.getSendAmount().subtract(mallFreightCalVo.getAmount()) + "\u5143"));
                    } else if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getFreightFreeAmount()) >= 0) {
                        jsonObject.put("nomalNotice", (Object)("\u5df2\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                        freightAmount = new BigDecimal(0);
                    } else {
                        jsonObject.put("nomalNotice", (Object)("\u672a\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143,\u9700" + freightAmount + "\u5143\u8fd0\u8d39"));
                    }
                }
            }
            jsonObject.put("quickBalanceStatus", (Object)quickBalanceStatus);
            jsonObject.put("nomalBalanceStatus", (Object)nomalBalanceStatus);
            jsonObject.put("coldBalanceStatus", (Object)coldBalanceStatus);
            freightAmount.add(freightAmount);
            jsonObject.put("freightAmount", (Object)freightAmount);
            jsonObject.put("deliveryType", (Object)mallFreightCalVo.getDeliverId());
            freightArray.add((Object)jsonObject);
        }
    }
}

