/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallOrderDeliverRecordMapper;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import cc.lechun.mall.iservice.deliver.MallOrderDeliverRecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderDeliverRecordService
extends BaseService
implements MallOrderDeliverRecordInterface {
    @Autowired
    private MallOrderDeliverRecordMapper orderDeliverRecordMapper;
    @Autowired
    private DeliverRouteInterface deliverRouteInterface;
    @Autowired
    private MallOrderInterface orderInterface;

    @Override
    @ReadThroughSingleCache(namespace="MallOrderDeliverRecordService.getDeliverRecordList", expiration=60)
    public List<OrderDeliverRecordVo> getDeliverRecordList(@ParameterValueKeyProvider String orderNo) {
        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
        if (orderEntity == null) {
            new ArrayList();
        }
        if (orderEntity.getPickupTime().before(DateUtils.getDateFromString((String)"2019-03-11"))) {
            List<OrderDeliverRecordVo> orderDeliverRecordVos = this.orderDeliverRecordMapper.getDeliverRecordList(orderNo);
            if (orderDeliverRecordVos != null) {
                orderDeliverRecordVos.sort(Comparator.comparing(OrderDeliverRecordVo::getPushTime).reversed().thenComparing(OrderDeliverRecordVo::getOrderdeliverRecordId).reversed());
            }
            return orderDeliverRecordVos;
        }
        return this.deliverRouteInterface.getRouteInfoForWexin(orderNo);
    }
}

