/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQueryVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.platform.PlatFormGroupEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorItemMapper;
import cc.lechun.mall.entity.distribution.DistributorItemDetailEntity;
import cc.lechun.mall.entity.distribution.DistributorItemEntity;
import cc.lechun.mall.entity.distribution.DistributorItemEntityVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemDetailInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class DistributorItemService
extends BaseService<DistributorItemEntity, Integer>
implements DistributorItemInterface {
    @Resource
    private DistributorItemMapper distributorItemMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private DistributorItemDetailInterface distributorItemDetailInterface;
    @Autowired
    private OssService ossService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveDistributorItem(List<DistributorItemEntityVo> entities, MallUserEntity user) {
        try {
            List dels = entities.stream().map(c -> c.getId()).distinct().collect(Collectors.toList());
            for (Integer d : dels) {
                this.distributorItemDetailInterface.deleteDistributorItemDetail(d);
            }
            ArrayList<DistributorItemEntity> items = new ArrayList<DistributorItemEntity>();
            ArrayList<DistributorItemDetailEntity> details = new ArrayList<DistributorItemDetailEntity>();
            for (DistributorItemEntityVo i : entities) {
                DistributorItemEntity distributorItemEntity = new DistributorItemEntity();
                BeanUtils.beanCopy((Object)i, (Object)distributorItemEntity);
                distributorItemEntity.setGroupId(0);
                distributorItemEntity.setUpdateTime(new Date());
                distributorItemEntity.setOperator(user.getUserNick());
                if (Integer.valueOf(0).equals(distributorItemEntity.getIsDistribution())) {
                    distributorItemEntity.setPercentage(BigDecimal.ZERO);
                }
                items.add(distributorItemEntity);
                if (!Integer.valueOf(1).equals(distributorItemEntity.getIsDistribution()) || !Integer.valueOf(1).equals(i.getPercentageType())) continue;
                for (DistributorItemDetailEntity d : i.getDetailEntity()) {
                    if (!(d.getPercentage().doubleValue() > 0.0)) continue;
                    DistributorItemDetailEntity distributorItemDetailEntity = new DistributorItemDetailEntity();
                    BeanUtils.beanCopy((Object)i, (Object)distributorItemDetailEntity);
                    distributorItemDetailEntity.setDistributorItemId(distributorItemDetailEntity.getId());
                    distributorItemDetailEntity.setId(null);
                    distributorItemDetailEntity.setGroupId(d.getGroupId());
                    distributorItemDetailEntity.setUpdateTime(new Date());
                    distributorItemDetailEntity.setOperator(user.getUserNick());
                    distributorItemDetailEntity.setPercentage(d.getPercentage());
                    distributorItemDetailEntity.setPlatformId(i.getPlatformId());
                    details.add(distributorItemDetailEntity);
                }
            }
            if (this.batchUpdate(items) <= 0) {
                throw new Exception("\u6279\u91cf\u66f4\u65b0\u5931\u8d25");
            }
            if (details.size() > 0 && this.distributorItemDetailInterface.batchInsert(details) == 0) {
                throw new Exception("\u6279\u91cf\u63d2\u5165\u5931\u8d25");
            }
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u4fdd\u5b58\u5206\u9500\u5546\u54c1\u8bbe\u7f6e\u5931\u8d25,result:" + e.getMessage());
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Override
    public DistributorItemEntityVo getSingleDistributorItem(Integer id) {
        DistributorItemEntityVo vo = new DistributorItemEntityVo();
        if (id == null || id == 0) {
            vo.setIsDistribution(0);
            vo.setPercentageType(0);
            vo.setPercentage(BigDecimal.ZERO);
            id = 0;
        } else {
            DistributorItemEntity d = (DistributorItemEntity)this.selectByPrimaryKey(id);
            BeanUtils.beanCopy((Object)d, (Object)vo);
        }
        vo.setDetailEntity(this.distributorItemDetailInterface.getDistributorItemDetail(id));
        return vo;
    }

    @Override
    public BaseJsonVo initDistributorItem(String itemId, Integer groupType) {
        Serializable param;
        ArrayList lst = new ArrayList();
        if (groupType == null || Integer.valueOf(4).equals(groupType)) {
            MallProductEntity productEntity = new MallProductEntity();
            productEntity.setPlatformGroupId(PlatFormGroupEnum.LECHUN.getValue());
            productEntity.setProState(1);
            productEntity.setProId(itemId);
            List<MallProductEntity> productEntities = this.productInterface.getList(productEntity);
            productEntities = productEntities.stream().filter(c -> c.getDeleteTime() == null).collect(Collectors.toList());
            for (MallProductEntity mallProductEntity : productEntities) {
                this.buildDistributorItem(mallProductEntity.getProId(), 4, mallProductEntity.getProName(), null, new BigDecimal(StringUtil.isEmpty((String)mallProductEntity.getProPrice()) ? "0" : mallProductEntity.getProPrice()));
            }
        }
        if (groupType == null || Integer.valueOf(2).equals(groupType)) {
            MallProductGroupEntity groupEntity = new MallProductGroupEntity();
            groupEntity.setPlatformGroupId(PlatFormGroupEnum.LECHUN.getValue());
            groupEntity.setStatus(1);
            groupEntity.setGroupId(itemId);
            List<MallProductGroupEntity> groupEntities = this.groupInterface.getList(groupEntity);
            for (MallProductGroupEntity mallProductGroupEntity : groupEntities) {
                this.buildDistributorItem(mallProductGroupEntity.getGroupId(), 2, mallProductGroupEntity.getGroupName(), null, mallProductGroupEntity.getSalePrice());
            }
        }
        if (groupType == null || Integer.valueOf(1).equals(groupType)) {
            param = new MallPromotionEntity();
            ((MallPromotionEntity)param).setPlatformGroupId(PlatFormGroupEnum.LECHUN.getValue());
            ((MallPromotionEntity)param).setStatus(1);
            ((MallPromotionEntity)param).setPromotionId(itemId);
            PageInfo pageInfo = this.promotionInterface.getPromotionList(0, 1000, (MallPromotionEntity)param);
            for (MallPromotionEntity mallPromotionEntity : pageInfo.getList()) {
                MallPromotionProductEntity pp = this.promotionProductInterface.getPromotionProductEntity(mallPromotionEntity.getPromotionId());
                if (pp == null) continue;
                this.buildDistributorItem(mallPromotionEntity.getPromotionId(), 1, mallPromotionEntity.getPromotionName(), null, pp.getPromotionPrice());
            }
        }
        if (groupType == null || Integer.valueOf(5).equals(groupType)) {
            param = new ActiveQueryVo();
            ((ActiveQueryVo)param).setCurrentPage(0);
            ((ActiveQueryVo)param).setPageSize(10000);
            ((ActiveQueryVo)param).setStatus(1);
            ((ActiveQueryVo)param).setActiveNo(itemId);
            List<ActiveEntity> activeEntities = this.activeInterface.getList((ActiveQueryVo)param);
            for (ActiveEntity activeEntity : activeEntities) {
                this.buildDistributorItem(activeEntity.getActiveNo(), 5, activeEntity.getActiveName(), null, null);
            }
        }
        return BaseJsonVo.success((Object)"\u521d\u59cb\u5316\u5b8c\u6210");
    }

    private void buildDistributorItem(String itemId, Integer itemType, String itemName, String imageImage, BigDecimal price) {
        DistributorItemEntity param = new DistributorItemEntity();
        param.setItemId(itemId);
        param.setItemType(itemType);
        DistributorItemEntity itemEntity = (DistributorItemEntity)this.getSingle(param, 0L);
        if (itemEntity != null) {
            itemEntity.setItemName(itemName);
            itemEntity.setItemImage(imageImage);
            itemEntity.setPrice(price);
            this.updateByPrimaryKey(itemEntity);
            return;
        }
        param.setItemName(itemName);
        param.setItemImage(imageImage);
        param.setPrice(price);
        param.setOperator("system");
        param.setCreateTime(new Date());
        param.setUpdateTime(new Date());
        param.setPlatformId(1);
        param.setPercentageType(0);
        BigDecimal percentage = new BigDecimal(this.dictionaryInterface.getDictionary(1000, 206, "PERCENTAGE").getDictionaryName());
        Integer isDistribution = Integer.valueOf(this.dictionaryInterface.getDictionary(1000, 206, "IS_DISTRIBUTION").getDictionaryName());
        if (percentage == null) {
            percentage = BigDecimal.valueOf(0.15);
        }
        if (isDistribution == null) {
            isDistribution = 0;
        }
        if (isDistribution == 0) {
            percentage = BigDecimal.valueOf(0L);
        }
        param.setIsDistribution(isDistribution);
        param.setPercentage(percentage);
        this.insert(param);
    }

    public PageInfo<DistributorItemEntity> getPageList(int pageNum, int pageSize, DistributorItemEntity var1) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize, (String)"ID desc");
        this.distributorItemMapper.getList(var1);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public PageInfo<DistributorItemEntity> getDistributorItemList(int pageNum, int pageSize, DistributorItemEntity entity) {
        if (StringUtil.isEmpty((String)entity.getItemName())) {
            entity.setItemName(null);
        } else {
            entity.setItemName(SqlUtils.sqlLike((String)entity.getItemName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        PageInfo<DistributorItemEntity> pageInfo = this.getPageList(pageNum, pageSize, entity);
        List lst = pageInfo.getList();
        if (lst != null && lst.size() > 0) {
            StringBuilder sb = new StringBuilder();
            List<Object> pics = new ArrayList();
            for (DistributorItemEntity d : lst) {
                sb.setLength(0);
                switch (d.getItemType()) {
                    case 1: {
                        MallPromotionProductEntity pp = this.promotionProductInterface.getPromotionProductEntity(d.getItemId());
                        if (pp == null || (pics = this.picInterface.getProductPicUrl(pp.getPromotionProductId(), ProductPicTypeEnum.PROMO_SAMLL.getValue())) == null || pics.size() <= 0) break;
                        d.setItemImage((String)pics.get(0));
                        break;
                    }
                    case 2: {
                        pics = this.picInterface.getProductPicUrl(d.getItemId(), ProductPicTypeEnum.GRO_SAMLL.getValue());
                        if (pics == null || pics.size() <= 0) break;
                        d.setItemImage((String)pics.get(0));
                        break;
                    }
                    case 4: {
                        pics = this.picInterface.getProductPicUrl(d.getItemId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                        if (pics == null || pics.size() <= 0) break;
                        d.setItemImage((String)pics.get(0));
                        break;
                    }
                    case 5: {
                        pics = this.picInterface.getProductPicUrl(d.getItemId(), ProductPicTypeEnum.ACT_SAMLL.getValue());
                        if (pics == null || pics.size() <= 0) break;
                        d.setItemImage((String)pics.get(0));
                    }
                }
                if (StringUtil.isEmpty((String)d.getItemImage())) {
                    d.setItemImage(this.ossService.getDefaultImage());
                }
                List<DistributorItemDetailEntity> distributorItemDetailEntities = this.distributorItemDetailInterface.getDistributorItemDetail(d.getId());
                for (DistributorItemDetailEntity detail : distributorItemDetailEntities) {
                    if (detail.getId() == null || !Integer.valueOf(1).equals(detail.getIsDistribution())) continue;
                    sb.append(detail.getGroupName());
                    sb.append("\uff1a" + detail.getPercentage());
                    sb.append("</br>");
                }
                if (Integer.valueOf(1).equals(d.getPercentageType())) {
                    d.setRemark(sb.length() == 0 ? "\u672a\u8bbe\u7f6e" : sb.toString());
                    continue;
                }
                d.setRemark(sb.length() == 0 ? d.getPercentage().toString() : sb.toString());
            }
        }
        return pageInfo;
    }
}

