/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.ShareMapper;
import cc.lechun.mall.entity.distribution.ShareEntity;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareService
extends BaseService<ShareEntity, Integer>
implements ShareInterface {
    @Resource
    private ShareMapper shareMapper;
    @Autowired
    private OssService ossService;

    @Override
    public BaseJsonVo saveShare(ShareEntity shareEntity) {
        if (shareEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((String)shareEntity.getPageName())) {
            return BaseJsonVo.error((String)"\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)shareEntity.getPageTitle())) {
            return BaseJsonVo.error((String)"\u9875\u9762\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)shareEntity.getShareTitle())) {
            return BaseJsonVo.error((String)"\u5206\u4eab\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaseJsonVo jsonVo = this.validateRepeat(shareEntity, "pageName", "\u9875\u9762\u540d\u79f0");
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        if (shareEntity.getDefaultConfig() == null) {
            shareEntity.setDefaultConfig(0);
        }
        shareEntity.setShareImageUrl(this.ossService.removeUrlDomain(shareEntity.getShareImageUrl()));
        int i = this.insertOrUpdate(shareEntity);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public PageInfo<ShareEntity> getSharePageList(Integer pageNum, Integer pageSize, ShareEntity param) {
        if (StringUtil.isEmpty((String)param.getPageTitle())) {
            param.setPageTitle(null);
        } else {
            param.setPageTitle(SqlUtils.sqlLike((String)param.getPageTitle(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtil.isEmpty((String)param.getPageName())) {
            param.setPageName(null);
        } else {
            param.setPageName(SqlUtils.sqlLike((String)param.getPageName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtil.isEmpty((String)param.getShareTitle())) {
            param.setShareTitle(null);
        } else {
            param.setShareTitle(SqlUtils.sqlLike((String)param.getShareTitle(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        PageInfo shareEntityPageInfo = this.getPageList(pageNum, pageSize, param);
        for (ShareEntity share : shareEntityPageInfo.getList()) {
            share.setShareImageUrl(this.ossService.getImageResoure(share.getShareImageUrl(), 1));
        }
        if (shareEntityPageInfo.getList() != null && shareEntityPageInfo.getList().size() > 0) {
            shareEntityPageInfo.getList().sort((s1, s2) -> s2.getId() - s1.getId());
        }
        return shareEntityPageInfo;
    }
}

