/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardBatchMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrepayCardBatchService
extends BaseService<PrepayCardBatchEntity, Integer>
implements PrepayCardBatchInterface {
    @Resource
    PrepayCardBatchMapper prepayCardBatchMapper;
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public PageInfo cardBatchesByPage(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.prepayCardBatchMapper.getPageList();
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    @Transactional
    public BaseJsonVo addBatch(PrepayCardBatchEntity batchEntity) {
        if (batchEntity.getBatchId() == null || batchEntity.getBatchId() == 0) {
            int rtn = this.prepayCardBatchMapper.insert(batchEntity);
            System.out.println(rtn);
        } else {
            this.prepayCardBatchMapper.updateByPrimaryKey(batchEntity);
        }
        if (batchEntity.getOrderSource() != 1 && batchEntity.getOrderSource() != null && batchEntity.getOrderSource() > 0) {
            Date createTime = DateUtils.now();
            ArrayList<PrepayCardEntity> list = new ArrayList<PrepayCardEntity>();
            List<String> pwds = this.prepayCardInterface.getPwds();
            pwds.forEach(pwd -> this.redisService.sadd("PREPAY_CARD_KEY", pwd));
            this.redisService.setExpire("PREPAY_CARD_KEY", 2L, TimeUnit.MINUTES);
            for (int i = 0; i < batchEntity.getTotalCount(); ++i) {
                PrepayCardEntity entity = new PrepayCardEntity();
                entity.setCardId(IDGenerate.getUniqueIdStr().toUpperCase());
                entity.setCardPassword(this.getPassword(12));
                entity.setBuyerCustomerId("");
                entity.setBelongCustomerId(entity.getBuyerCustomerId());
                entity.setBatchId(batchEntity.getBatchId());
                entity.setOrderMainNo("");
                entity.setTotalCount(batchEntity.getDeliverCount());
                entity.setRemainCount(entity.getTotalCount());
                entity.setStatus(0);
                entity.setOrderSource(batchEntity.getOrderSource());
                entity.setCreateTime(createTime);
                entity.setRelateCardNo("");
                list.add(entity);
            }
            this.prepayCardInterface.batchInsert(list);
        }
        return BaseJsonVo.success((Object)"");
    }

    private String getPassword(int length) {
        String pwd = RandomUtils.generateUpperStringWithNum((int)length);
        if (this.redisService.sIsMember("PREPAY_CARD_KEY", pwd)) {
            return this.getPassword(length);
        }
        this.redisService.sadd("PREPAY_CARD_KEY", pwd);
        this.redisService.setExpire("PREPAY_CARD_KEY", 2L, TimeUnit.MINUTES);
        return pwd;
    }

    @Override
    public BaseJsonVo delBatch(Integer batchId) {
        return this.prepayCardBatchMapper.deleteByPrimaryKey(batchId) == 0 ? BaseJsonVo.error(null) : BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public Boolean promotionIsUsed(String promotionId) {
        PrepayCardBatchEntity param1 = new PrepayCardBatchEntity();
        param1.setProductPromotionId(promotionId);
        List list1 = this.prepayCardBatchMapper.getList(param1);
        PrepayCardBatchEntity param2 = new PrepayCardBatchEntity();
        param2.setCardPromotionId(promotionId);
        List list2 = this.prepayCardBatchMapper.getList(param2);
        return list1 != null && list1.size() > 0 || list2 != null && list2.size() > 0;
    }
}

