/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallRegularMapper;
import cc.lechun.mall.dao.sales.MallRegularProductMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallRegularEntity;
import cc.lechun.mall.entity.sales.MallRegularProductEntity;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import cc.lechun.mall.service.dictionary.DictionaryService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallRegularService
extends BaseService
implements MallRegularInterface {
    @Autowired
    private MallRegularMapper regularMapper;
    @Autowired
    private MallRegularProductMapper regularProductMapper;
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo findAllProducts(Integer platformGroupId) {
        List<MallRegularProductEntity> ls = this.regularProductMapper.findAllProducts(platformGroupId);
        ArrayList rs = new ArrayList();
        if (ls != null && ls.size() > 0) {
            List<DictionaryEntity> dict_ls = this.dictionaryService.getValidDictionaryList(platformGroupId, 15);
            ls.forEach(mallRegularProductEntity -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("productId", mallRegularProductEntity.getProductId());
                map.put("productName", mallRegularProductEntity.getProductName());
                map.put("regularProductId", mallRegularProductEntity.getRegularProductId());
                map.put("channelType", mallRegularProductEntity.getChannelType());
                if (dict_ls != null && dict_ls.size() > 0) {
                    dict_ls.forEach(dictionaryEntity -> {
                        map.put("s" + dictionaryEntity.getDictionaryKey(), 0);
                        int key = Integer.parseInt(dictionaryEntity.getDictionaryKey());
                        if ((mallRegularProductEntity.getChannelType() & key) == key) {
                            map.put("s" + dictionaryEntity.getDictionaryKey(), dictionaryEntity.getDictionaryKey());
                        }
                    });
                }
                rs.add(map);
            });
        }
        return BaseJsonVo.success(rs);
    }

    @Override
    public BaseJsonVo saveOrUpdateRegularProduct(Integer regularProductId, String productId, String productName, Integer channelType, Integer platformGroupId) {
        if (StringUtil.isEmpty((String)productId)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5546\u54c1");
        }
        if (regularProductId == null || regularProductId == 0) {
            MallRegularProductEntity mallRegularProductEntity = new MallRegularProductEntity();
            mallRegularProductEntity.setProductId(productId);
            mallRegularProductEntity.setProductName(productName);
            mallRegularProductEntity.setChannelType(channelType);
            mallRegularProductEntity.setPlatformGroupId(platformGroupId);
            this.regularProductMapper.insertSelective(mallRegularProductEntity);
        } else {
            MallRegularProductEntity mallRegularProductEntity = (MallRegularProductEntity)this.regularProductMapper.selectByPrimaryKey(regularProductId);
            mallRegularProductEntity.setChannelType(channelType);
            this.regularProductMapper.updateByPrimaryKeySelective(mallRegularProductEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getRegularProductList(int platformGroupId, int channelType) {
        ArrayList productVOs = new ArrayList();
        List<MallRegularProductEntity> regularProducts = this.regularProductMapper.findChannelProducts(platformGroupId, 1);
        if (regularProducts != null && regularProducts.size() > 0) {
            regularProducts.forEach(regularProduct -> {
                BaseJsonVo sr = this.productService.buildProductVO(regularProduct.getProductId(), 1, null, null, null, null, true, true, null, null);
                if (sr.isSuccess()) {
                    productVOs.add((MallProductVO)sr.getValue());
                }
            });
        }
        return BaseJsonVo.success(productVOs);
    }

    @Override
    @ReadThroughSingleCache(namespace="getRegular4GroupDCount", expiration=7200)
    public MallRegularEntity getRegular4GroupDCount(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer deliverCount) {
        MallRegularEntity regular = new MallRegularEntity();
        regular.setPlatformGroupId(platformGroupId);
        regular.setStatus(1);
        regular.setRegularDeliverCount(deliverCount);
        List regulars = this.regularMapper.getList(regular);
        if (regulars != null && regulars.size() > 0) {
            return (MallRegularEntity)regulars.get(0);
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="getRegular4GroupDType", expiration=7200)
    public MallRegularEntity getRegular4GroupDType(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer deliverType) {
        MallRegularEntity regular = new MallRegularEntity();
        regular.setPlatformGroupId(platformGroupId);
        regular.setStatus(1);
        regular.setRegularType(deliverType);
        List regulars = this.regularMapper.getList(regular);
        if (regulars != null && regulars.size() > 0) {
            return (MallRegularEntity)regulars.get(0);
        }
        return null;
    }

    @Override
    public BaseJsonVo saveOrUpdateRegular(MallRegularEntity mallRegularEntity) {
        BaseJsonVo rs = this.valid(mallRegularEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        if (StringUtil.isEmpty((String)mallRegularEntity.getRegularId())) {
            mallRegularEntity.setRegularId(IDGenerate.getUniqueID() + "");
            mallRegularEntity.setCreateTime(DateUtils.now());
            this.regularMapper.insertSelective(mallRegularEntity);
        } else {
            MallRegularEntity oldMallRegularEntity = (MallRegularEntity)this.regularMapper.selectByPrimaryKey((Serializable)((Object)mallRegularEntity.getRegularId()));
            this.removeCache(oldMallRegularEntity.getPlatformGroupId(), oldMallRegularEntity.getRegularType(), oldMallRegularEntity.getRegularDeliverCount());
            this.regularMapper.updateByPrimaryKeySelective(mallRegularEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getRegularList(int pageNum, int pageSize, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.regularMapper.getRegularList(platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private BaseJsonVo valid(MallRegularEntity mallRegularEntity) {
        if (StringUtil.isEmpty((String)mallRegularEntity.getRegularName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallRegularEntity.getRegularType() == null || mallRegularEntity.getRegularType() == 0) {
            return BaseJsonVo.paramError((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(Integer platformGroupId, Integer deliverType, Integer deliverCount) {
        this.memcachedService.delete("getRegular4GroupDCount", new String[]{platformGroupId + "", deliverCount + ""});
        this.memcachedService.delete("getRegular4GroupDType", new String[]{platformGroupId + "", deliverType + ""});
    }
}

