/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.shoppingcart.MallShoppingRuleMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingRuleEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingRuleListVo;
import cc.lechun.mall.entity.shoppingcart.MallShoppingRuleVo;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingRuleInterface;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallShoppingRuleService
extends BaseService
implements MallShoppingRuleInterface {
    @Autowired
    private MallShoppingRuleMapper shoppingRuleMapper;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    private MallShoppingRuleEntity getShoppingRuleEntity(int platformId, int orderSource) {
        MallShoppingRuleEntity entity = this.getShoppingRuleEntity0(platformId, orderSource);
        if (entity == null && (entity = this.getShoppingRuleEntity0(platformId, -1)) == null) {
            entity = this.getShoppingRuleEntity0(0, -1);
        }
        return entity;
    }

    private MallShoppingRuleEntity getShoppingRuleEntity0(int platformId, int orderSource) {
        MallShoppingRuleEntity entity = new MallShoppingRuleEntity();
        entity.setPlatformId(platformId);
        entity.setOrderSource(orderSource);
        return (MallShoppingRuleEntity)this.shoppingRuleMapper.getSingle(entity);
    }

    @Override
    public MallShoppingRuleVo getShoppingRule(int selfMadeType, int platformId, int orderSource, BigDecimal amount, int quantity) {
        DictionaryEntity dictionaryEntity;
        int platFormGroupId;
        String selfMadeTypeStr = selfMadeType == 1 ? "\u81ea\u8425\u5546\u54c1" : "\u51b7\u94fe\u5546\u54c1";
        MallShoppingRuleVo ruleVo = new MallShoppingRuleVo();
        MallShoppingRuleEntity entity = this.getShoppingRuleEntity(platformId, orderSource);
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(platformId);
        int n = platFormGroupId = platFormEntity != null ? platFormEntity.getPlatformGroupId() : 0;
        if (entity == null) {
            ruleVo.setBaseError(selfMadeTypeStr + "\u6ca1\u6709\u8bbe\u7f6e\u8d2d\u4e70\u89c4\u5219(shoppingRule)");
            return ruleVo;
        }
        ruleVo.setBeginAmount(entity.getBeginSalePrice());
        ruleVo.setBeginCount(entity.getBeginSaleCount());
        ruleVo.setDiffRule(entity.getSaleRule());
        ruleVo.setSaleTimes(entity.getSaleTimes());
        if (entity.getSaleRule() == 1) {
            int diffCount;
            if (entity.getSaleTimes() == 1) {
                diffCount = quantity % entity.getBeginSaleCount();
                if (diffCount > 0) {
                    diffCount = entity.getBeginSaleCount() - diffCount;
                }
            } else {
                diffCount = entity.getBeginSaleCount() - quantity > 0 ? entity.getBeginSaleCount() - quantity : 0;
            }
            ruleVo.setDiffCount(diffCount);
            if (diffCount > 0) {
                dictionaryEntity = this.dictionaryInterface.getDictionary(platFormGroupId, 18, "3");
                if (dictionaryEntity != null) {
                    ruleVo.setBaseError(MessageFormat.format(selfMadeTypeStr + dictionaryEntity.getDictionaryName(), diffCount));
                } else {
                    ruleVo.setBaseError(MessageFormat.format(selfMadeTypeStr + "\u8fd8\u5dee{0}\u76d2", diffCount));
                }
            }
        }
        if (entity.getSaleRule() == 2) {
            BigDecimal diffAmount = PriceUtils.subtract((BigDecimal)entity.getBeginSalePrice(), (BigDecimal)amount);
            if (diffAmount.doubleValue() < 0.0) {
                diffAmount = new BigDecimal(0);
            }
            ruleVo.setDiffAmount(diffAmount);
            if (diffAmount.doubleValue() > 0.0) {
                dictionaryEntity = this.dictionaryInterface.getDictionary(platFormGroupId, 18, "2");
                if (dictionaryEntity != null) {
                    ruleVo.setBaseError(MessageFormat.format(selfMadeTypeStr + dictionaryEntity.getDictionaryName(), diffAmount));
                } else {
                    ruleVo.setBaseError(MessageFormat.format(selfMadeTypeStr + "\u8fd8\u5dee{0}\u5143\u8d77\u9001", diffAmount));
                }
            }
        }
        this.logger.error("getShoppingRule\u7684\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)ruleVo));
        return ruleVo;
    }

    @Override
    public MallShoppingRuleVo getShoppingRule(int platformId, BigDecimal amount, int quantity) {
        return this.getShoppingRule(1, platformId, 0, amount, quantity);
    }

    @Override
    public MallShoppingRuleVo getShoppingRule(MallShoppingcartVO shoppingcartVO) {
        MallShoppingRuleVo ruleVo = new MallShoppingRuleVo();
        Boolean[] hasGroup = new Boolean[]{false};
        if (shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
            shoppingcartVO.getGroups().forEach(group -> {
                if (group.getValid().booleanValue() && group.getShoppingcartCheck().booleanValue()) {
                    hasGroup[0] = true;
                }
            });
        }
        if (shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
            shoppingcartVO.getPromotions().forEach(promotion -> {
                if (promotion.getValid().booleanValue() && promotion.getShoppingcartCheck().booleanValue() && promotion.getGroup() != null) {
                    hasGroup[0] = true;
                }
            });
        }
        if (hasGroup[0].booleanValue()) {
            ruleVo.setBeginAmount(new BigDecimal(0));
            ruleVo.setBeginCount(0);
            ruleVo.setDiffAmount(new BigDecimal(0));
            ruleVo.setDiffCount(0);
            ruleVo.setDiffRule(2);
            ruleVo.setSaleTimes(0);
            return ruleVo;
        }
        int quantity = shoppingcartVO.getProductsPool().stream().mapToInt(c -> c.getCount()).sum();
        BigDecimal price = shoppingcartVO.getPrice();
        if (shoppingcartVO.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            price = shoppingcartVO.getPrice();
        }
        if (price.compareTo(new BigDecimal(0)) == 0) {
            return new MallShoppingRuleVo();
        }
        return this.getShoppingRule(shoppingcartVO.getSelfMadeType(), shoppingcartVO.getPlatFormId(), shoppingcartVO.getOrderSource(), price, quantity);
    }

    @Override
    public MallShoppingRuleEntity select(Integer shoppingRuleId) {
        return (MallShoppingRuleEntity)this.shoppingRuleMapper.selectByPrimaryKey(shoppingRuleId);
    }

    @Override
    public List<MallShoppingRuleListVo> list(MallShoppingRuleEntity entity) {
        return this.shoppingRuleMapper.getShoppingRuleList(entity);
    }

    @Override
    public BaseJsonVo delete(Integer shoppingRuleId) {
        int i = this.shoppingRuleMapper.deleteByPrimaryKey(shoppingRuleId);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo save(MallShoppingRuleEntity ruleEntity) {
        int i = ruleEntity.getShoppingRuleId() == null || ruleEntity.getShoppingRuleId() == 0 ? this.shoppingRuleMapper.insertSelective(ruleEntity) : this.shoppingRuleMapper.updateByPrimaryKeySelective(ruleEntity);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

