/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.cache;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallRefundDetailMapper;
import cc.lechun.mall.entity.trade.MallRefundDetailEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.iservice.trade.MallRefundDetailInterface;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MallRefundDetailService
extends BaseService
implements MallRefundDetailInterface {
    @Resource
    private MallRefundDetailMapper detailMapper;

    @Override
    public void createRefundDetail(MallRefundEntity refundEntity) throws Exception {
        MallRefundDetailEntity refundDetailEntity = new MallRefundDetailEntity();
        refundDetailEntity.setRefundDetailId(IDGenerate.getUniqueIdStr());
        refundDetailEntity.setRefundId(refundEntity.getRefundId());
        refundDetailEntity.setOrderMainNo(refundEntity.getOrderMainNo());
        refundDetailEntity.setOrderNo(refundEntity.getOrderNo());
        refundDetailEntity.setCustomerId(refundEntity.getCustomerId());
        refundDetailEntity.setCreateTime(refundEntity.getCreateTime());
        refundDetailEntity.setOperaterId(refundEntity.getOperaterId());
        refundDetailEntity.setStatus(refundEntity.getStatus());
        refundDetailEntity.setReason(refundEntity.getReason());
        if (this.detailMapper.insert(refundDetailEntity) <= 0) {
            throw new Exception("\u65e0\u6cd5\u521b\u5efa\u9000\u6b3e\u5b50\u5355");
        }
    }

    @Override
    public void PassOrderRefund(String refundId, BigDecimal factRefundAmount) {
        MallRefundDetailEntity mallRefundDetailEntity = new MallRefundDetailEntity();
        mallRefundDetailEntity.setRefundId(refundId);
        List list = this.detailMapper.getList(mallRefundDetailEntity);
        list.forEach(mallRefundDetail -> {
            mallRefundDetail.setStatus(2);
            this.detailMapper.updateByPrimaryKey(mallRefundDetail);
        });
    }

    @Override
    public void FailOrderRefund(String refundId) {
        MallRefundDetailEntity mallRefundDetailEntity = new MallRefundDetailEntity();
        mallRefundDetailEntity.setRefundId(refundId);
        List list = this.detailMapper.getList(mallRefundDetailEntity);
        list.forEach(mallRefundDetail -> {
            mallRefundDetail.setStatus(4);
            this.detailMapper.updateByPrimaryKey(mallRefundDetail);
        });
    }

    @Override
    public void CancelOrderRefund(String refundId) {
        MallRefundDetailEntity mallRefundDetailEntity = new MallRefundDetailEntity();
        mallRefundDetailEntity.setRefundId(refundId);
        List list = this.detailMapper.getList(mallRefundDetailEntity);
        list.forEach(mallRefundDetail -> {
            mallRefundDetail.setStatus(5);
            this.detailMapper.updateByPrimaryKey(mallRefundDetail);
        });
    }

    @Override
    public void SuccessOrderRefund(String refundId) {
        MallRefundDetailEntity mallRefundDetailEntity = new MallRefundDetailEntity();
        mallRefundDetailEntity.setRefundId(refundId);
        List list = this.detailMapper.getList(mallRefundDetailEntity);
        list.forEach(mallRefundDetail -> {
            mallRefundDetail.setStatus(3);
            this.detailMapper.updateByPrimaryKey(mallRefundDetail);
        });
    }
}

