/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.dao.OrgKpiScoreRelMapper;
import cc.lechun.organization.dao.OrgTypeNumMapper;
import cc.lechun.organization.entity.OrgKpiScoreRelEntity;
import cc.lechun.organization.entity.OrgTypeNumEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.OrgKpiScoreRelInterface;
import com.alibaba.fastjson.JSON;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgKpiScoreRelService
extends BaseService<OrgKpiScoreRelEntity, Integer>
implements OrgKpiScoreRelInterface {
    @Resource
    private OrgKpiScoreRelMapper orgKpiScoreRelMapper;
    @Autowired
    private OrgTypeNumMapper orgTypeNumMapper;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private SysUserInterface sysUserInterface;

    @Override
    public BaseJsonVo getKpiScoreRelByType(Integer type, Integer kpiScore, String userId, String startYearMonth, String endYearMonth) throws ParseException {
        Boolean flag = true;
        List<DictionaryEntity> validDictionaryList = this.dictionaryInterface.getValidDictionaryList(1000, 207);
        this.logger.info("==============getKpiScoreRelByType========validDictionaryList={}", (Object)JSON.toJSONString(validDictionaryList));
        if (validDictionaryList != null && validDictionaryList.size() > 0) {
            List<OrgKpiScoreRelEntity> orgKpiScoreRelEntityList = this.orgKpiScoreRelMapper.getKpiScoreRelByType(type, kpiScore);
            this.logger.info("==========getKpiScoreRelByType========orgKpiScoreRelEntityList={}", (Object)JSON.toJSONString(orgKpiScoreRelEntityList));
            if (orgKpiScoreRelEntityList != null && orgKpiScoreRelEntityList.size() > 0) {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                Date periodStart = sd.parse(startYearMonth + "-01");
                Date periodEnd = sd.parse(endYearMonth + "-31");
                List<PeriodEntity> periodEntities = this.periodService.getPeriodInfoByDate(2, periodStart, periodEnd);
                MallUserEntity mallUserEntity = this.sysUserInterface.getSysUser4name(userId);
                this.logger.info("==========getKpiScoreRelByType========periodEntities={}", (Object)JSON.toJSONString(periodEntities));
                for (OrgKpiScoreRelEntity orgKpiScoreRelEntity : orgKpiScoreRelEntityList) {
                    int kpiNum = orgKpiScoreRelEntity.getKpiNum();
                    String kpiNumStr = String.valueOf(kpiNum);
                    if (periodEntities.get(0).getHeadPeriod() == 1 && periodEntities.get(0).getHeadYear() == 2020) {
                        DecimalFormat df = new DecimalFormat("0.00");
                        kpiNumStr = df.format((float)kpiNum / 2.0f);
                    }
                    OrgTypeNumEntity orgTypeNumEntity = this.orgTypeNumMapper.getTypeNumByParam(mallUserEntity.getUserId(), orgKpiScoreRelEntity.getOrgType(), kpiNumStr, periodEntities.get(0).getHeadPeriod(), periodEntities.get(0).getHeadYear());
                    this.logger.info("===================getKpiScoreRelByType =====orgTypeNumEntity={},type={},kpiScore={}", new Object[]{JSON.toJSONString((Object)orgTypeNumEntity), type, kpiScore});
                    if (orgTypeNumEntity != null) continue;
                    flag = false;
                    return BaseJsonVo.success((Object)flag);
                }
            }
        }
        return BaseJsonVo.success((Object)flag);
    }
}

