/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.config;

import cc.lechun.cms.Repository.shiro.MyFormAuthenticationFilter;
import cc.lechun.cms.Repository.shiro.MyRolesAuthorizationFilter;
import cc.lechun.cms.Repository.shiro.MyShiroRealm;
import cc.lechun.cms.Repository.sys.ResourceRepository;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfiguration {
    @Autowired
    private ResourceRepository resourceRepository;

    @Bean(name={"shiroFilter"})
    public ShiroFilterFactoryBean getShiroFilterFactoryBean() {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setLoginUrl("/comm/login");
        LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();
        filters.put("roles", new MyRolesAuthorizationFilter());
        filters.put("authc", new MyFormAuthenticationFilter());
        shiroFilterFactoryBean.setFilters(filters);
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)this.getDefaultWebSecurityManager());
        shiroFilterFactoryBean.setFilterChainDefinitionMap(this.getFilterChainDefinitionMap());
        return shiroFilterFactoryBean;
    }

    public Map<String, String> getFilterChainDefinitionMap() {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/comm/login", "anon");
        filterChainDefinitionMap.put("/comm/logout", "anon");
        List ls = this.resourceRepository.getRoleResource();
        ls.forEach(mallRoleResouceVo -> {});
        filterChainDefinitionMap.put("/**", "anon");
        return filterChainDefinitionMap;
    }

    @Bean(name={"securityManager"})
    public DefaultWebSecurityManager getDefaultWebSecurityManager() {
        DefaultWebSecurityManager dwsm = new DefaultWebSecurityManager();
        dwsm.setRealm((Realm)this.myShiroRealm());
        dwsm.setRememberMeManager((RememberMeManager)this.rememberMeManager());
        return dwsm;
    }

    @Bean(name={"myShiroRealm"})
    public MyShiroRealm myShiroRealm() {
        MyShiroRealm realm = new MyShiroRealm();
        realm.setCredentialsMatcher((CredentialsMatcher)this.hashedCredentialsMatcher());
        return realm;
    }

    @Bean
    public CookieRememberMeManager rememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie((Cookie)this.rememberMeCookie());
        cookieRememberMeManager.setCipherKey(Base64.decode((String)"4AvVhJkmnY0FSA3SDFAdag=="));
        return cookieRememberMeManager;
    }

    @Bean
    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie("rememberMe");
        simpleCookie.setMaxAge(259200);
        simpleCookie.setName("LECHUNCMS");
        return simpleCookie;
    }

    @Bean
    public HashedCredentialsMatcher hashedCredentialsMatcher() {
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher();
        hashedCredentialsMatcher.setHashAlgorithmName("md5");
        hashedCredentialsMatcher.setHashIterations(1);
        return hashedCredentialsMatcher;
    }
}

