/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.crowd;

import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/crowdManage"})
public class CrowdController
extends BaseController {
    @Autowired
    private CrowdInterface crowdInterface;

    @RequestMapping(value={"getCrowdProductList"})
    public BaseJsonVo getCrowdProductList(PageForm pageForm) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdProductList(pageForm));
    }

    @RequestMapping(value={"saveCrowdProductConfig"})
    public BaseJsonVo saveCrowdProductConfig(CrowdFundingEntity crowdFundingEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.crowdInterface.saveCrowProduct(crowdFundingEntity));
    }

    @RequestMapping(value={"getCrowdProductCouponList"})
    public BaseJsonVo getCrowdProductCouponList(String proId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("selectCouponList", this.crowdInterface.getSelectCrowdProductCouponList(proId).getValue());
        resultMap.put("allCouponList", this.crowdInterface.getAllCrowdProductCouponList().getValue());
        return BaseJsonVo.success(resultMap);
    }

    @RequestMapping(value={"saveCrowdCouponConfig"})
    public BaseJsonVo saveCrowdCouponConfig(String proId, String activeNo, String list) throws AuthorizeException, UnsupportedEncodingException {
        MallUserEntity user = this.getUser();
        return this.crowdInterface.saveCrowdCouponConfig(proId, activeNo, list);
    }

    @RequestMapping(value={"sendMessage"})
    public BaseJsonVo sendMessage(String proId, String activeNo, String list) throws AuthorizeException, UnsupportedEncodingException {
        MallUserEntity user = this.getUser();
        return this.crowdInterface.saveCrowdCouponConfig(proId, activeNo, list);
    }

    @RequestMapping(value={"getCrowdOrderList"})
    public BaseJsonVo getCrowdOrderList(Integer orderClass, String date) throws AuthorizeException, UnsupportedEncodingException {
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdOrderList(orderClass, "", "", date));
    }

    @RequestMapping(value={"deleteCrowdCoupon"})
    public BaseJsonVo deleteCrowdCoupon(String proId) throws AuthorizeException, UnsupportedEncodingException {
        return this.crowdInterface.deleteCrowdCoupon(proId);
    }
}

