/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.cache;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system"})
public class SystemController
extends BaseController {
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private RedisService redisService;
    private static final String memcache = "1";
    private static final String redis = "2";

    @RequestMapping(value={"/getCache"})
    @ResponseBody
    public BaseJsonVo getCache(String type, String name, String value) {
        if (StringUtils.isEmpty((String)name)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7f13\u5b58\u540d\u79f0");
        }
        if (type.equals(memcache)) {
            return BaseJsonVo.success((Object)JSON.toJSONString((Object)this.memcachedService.get(name)));
        }
        if (type.equals(redis)) {
            return BaseJsonVo.success((Object)JSON.toJSONString((Object)this.redisService.get(name)));
        }
        return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7c7b\u578b");
    }

    @RequestMapping(value={"/updateCache"})
    @ResponseBody
    public BaseJsonVo updateCache(String type, String name, String value) {
        if (StringUtils.isEmpty((String)name)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7f13\u5b58\u540d\u79f0");
        }
        boolean flag = false;
        if (type.equals(memcache)) {
            flag = this.memcachedService.set(name, (Object)value);
        } else if (type.equals(redis)) {
            flag = this.redisService.save(name, (Object)value);
        }
        if (flag) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.paramError((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @RequestMapping(value={"/deleteCache"})
    @ResponseBody
    public BaseJsonVo deleteCache(String type, String name, String value) {
        if (StringUtils.isEmpty((String)name)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7f13\u5b58\u540d\u79f0");
        }
        boolean flag = false;
        if (type.equals(memcache)) {
            flag = this.memcachedService.delete(name);
        } else if (type.equals(redis)) {
            flag = this.redisService.delete(name);
        }
        if (flag) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.paramError((String)"\u5220\u9664\u5931\u8d25");
    }
}

