/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.dictionary;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.dictionary.DictionaryTypeEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryTypeInterface;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dictionary"})
public class DictionaryController
extends BaseController {
    @Autowired
    private DictionaryTypeInterface dictionaryTypeInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @RequestMapping(value={"/getDictionaryTypeList"})
    @ResponseBody
    public List<DictionaryTypeEntity> getDictionaryTypeList() {
        List ls = this.dictionaryTypeInterface.getDictionaryTypeList();
        ls.forEach(dictionaryTypeEntity -> dictionaryTypeEntity.setTypeName(dictionaryTypeEntity.getDictionaryTypeId() + ":" + dictionaryTypeEntity.getTypeName()));
        return ls;
    }

    @RequestMapping(value={"/saveDictionaryType"})
    @ResponseBody
    public BaseJsonVo saveDictionaryType(String typeName, String remark, int dictionaryTypeId) {
        if (StringUtils.isEmpty((String)typeName)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u7c7b\u578b\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)remark)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u7c7b\u578b\u5907\u6ce8");
        }
        return BaseJsonVo.success((Object)this.dictionaryTypeInterface.saveDictionaryType(dictionaryTypeId, typeName, remark));
    }

    @RequestMapping(value={"/getvaliddictionarylist"})
    @ResponseBody
    public List<DictionaryEntity> getValidDictionaryList(Integer platformGroupId, Integer dictionaryTypeId) {
        return this.dictionaryInterface.getValidDictionaryList(platformGroupId, dictionaryTypeId);
    }

    @RequestMapping(value={"/getValidDictionaryList"})
    @ResponseBody
    public BaseJsonVo getDictionaryList(PageForm pageForm, Integer dictionaryTypeId) throws AuthorizeException {
        if (dictionaryTypeId == null || dictionaryTypeId == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7ec4\u7c7b\u578b");
        }
        MallUserEntity user = this.getUser();
        PageInfo pageInfo = this.dictionaryInterface.getDictionaryList(pageForm.getCurrentPage(), pageForm.getPageSize(), user.getPlatformGroupId().intValue(), dictionaryTypeId.intValue());
        pageInfo.getList().forEach(dictionaryEntityVo -> dictionaryEntityVo.setPlatformGroupName(this.getUserValidPlatFormGroupName(dictionaryEntityVo.getPlatformGroupId())));
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/updateOrSaveDictionary"})
    @ResponseBody
    public BaseJsonVo saveDictionary(Integer dictionaryId, Integer dictionaryTypeId, String dictionaryKey, String dictionaryName, Integer sort, String remark) throws AuthorizeException {
        if (dictionaryTypeId == null || dictionaryTypeId == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7ec4");
        }
        if (StringUtils.isEmpty((String)dictionaryKey)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165key");
        }
        if (StringUtils.isEmpty((String)dictionaryName)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u540d\u79f0");
        }
        if (sort == null || sort == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u6392\u5e8f");
        }
        if (dictionaryId == null || dictionaryId == 0) {
            MallUserEntity user = this.getUser();
            this.dictionaryInterface.saveDictionary(user.getPlatformGroupId().intValue(), dictionaryTypeId.intValue(), dictionaryKey, dictionaryName, sort.intValue(), remark);
        } else {
            this.dictionaryInterface.updateDictionary(dictionaryId.intValue(), dictionaryKey, dictionaryName, sort.intValue(), remark);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/deleteDictionary"})
    @ResponseBody
    public BaseJsonVo deleteDictionary(Integer dictionaryId) throws AuthorizeException {
        if (dictionaryId == null || dictionaryId == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u914d\u7f6e");
        }
        MallUserEntity user = this.getUser();
        return this.dictionaryInterface.deleteDictionary(dictionaryId.intValue(), user.getPlatformGroupId().intValue());
    }
}

