/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.organization;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperBonusDetailExcelVo;
import cc.lechun.organization.entity.PaperBonusExcelVo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperSearchVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPaperReportBounsService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.utils.ExcelUtil;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"organization"})
public class PaperController
extends BaseController {
    @Autowired
    private IOrgPaperService paperService;
    @Autowired
    private IOrgPaperAnswerService paperAnswerService;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private IOrgPaperDomain paperDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    @Autowired
    private IOrgQuestionDomain questionDomain;
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    private IOrgQuestionClassDomain iOrgQuestionClassDomain;
    @Autowired
    private MallUserInterface userInterface;
    @Autowired
    private IPaperReportBounsService paperReportBounsService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/getPaperPageList"})
    public BaseJsonVo getPaperPageList(PageForm pageForm, PaperSearchVo paper) throws AuthorizeException {
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        if (paper == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        if (paper.getYear() == null || paper.getPeriod() == null) {
            BaseJsonVo baseJsonVo = this.periodService.currentPeriod(periodType);
            if (baseJsonVo.getValue() == null) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
        } else {
            BaseJsonVo inPeriodWithNum = this.periodService.getPeriodWithNum(paper.getYear(), paper.getPeriod().intValue(), periodType);
            if (!inPeriodWithNum.isSuccess()) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)inPeriodWithNum.getValue()).getId());
        }
        if (paper.getClassId() == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        paperEntity.setQuestionClassId(paper.getClassId());
        if (paper.getOnlyme() != null && paper.getOnlyme() == 1) {
            paperEntity.setUserId(userEntity.getUserId());
            return this.paperService.getPaperPageList(pageForm, paperEntity, userEntity.getUserId());
        } else {
            if (!StringUtils.isNotEmpty((String)paper.getUserId())) return this.paperService.getPaperPageList(pageForm, paperEntity, userEntity.getUserId());
            paperEntity.setUserId(paper.getUserId());
        }
        return this.paperService.getPaperPageList(pageForm, paperEntity, userEntity.getUserId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/getPublicPapers"})
    public BaseJsonVo getPublicPapers(PageForm pageForm, PaperSearchVo paper) throws AuthorizeException {
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        if (paper == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        if (paper.getYear() == null || paper.getPeriod() == null) {
            BaseJsonVo baseJsonVo = this.periodService.currentPeriod(periodType);
            if (baseJsonVo.getValue() == null) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
        } else {
            BaseJsonVo inPeriodWithNum = this.periodService.getPeriodWithNum(paper.getYear(), paper.getPeriod().intValue(), periodType);
            if (!inPeriodWithNum.isSuccess()) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)inPeriodWithNum.getValue()).getId());
        }
        if (paper.getClassId() == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        paperEntity.setQuestionClassId(paper.getClassId());
        if (paper.getOnlyme() != null && paper.getOnlyme() == 1) {
            paperEntity.setUserId(userEntity.getUserId());
            return this.paperService.getPublicPapers(pageForm, paperEntity, userEntity.getUserId());
        } else {
            if (!StringUtils.isNotEmpty((String)paper.getUserId())) return this.paperService.getPublicPapers(pageForm, paperEntity, userEntity.getUserId());
            paperEntity.setUserId(paper.getUserId());
        }
        return this.paperService.getPublicPapers(pageForm, paperEntity, userEntity.getUserId());
    }

    @RequestMapping(value={"/getPaperAnswerList"})
    public BaseJsonVo getPaperAnswerList(Integer classId, String paperId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getPaperAnswerList(classId, paperId, userEntity.getUserId());
    }

    @RequestMapping(value={"/savePaperAnswer"})
    public BaseJsonVo savePaperAnswer(@RequestParam(value="answerEntityList") String answerEntityList) throws AuthorizeException {
        BaseJsonVo baseJson;
        List answerEntityList1 = JsonUtils.getListByArray(PaperAnswerEntity.class, (String)answerEntityList);
        MallUserEntity userEntity = this.getUser();
        if (answerEntityList == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        ArrayList subAnswerEntityList = new ArrayList();
        PaperAnswerEntity paperAnswerEntity = (PaperAnswerEntity)answerEntityList1.get(0);
        this.log.info(">>>>>>>savePaperAnswer paperAnswerEntity >>>>>>>paperAnswerEntity={}", (Object)JSON.toJSONString((Object)paperAnswerEntity));
        String paperId = paperAnswerEntity.getPaperId();
        String userId = userEntity.getUserId();
        if (StringUtils.isNotEmpty((String)paperId)) {
            PaperAnswerEntity search = new PaperAnswerEntity();
            search.setPaperId(paperId);
            List answerEntities = this.orgPaperAnswerDomain.getList(search);
            if (answerEntities != null && answerEntities.size() > 0) {
                userId = ((PaperAnswerEntity)answerEntities.get(0)).getUserId();
            }
        }
        for (PaperAnswerEntity answerEntity : answerEntityList1) {
            answerEntity.setCreateTime(new Date());
            answerEntity.setUserId(userId);
            String answerStr = answerEntity.getAnswer().replace("\u3010\u5f02\u8bae\u3011", "");
            answerEntity.setAnswer(answerStr);
            if (answerEntity.getAnswer() == null) {
                answerEntity.setAnswer("");
            }
            if (answerEntity.getAnswer().length() > 20000) {
                return BaseJsonVo.error((String)"\u56de\u7b54\u6587\u5b57\u4e0d\u80fd\u5927\u4e8e20000\u5b57");
            }
            if (answerEntity.getQuestionId() == null) {
                return BaseJsonVo.error((String)"\u95ee\u9898\u4e3a\u7a7a");
            }
            if (answerEntity.getPaperId() == null) {
                return BaseJsonVo.error((String)"\u671f\u6b21\u4e3a\u7a7a");
            }
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            if (answerEntity.getAnswer() == null || questionEntity == null || questionEntity.getQuestionType() != 10) continue;
            try {
                List l = JsonUtils.getListByArray(PaperAnswerEntity.class, (String)answerEntity.getAnswer());
                if (l == null || l.size() <= 0) continue;
                subAnswerEntityList.addAll(l);
            }
            catch (Exception exception) {}
        }
        if (subAnswerEntityList.size() > 0) {
            answerEntityList1.addAll(subAnswerEntityList);
        }
        try {
            this.log.info("=====answerEntityList1={}", (Object)JSON.toJSONString((Object)answerEntityList1));
            baseJson = this.paperAnswerService.savePaperAnswer(answerEntityList1, userId);
        }
        catch (RuntimeException e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return baseJson;
    }

    @RequestMapping(value={"/setWeekAfterWeekFinishStatus"})
    public BaseJsonVo setWeekAfterWeek(Integer id, Integer finished) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperService.setWeekAfterWeek(id, userEntity.getUserId(), finished);
    }

    @RequestMapping(value={"/savePaperAnswertest"})
    public BaseJsonVo savePaperAnswertest() throws AuthorizeException {
        BaseJsonVo baseJson;
        MallUserEntity userEntity = this.getUser();
        ArrayList<PaperAnswerEntity> answerEntityList = new ArrayList<PaperAnswerEntity>();
        for (int i = 1; i < 30; ++i) {
            PaperAnswerEntity answerEntity = new PaperAnswerEntity();
            answerEntity.setPaperId("1186938331029835776");
            answerEntity.setQuestionId(Integer.valueOf(i));
            answerEntity.setAnswer("20ewruodafdagragdsgdgsfdg");
            answerEntityList.add(answerEntity);
        }
        if (answerEntityList == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        for (PaperAnswerEntity answerEntity : answerEntityList) {
            answerEntity.setCreateTime(new Date());
            answerEntity.setUserId(userEntity.getUserId());
            if (answerEntity.getAnswer().length() > 5000) {
                return BaseJsonVo.error((String)"\u56de\u7b54\u6587\u5b57\u4e0d\u80fd\u5927\u4e8e5000\u5b57");
            }
            if (answerEntity.getQuestionId() == null) {
                return BaseJsonVo.error((String)"\u95ee\u9898\u4e3a\u7a7a");
            }
            if (answerEntity.getPaperId() != null) continue;
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e3a\u7a7a");
        }
        try {
            baseJson = this.paperAnswerService.savePaperAnswer(answerEntityList, null);
        }
        catch (RuntimeException e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return baseJson;
    }

    @RequestMapping(value={"/relationMe"})
    public BaseJsonVo relationMe(PageForm pageForm, String classId, Integer ctype, Integer isself) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        return this.paperAnswerService.relationMe(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), userEntity.getUserId(), classId, ctype, isself);
    }

    @RequestMapping(value={"/lookPaperAnswer"})
    public BaseJsonVo lookPaperAnswer(PageForm pageForm, Integer year, Integer period, Integer classId, Integer questionId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        return this.paperAnswerService.lookPaperAnswer(pageForm, year, period, classId, userEntity.getUserId(), questionId);
    }

    @RequestMapping(value={"/buidPaper"})
    public BaseJsonVo buildPaper(Integer periodId) {
        if (periodId == null) {
            return this.paperService.buildPaper();
        }
        return this.paperService.buildPaper(periodId);
    }

    @RequestMapping(value={"/buidRelation"})
    public BaseJsonVo buildRelation() throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        List paperEntities = this.paperDomain.getList(new PaperEntity());
        for (PaperEntity p : paperEntities) {
            this.paperAnswerService.savePaperAnswerRelation(p.getId(), userEntity.getUserId());
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getPeriod"})
    public BaseJsonVo getPeriod(String date, Integer type) {
        if (date == null) {
            date = DateUtils.date();
        }
        if (type == null) {
            type = 0;
        }
        Date d = DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd");
        return this.periodService.getPeriod(d, type);
    }

    @RequestMapping(value={"/saveAnswer"})
    public BaseJsonVo saveAnswer(Integer relationId, String content, String content1) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.relationService.saveAnswer(userEntity.getUserId(), relationId, content, content1);
    }

    @RequestMapping(value={"/setReportStatus"})
    public BaseJsonVo setReportStatus(Integer period) {
        if (period == null) {
            return this.paperReportBounsService.setReportStatus();
        }
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(1));
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(2));
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/setReportStatusByUserName"})
    public BaseJsonVo setReportStatus(Integer period, String userName) {
        if (period == null) {
            return this.paperReportBounsService.setReportStatus();
        }
        if (StringUtils.isEmpty((String)userName)) {
            return BaseJsonVo.error((String)"userName \u4e3a\u7a7a");
        }
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(1), userName);
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(2), userName);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getBonusesList"})
    public BaseJsonVo getBonusesList(Integer year, Integer month) {
        Calendar c1 = Calendar.getInstance();
        if (year == null) {
            Date start = c1.getTime();
            c1.add(2, -1);
            Date date = c1.getTime();
            c1.getWeekYear();
        }
        if (month == null) {
            return BaseJsonVo.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.paperReportBounsService.getBonusesList(null, year, month, null));
    }

    @RequestMapping(value={"/getBonusesDate"})
    public BaseJsonVo getBonusesDate(Integer year, Integer month) {
        return BaseJsonVo.success((Object)DateUtils.formatDate((Date)this.paperReportBounsService.getBonusesDate(year, month), (String)"yyyy-MM-dd"));
    }

    @GetMapping(value={"/downloadBonuses"})
    public void downloadBonuses(Integer year, Integer month, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(year + "\u5e74" + month + "\u6708\u5956\u91d1", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            List list = this.paperReportBounsService.getBonusesList(null, year, month, null);
            ArrayList result = new ArrayList();
            ArrayList detailVos = new ArrayList();
            if (list.size() > 0) {
                list.forEach(p -> {
                    PaperBonusExcelVo paperBonusExcelVo = new PaperBonusExcelVo();
                    BeanUtils.copyProperties((Object)p, (Object)paperBonusExcelVo);
                    result.add(paperBonusExcelVo);
                    detailVos.addAll(this.paperReportBounsService.getPaperBonusDetailExcelList(p.getUserId(), year, month, Integer.valueOf(1), Integer.valueOf(3)));
                    detailVos.addAll(this.paperReportBounsService.getPaperBonusDetailExcelList(p.getUserId(), year, month, Integer.valueOf(2), Integer.valueOf(3)));
                });
            }
            ExcelWriter writer = new ExcelWriter((OutputStream)response.getOutputStream(), ExcelTypeEnum.XLSX);
            Sheet sheet = new Sheet(1, 0, PaperBonusExcelVo.class);
            sheet.setSheetName("\u5956\u91d1");
            writer.write(result, sheet);
            Sheet sheet2 = new Sheet(2, 0, PaperBonusDetailExcelVo.class);
            sheet2.setSheetName("\u5956\u91d1\u660e\u7ec6");
            writer.write(detailVos, sheet2);
            writer.finish();
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"/getBonusesListByUser"})
    public BaseJsonVo getBonusesListByUser(String userId, Integer year, Integer month, Integer questionClassId) throws AuthorizeException {
        if (year == null) {
            return BaseJsonVo.error((String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (month == null) {
            return BaseJsonVo.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)userId)) {
            MallUserEntity userEntity = this.getUser();
            userId = userEntity.getUserId();
        }
        return BaseJsonVo.success((Object)this.paperReportBounsService.getMyBonusesList(userId, year, month, questionClassId));
    }

    @RequestMapping(value={"/getPaperBonusDetaiList"})
    public BaseJsonVo getPaperBonusDetaiList(String userId, Integer year, Integer month, Integer questionClassId) throws AuthorizeException {
        if (year == null) {
            return BaseJsonVo.error((String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (month == null) {
            return BaseJsonVo.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer reportStatus = null;
        if (StringUtils.isEmpty((String)userId)) {
            MallUserEntity userEntity = this.getUser();
            userId = userEntity.getUserId();
        } else {
            reportStatus = 3;
        }
        return BaseJsonVo.success((Object)this.paperReportBounsService.getPaperBonusDetailExcelList(userId, year, month, questionClassId, reportStatus));
    }

    @RequestMapping(value={"/calculateBonuses"})
    public BaseJsonVo calculateBonuses(Integer period) throws AuthorizeException {
        this.paperReportBounsService.calculateBonuses(period);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/initReportStatus"})
    public BaseJsonVo initReportStatus() throws AuthorizeException {
        this.paperReportBounsService.initReportStatus();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/checkCurrentPeriodOrLastPeriod"})
    public BaseJsonVo checkCurrentPeriodOrLastPeriod(int periodId) {
        return BaseJsonVo.success((Object)this.periodService.checkCurrentPeriodOrLastPeriod(periodId));
    }

    @RequestMapping(value={"/modityPaperStatus"})
    public BaseJsonVo modityPaperStatus(PaperEntity paperEntity) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        this.paperService.modityPaperStatus(paperEntity, userEntity);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getWeekThingWeekFinish"})
    public BaseJsonVo getWeekThingWeekFinish(Integer period, String userId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getWeekThingWeekFinish(period, userId, userEntity.getUserId());
    }

    @RequestMapping(value={"modifyPaperAnswerRelationSort"})
    public BaseJsonVo modifyPaperAnswerRelationSort(Integer answerRelationId, Integer questionId, int sort, String userId, Integer classId, String paperId) throws AuthorizeException {
        this.relationService.modifyPaperAnswerRelationSort(answerRelationId, questionId, sort, userId, paperId);
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getPaperAnswerList(classId, paperId, userEntity.getUserId());
    }

    public BaseJsonVo modifyPaperAnswerRelationDissent(Integer id, Integer isDissent) {
        if (id == null || isDissent == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return this.relationService.modifyPaperAnswerRelationDissent(id, isDissent);
    }

    @RequestMapping(value={"importPaperAnswer"}, method={RequestMethod.POST})
    public BaseJsonVo importPaperAnswer(@RequestParam(value="file") MultipartFile file) throws IOException {
        return this.paperAnswerService.importPaperAnswer(file);
    }

    @RequestMapping(value={"queryDayReport"})
    public BaseJsonVo queryDayReport(Integer periodId, String userId) {
        return this.paperAnswerService.queryDayReport(periodId, userId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"getExportData"})
    public void getExportData(PaperSearchVo paper, HttpServletResponse response) throws AuthorizeException, IOException {
        if (paper == null) {
            return;
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return;
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        if (paper.getYear() == null || paper.getPeriod() == null) {
            BaseJsonVo baseJsonVo = this.periodService.currentPeriod(periodType);
            if (baseJsonVo.getValue() == null) return;
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
        } else {
            BaseJsonVo inPeriodWithNum = this.periodService.getPeriodWithNum(paper.getYear(), paper.getPeriod().intValue(), periodType);
            if (!inPeriodWithNum.isSuccess()) return;
            paperEntity.setPeriodId(((PeriodEntity)inPeriodWithNum.getValue()).getId());
        }
        if (paper.getClassId() == null) {
            return;
        }
        paperEntity.setQuestionClassId(paper.getClassId());
        if (paper.getOnlyme() != null && paper.getOnlyme() == 1) {
            paperEntity.setUserId(userEntity.getUserId());
        } else if (StringUtils.isNotEmpty((String)paper.getUserId())) {
            paperEntity.setUserId(paper.getUserId());
        } else {
            paperEntity.setUserId(userEntity.getUserId());
        }
        String sheetName = "\u534f\u4f5c\u529e\u516c";
        QuestionClassEntity classEntity = this.iOrgQuestionClassDomain.select(paperEntity.getQuestionClassId());
        if (classEntity != null) {
            sheetName = classEntity.getClassName();
        }
        List maps = null;
        maps = classEntity.getClassId() == 10 ? this.paperService.getExportDataKpi(paperEntity) : this.paperService.getExportData(paperEntity);
        if (maps.size() <= 0) return;
        String[] s = new String[1];
        String[] b = ((LinkedHashMap)maps.get(0)).keySet().toArray(s);
        ExcelUtil.exportExcel((HttpServletResponse)response, (String)(sheetName + "_" + userEntity.getUserNick() + ".xlsx"), (String)sheetName, (String[])b, (List)maps, (String)"");
    }

    @RequestMapping(value={"/modityWeekAfterWeek"})
    public BaseJsonVo modityWeekAfterWeek(Integer id, Integer isFinishLeader, Integer isFinishEmploye) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperService.modityWeekAfterWeek(id, userEntity.getUserId(), isFinishLeader, isFinishEmploye);
    }

    @RequestMapping(value={"/delPaperAnswerRelation"})
    public BaseJsonVo delPaperAnswerRelation(Integer relationId, Integer classId, String paperId) throws AuthorizeException {
        this.relationService.delPaperAnswerRelation(relationId, paperId);
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getPaperAnswerList(classId, paperId, userEntity.getUserId());
    }
}

