/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductLineEntity;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product"})
public class MallProductController
extends BaseController {
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private DistributorItemInterface distributorItemInterface;

    @RequestMapping(value={"proTypeList"})
    public List<MallProductLineEntity> prolist() throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        return this.productInterface.getProductTypeList(platFormGroupId);
    }

    @RequestMapping(value={"prolist"})
    public PageInfo prolist(PageForm pageForm, MallProductEntity mallProductEntity) throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        mallProductEntity.setPlatformGroupId(platFormGroupId);
        return this.productInterface.getProductList(pageForm.getCurrentPage(), pageForm.getPageSize(), mallProductEntity);
    }

    @RequestMapping(value={"getProducts"})
    public BaseJsonVo getProducts() throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        List list = this.productInterface.getOnProductList(platFormGroupId);
        if (list != null) {
            return BaseJsonVo.success((Object)list);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    @RequestMapping(value={"getProduct"})
    public BaseJsonVo getProduct(String proId) {
        MallProductEntity entity = this.productInterface.getProduct(proId);
        if (entity != null) {
            return BaseJsonVo.success((Object)entity);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    @RequestMapping(value={"addProduct"})
    public BaseJsonVo addProduct(MallProductEntity mallProductEntity) throws AuthorizeException {
        mallProductEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        BaseJsonVo sr = this.productInterface.addProduct(mallProductEntity);
        if (sr.isSuccess()) {
            MallProductEntity p = (MallProductEntity)sr.getValue();
            this.distributorItemInterface.initDistributorItem(p.getProId(), Integer.valueOf(4));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delProduct"})
    public BaseJsonVo delProduct(MallProductEntity mallProductEntity) {
        BaseJsonVo sr = this.productInterface.delProduct(mallProductEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallProductEntity.getProId(), Integer.valueOf(4));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getProductByProType"})
    public BaseJsonVo getProductByProType(String proType) {
        List mallProductEntityList = this.productInterface.getProductByProType(proType);
        return BaseJsonVo.success((Object)mallProductEntityList);
    }
}

