/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQueryVo;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.service.check.ActiveCheckOnlineContext;
import cc.lechun.active.vo.ActiveBaseVo;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activeManage"})
public class ActiveController
extends BaseController {
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private ActiveRuleInterface activeRuleService;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private PlatFormGroupInterface platFormGroupService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private ActiveCashticketInterface activeCashticketServcie;
    @Autowired
    private ActivePageInterface activePageService;
    @Autowired
    private ActiveCheckOnlineContext checkOnlineContext;
    @Autowired
    private DistributorItemInterface distributorItemInterface;
    @Autowired
    private ActiveIndexInterface activeIndexInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;

    @RequestMapping(value={"/saveActiveIndex"})
    public BaseJsonVo saveActiveIndex(ActiveIndexEntity activeIndexEntity) {
        return this.activeIndexInterface.saveActiveIndex(activeIndexEntity);
    }

    @RequestMapping(value={"/deletActiveIndex"})
    public BaseJsonVo deletActiveIndex(Integer activeIndexId) {
        return this.activeIndexInterface.deleteByPrimaryKey((Serializable)activeIndexId) >= 1 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\u8bf7\u91cd\u8bd5!");
    }

    @RequestMapping(value={"/getActiveIndexList"})
    public BaseJsonVo getActiveIndexList(PageForm pageForm) {
        return BaseJsonVo.success((Object)this.activeIndexInterface.getActiveIndexList(pageForm, Integer.valueOf(1000)));
    }

    @RequestMapping(value={"/activeOnlineCheck"})
    public BaseJsonVo ActiveOnlineCheck(String activeNo, Integer status) {
        BaseJsonVo js = this.checkOnlineContext.checkOnLine(activeNo, status);
        if (js.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(activeNo, Integer.valueOf(5));
        }
        return js;
    }

    @RequestMapping(value={"/saveActive"})
    public BaseJsonVo saveActive(ActiveEntity active, HttpServletRequest request, HttpServletResponse response) {
        ActiveEntity activeEntity;
        BaseJsonVo js = this.activeService.saveActive(active);
        if (js.isSuccess() && (activeEntity = (ActiveEntity)js.getValue()) != null) {
            this.distributorItemInterface.initDistributorItem(activeEntity.getActiveNo(), Integer.valueOf(5));
        }
        return js;
    }

    @RequestMapping(value={"/saveActiveProperty"})
    public BaseJsonVo saveActiveProperty(ActivePropertyEntity activePropertyEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        activePropertyEntity.setPlatformGroupId(user.getPlatformGroupId());
        return this.activePropertyInterface.saveActiveProperty(activePropertyEntity);
    }

    @RequestMapping(value={"/getActiveList"})
    public BaseJsonVo getActiveList(ActiveQueryVo activeQueryVo) {
        return BaseJsonVo.success((Object)this.activeService.getActiveList(activeQueryVo));
    }

    @RequestMapping(value={"/getActive/{activeNo}"})
    public ActiveEntity getActive(@PathVariable String activeNo) {
        return this.activeService.getActiveEntityByActiveNo(activeNo);
    }

    @RequestMapping(value={"/getActiveForOption"})
    public BaseJsonVo getEnableActiveList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.activeService.getActiveForOption(user.getPlatformGroupId()));
    }

    @RequestMapping(value={"/getActiveForOptionList"})
    public BaseJsonVo getActiveForOptionList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.activeService.getActiveForOptionByStatus(Integer.valueOf(1), user.getPlatformGroupId()));
    }

    @RequestMapping(value={"/changeActiveStatus"})
    public BaseJsonVo changeActiveStatus(String activeNo) {
        BaseJsonVo js;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(activeNo);
        ActiveEntity update = new ActiveEntity();
        update.setStatus(Integer.valueOf(activeEntity.getStatus() == 1 ? 0 : 1));
        BaseJsonVo baseJsonVo = js = this.activeService.updateActive(activeEntity) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
        if (js.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(activeNo, Integer.valueOf(5));
        }
        return js;
    }

    @RequestMapping(value={"/deleteActive/{activeNo}"})
    public ActiveBaseVo<String> deleteActive(@PathVariable String activeNo) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        boolean result = this.activeService.deleteActive(activeNo);
        if (result) {
            activeBaseVo.setStatus(1);
            this.distributorItemInterface.initDistributorItem(activeNo, Integer.valueOf(5));
            activeBaseVo.setMsg("\u6210\u529f");
        } else {
            activeBaseVo.setStatus(0);
            activeBaseVo.setMsg("\u6d3b\u52a8\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5~");
        }
        return activeBaseVo;
    }

    @RequestMapping(value={"/saveActiveRule"})
    public BaseJsonVo saveActiveRule(ActiveRuleEntity activeRuleEntity) {
        return this.activeRuleService.saveActiveRule(activeRuleEntity);
    }

    @RequestMapping(value={"/getActiveRuleList"})
    public BaseJsonVo getActiveList(String activeNo) {
        return BaseJsonVo.success((Object)this.activeRuleService.getRuleList(activeNo));
    }

    @RequestMapping(value={"/deleteActiveRule"})
    public BaseJsonVo deleteActiveRule(int id) {
        return this.activeRuleService.deleteActiveRule(id) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/getActiveCashticket"})
    public ActiveBaseVo<List<ActiveCashticketVo>> getActiveCashticket(String bindCode, Integer platformId) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        activeBaseVo.setData((Object)this.activeCashticketServcie.getActiveCashticketList(bindCode, platformId));
        return activeBaseVo;
    }

    @RequestMapping(value={"/saveActivePage"})
    public BaseJsonVo saveActivePage(ActivePageEntity activePageEntity) {
        return this.activePageService.saveActivePage(activePageEntity);
    }

    @RequestMapping(value={"/getActivePage"})
    public BaseJsonVo getActivePage(String activeNo) {
        return BaseJsonVo.success((Object)this.activePageService.getActivePageEntityByActiveNo(activeNo));
    }

    @RequestMapping(value={"/saveActiveCheckInConfig"})
    public BaseJsonVo saveActiveCheckInConfig(String activeNo, String remindText, Integer maxCount) {
        return this.activeService.saveActiveCheckInConfig(activeNo, remindText, maxCount);
    }

    @RequestMapping(value={"/getActiveCheckInConfig"})
    public BaseJsonVo getActiveCheckInConfig(String activeNo) {
        return this.activeService.getActiveCheckInConfig(activeNo);
    }
}

