/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.balance;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.trade.RefundSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.sms.OrderSmsRecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.OrderRefundInterface;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customerBalance"})
public class CustomerBalanceController
extends BaseController {
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private AccountBalanceInterface accountBalanceService;
    @Autowired
    private OrderRefundInterface refundService;
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private OrderSmsRecordInterface orderSmsRecordInterface;

    @RequestMapping(value={"/sendSms"})
    public BaseJsonVo sendSms(String customerId) {
        this.orderSmsRecordInterface.sendSms(7, DateUtils.now());
        this.orderSmsRecordInterface.sendSms(16, DateUtils.now());
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getTotalBalance"})
    public BaseJsonVo getTotalBalance(String customerId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.balanceAccountInvoke.getUserBalance(customerId);
    }

    @RequestMapping(value={"/getUserBalanceDetail"})
    public BaseJsonVo getUserBalanceDetail(String customerId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.balanceAccountInvoke.getUserBalanceDetail(customerId);
    }

    @RequestMapping(value={"/increaseManual"})
    public BaseJsonVo increaseManual(String customerId, BigDecimal increaseAmount, String detailSubTypeDesc) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.balanceAccountInvoke.increaseManual(customerId, increaseAmount, user.getUserId(), detailSubTypeDesc);
    }

    @RequestMapping(value={"/reduceManual"})
    public BaseJsonVo reduceManual(String customerId, BigDecimal reduceAmount, String detailSubTypeDesc) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.balanceAccountInvoke.reduceManual(customerId, reduceAmount, user.getUserId(), detailSubTypeDesc);
    }

    @RequestMapping(value={"/refundCharge"})
    public BaseJsonVo refundCharge(String customerId, String orderMainNo) throws AuthorizeException {
        this.log.info("customerId:" + customerId);
        this.log.info("orderMainNo:" + orderMainNo);
        MallUserEntity user = this.getUser();
        BaseJsonVo refund = this.accountBalanceService.refundCharge(customerId, orderMainNo, user.getUserId());
        if (refund.isSuccess()) {
            List orderList = this.orderService.getOrderList(orderMainNo);
            OrderRefundApplyVo refundApplyVo = new OrderRefundApplyVo();
            refundApplyVo.setOrderMainNo(orderMainNo);
            refundApplyVo.setOrderNo(((MallOrderEntity)orderList.get(0)).getOrderNo());
            refundApplyVo.setSourceEnum(RefundSourceEnum.cms);
            refundApplyVo.setRefundOrderType(((BalanceChangeDTO)refund.getValue()).getStoreBalanceChange().compareTo(((MallOrderEntity)orderList.get(0)).getPayAmount()) == 0 ? 1 : 2);
            refundApplyVo.setReason("\u50a8\u503c\u9000\u6b3e");
            refundApplyVo.setReturnAmount(((BalanceChangeDTO)refund.getValue()).getStoreBalanceChange());
            refundApplyVo.setPayDetailVos(null);
            refundApplyVo.setBalanceAmount(BigDecimal.ZERO);
            refundApplyVo.setCashAmount(PriceUtils.format((BigDecimal)((BalanceChangeDTO)refund.getValue()).getStoreBalanceChange()));
            refundApplyVo.setIsRefundCoupon(0);
            refundApplyVo.setOperator(user.getUserId());
            BaseJsonVo returnBaseJson = this.refundService.createRefundBill(refundApplyVo, false);
            if (returnBaseJson.isSuccess()) {
                MallRefundEntity refundEntity = (MallRefundEntity)returnBaseJson.getValue();
                returnBaseJson = this.refundService.passOrderRefund(refundEntity.getRefundId(), user.getUserId(), null);
            }
            return returnBaseJson;
        }
        return refund;
    }
}

