/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.order;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.trade.ChannelEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.OrderListDo;
import cc.lechun.mall.entity.trade.OrderPayExportVo;
import cc.lechun.mall.entity.trade.OrderQueryDo;
import cc.lechun.mall.entity.trade.OrderRefundExportVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.MallRefundRecordInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/order"})
public class OrderController
extends BaseController {
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private MallRefundPayDetailInterface mallRefundPayDetailInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallRefundRecordInterface mallRefundRecordInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private MallOrderSyncInfoInterface mallOrderSyncInfoInterface;
    private String key = "";

    @RequestMapping(value={"getOrderList"})
    @ResponseBody
    public BaseJsonVo getOrderList(OrderQueryDo orderQueryDo) {
        boolean orderNoQueryFlag;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (orderQueryDo != null && StringUtils.isNotEmpty((String)orderQueryDo.getOpenId())) {
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(orderQueryDo.getOpenId(), 1);
            if (customerDetailVo != null) {
                orderQueryDo.setCustomerId(customerDetailVo.getCustomerId());
            } else {
                map.put("total", 0);
                map.put("list", "");
                return BaseJsonVo.success(map);
            }
        }
        boolean bl = orderNoQueryFlag = StringUtils.isNotEmpty((String)orderQueryDo.getOrderNo()) || StringUtils.isNotEmpty((String)orderQueryDo.getOrderMainNo()) || StringUtils.isNotEmpty((String)orderQueryDo.getConsigneeName()) || StringUtils.isNotEmpty((String)orderQueryDo.getConsigneePhone());
        if (!orderNoQueryFlag && orderQueryDo.getStart() == null) {
            orderQueryDo.setStart(DateUtils.currentDate());
        }
        PageInfo pageInfo = this.orderMainInterface.getOrderList4cms(orderQueryDo);
        ArrayList list = new ArrayList();
        if (pageInfo != null) {
            pageInfo.getList().forEach(o -> {
                OrderListDo orderListDo = new OrderListDo();
                BeanUtils.copyProperties((Object)o, (Object)orderListDo);
                CustomerEntity customerEntity = this.customerService.getCustomer(o.getCustomerId());
                if (customerEntity != null) {
                    orderListDo.setNickName(customerEntity.getNickName());
                    orderListDo.setHeadImageUrl(customerEntity.getHeadImageUrl());
                }
                orderListDo.setStatusName(OrderStatusEnum.getName((int)o.getStatus()));
                orderListDo.setStatusClassName(OrderClassEnum.getName((int)o.getOrderClass()));
                orderListDo.setChannelName(ChannelEnum.getName((int)o.getChannelId()));
                orderListDo.setOrderSourceName(OrderSourceEnum.getName((int)o.getOrderSource()));
                list.add(orderListDo);
            });
        }
        map.put("list", list);
        map.put("total", pageInfo.getTotal());
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"refund"})
    @ResponseBody
    public BaseJsonVo refund(String tradeNo, String refundBillNo, BigDecimal payAmount, BigDecimal refundAmount, String customerId, String sign) {
        this.log.info("=========cc.lechun.cms.controller.order.OrderController.refund param tradeNo:[{}],refundBillNo:[{}],payAmount:[{}],refundAmount:[{}],customerId:[{}],sign:[{}]", new Object[]{tradeNo, refundBillNo, payAmount, refundAmount, customerId, sign});
        BaseJsonVo result = this.payOrderInterface.payRefund(null, "", tradeNo, refundBillNo, payAmount, refundAmount, customerId, sign, true);
        if (result.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)result.getError_msg());
    }

    @RequestMapping(value={"edbOrderSyncQuartz"})
    @ResponseBody
    public BaseJsonVo edbOrderSyncQuartz() {
        this.orderService.edbOrderSyncQuartz();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"unsyncEDBOrders"})
    @ResponseBody
    public BaseJsonVo unsyncEDBOrders(PageForm pageForm) {
        PageInfo orders = this.orderService.findUnsyncEDBOrders(pageForm.getCurrentPage(), pageForm.getPageSize());
        return BaseJsonVo.success((Object)orders);
    }

    @RequestMapping(value={"omsOrderSyncQuartz"})
    @ResponseBody
    public BaseJsonVo omsOrderSyncQuartz(String orderMainNo) {
        return this.mallOrderSyncInfoInterface.batchSyncOrderToOMS(orderMainNo);
    }

    @RequestMapping(value={"unsyncOMSOrders"})
    @ResponseBody
    public BaseJsonVo unsyncOMSOrders(PageForm pageForm) {
        PageInfo orders = this.mallOrderSyncInfoInterface.findUnSyncOrderToOMS(pageForm.getCurrentPage(), pageForm.getPageSize());
        return BaseJsonVo.success((Object)orders);
    }

    @RequestMapping(value={"fixBalancePay"})
    @ResponseBody
    public BaseJsonVo fixBalancePay() {
        this.orderService.backupWealthData();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"queryRefundPayDetailList"})
    @ResponseBody
    public void queryRefundPayDetailList() {
        this.mallRefundPayDetailInterface.queryRefundPayDetailList();
    }

    @RequestMapping(value={"updateOrderStatus"})
    @ResponseBody
    public BaseJsonVo updateOrderStatus(String mainOrderNo) {
        return this.orderMainInterface.paySuccessOrderMain(mainOrderNo) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u4fee\u6539\u6761\u4ef6");
    }

    @RequestMapping(value={"edbOrderSync"})
    @ResponseBody
    public BaseJsonVo edbOrderSync(String orderMainNo) {
        return this.orderService.edbOrderSync(orderMainNo);
    }

    @RequestMapping(value={"getExportData"})
    public void getExportData(HttpServletResponse response, String createTime) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + createTime + URLEncoder.encode("\u6708\u4efd\u9000\u4ed8\u6b3e\u4fe1\u606f", "UTF-8") + ".xlsx");
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).build();
            List orderRefundExportVos = this.mallRefundRecordInterface.getRefundInfo(createTime);
            WriteSheet writeSheetRefund = EasyExcel.writerSheet((Integer)0, (String)(createTime + "\u6708\u4efd\u9000\u6b3e")).head(OrderRefundExportVo.class).build();
            excelWriter.write(orderRefundExportVos, writeSheetRefund);
            List orderPayExportVos = this.mallOrderPayInterface.getOrderPayInfo(createTime);
            WriteSheet writeSheetPya = EasyExcel.writerSheet((Integer)1, (String)(createTime + "\u6708\u4efd\u4ed8\u6b3e")).head(OrderPayExportVo.class).build();
            excelWriter.write(orderPayExportVos, writeSheetPya);
            excelWriter.finish();
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"hideOrder"})
    @ResponseBody
    public BaseJsonVo hideOrder(String orderMainNo) {
        return this.orderMainInterface.hideOrder(orderMainNo);
    }

    @RequestMapping(value={"/createDatasource"})
    @ResponseBody
    public BaseJsonVo createDatasource(Integer platformId, Integer platformGroupId, String type, String name, String description) {
        return BaseJsonVo.success((Object)"");
    }
}

