/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.order;

import cc.lechun.apiinvoke.mall.RefundPrepayCardPlanInvoke;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.RefundSourceEnum;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.ApplyRefundPayDetailVo;
import cc.lechun.mall.entity.trade.CheckRefundPayDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallRefundVo;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallRefundInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.OrderRefundInterface;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/refund"})
public class RefundController
extends BaseController {
    @Autowired
    private RedisService redisService;
    @Autowired
    private OrderRefundInterface refundInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private RefundPrepayCardPlanInvoke refundPrepayCardPlanInvoke;
    @Autowired
    private MallRefundInterface mallRefundInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallRefundPayDetailInterface mallRefundPayDetailInterface;
    @Value(value="${lechun.oldapi.domain}")
    private String olderpDomain;

    @RequestMapping(value={"/refundApply"})
    public BaseJsonVo refundApply(int refundOrderType, String orderMainNo, String orderNo, String reason, BigDecimal returnAmount, String tkStr, String ticket, String prePayPlanNum, String pageInfo) {
        MallOrderMainEntity mallOrderMainEntity;
        this.log.info("=================<<start in refundApply>>===========refundOrderType={},orderMainNo={},orderNo={},returnAmount={},tkStr={},ticket={},prePayPlanNum={},pageInfo={}", new Object[]{refundOrderType, orderMainNo, orderNo, returnAmount, tkStr, ticket, prePayPlanNum, pageInfo});
        boolean isMilkFlag = false;
        ArrayList<String> remarkList = new ArrayList<String>();
        List mallOrderPayList = this.mallOrderPayInterface.getList(orderMainNo);
        if ("milkPageInfo".equals(pageInfo)) {
            BaseJsonVo refundCardInfoJson;
            isMilkFlag = true;
            boolean milkNumFlag = false;
            String[] prePayPlanNumStrList = null;
            if (prePayPlanNum != null && !prePayPlanNum.equals("null") && !"".equals(prePayPlanNum)) {
                milkNumFlag = true;
                prePayPlanNumStrList = prePayPlanNum.split(",");
                this.log.info("======prePayPlanNumList======prePayPlanNumList={}", (Object)JSON.toJSONString((Object)prePayPlanNumStrList));
                MallRefundVo mallRefundVo = new MallRefundVo();
                mallRefundVo.setOrderMainNo(orderMainNo);
                for (String prePayPlanNumStr : prePayPlanNumStrList) {
                    remarkList.add(prePayPlanNumStr);
                }
                List mallRefundList = this.mallRefundInterface.getRefundInfo(orderMainNo, remarkList);
                if (mallRefundList != null && mallRefundList.size() > 0) {
                    BaseJsonVo baseJsonVo = new BaseJsonVo();
                    baseJsonVo.setError("\u5b58\u5728\u672a\u5904\u7406\u7684\u7533\u8bf7\u5355");
                    return baseJsonVo;
                }
            }
            String paytypeId = "";
            BigDecimal amountSum = BigDecimal.ZERO;
            if (mallOrderPayList != null && mallOrderPayList.size() > 0) {
                MallOrderPayEntity mallOrderPayEntity = (MallOrderPayEntity)mallOrderPayList.get(0);
                paytypeId = String.valueOf(mallOrderPayEntity.getPaytypeId());
                amountSum = mallOrderPayEntity.getPayamount();
            }
            if (!(refundCardInfoJson = this.refundPrepayCardPlanInvoke.getCardInfo(orderMainNo)).isSuccess()) {
                return refundCardInfoJson;
            }
            Map resultMap = (Map)refundCardInfoJson.getValue();
            int remainCount = (Integer)resultMap.get("remainCount");
            Double perPrice = (Double)resultMap.get("perPrice");
            amountSum = new BigDecimal(remainCount).multiply(new BigDecimal(perPrice.toString()));
            if (milkNumFlag) {
                amountSum = BigDecimal.ZERO;
                for (String prePayPlanNumStr : prePayPlanNumStrList) {
                    BaseJsonVo baseJsonVo = this.refundPrepayCardPlanInvoke.getOrderPlanDetail(Integer.valueOf(prePayPlanNumStr));
                    this.log.info("================baseJsonVo={}", (Object)JSON.toJSONString((Object)baseJsonVo));
                    if (!baseJsonVo.isSuccess()) {
                        return baseJsonVo;
                    }
                    BigDecimal amount = BigDecimal.ZERO;
                    amount = new BigDecimal(String.valueOf(baseJsonVo.getValue()));
                    amountSum = amountSum.add(amount);
                }
            }
            returnAmount = amountSum;
            tkStr = paytypeId + "|" + amountSum;
        }
        if ((mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo)) != null) {
            if (OrderSourceEnum.CARDPLAN.getValue() == mallOrderMainEntity.getOrderSource().intValue()) {
                isMilkFlag = true;
                String sourceOrderNo = mallOrderMainEntity.getSourceOrderNo();
                MallOrderEntity mallOrderEntity = new MallOrderEntity();
                mallOrderEntity.setOrderMainNo(sourceOrderNo);
                mallOrderEntity = this.orderInterface.getmallOrder(mallOrderEntity);
                String paytypeId = "";
                if (mallOrderPayList != null && mallOrderPayList.size() > 0) {
                    MallOrderPayEntity mallOrderPayEntity = (MallOrderPayEntity)mallOrderPayList.get(0);
                    paytypeId = String.valueOf(mallOrderPayEntity.getPaytypeId());
                }
                orderNo = mallOrderEntity.getOrderNo();
                orderMainNo = mallOrderEntity.getOrderMainNo();
                tkStr = paytypeId + "|" + returnAmount;
            }
            if (mallOrderMainEntity.getOrderSource() >= OrderSourceEnum.CARD_PREPAY_TMALL.getValue() && mallOrderMainEntity.getOrderSource() <= OrderSourceEnum.CARD_PREPAY_SHOP.getValue()) {
                isMilkFlag = true;
            }
        }
        String operater = "";
        BaseJsonVo baseJsonVo = this.validateErpRight(ticket);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        operater = baseJsonVo.getValue().toString();
        ArrayList<ApplyRefundPayDetailVo> refundPayDetailVos = new ArrayList<ApplyRefundPayDetailVo>();
        ApplyRefundPayDetailVo refundPayDetailVo = null;
        OrderRefundApplyVo refundApplyVo = new OrderRefundApplyVo();
        if (tkStr != null && !tkStr.isEmpty()) {
            for (String s : tkStr.split("@")) {
                String[] pay = s.split("\\|");
                if (pay.length < 2) {
                    return BaseJsonVo.error((String)"\u9000\u6b3e\u660e\u7ec6\u53c2\u6570\u4e0d\u6b63\u786e");
                }
                if ("3".equals(pay[0])) {
                    if (mallOrderPayList == null || mallOrderPayList.size() <= 0) continue;
                    mallOrderPayList = mallOrderPayList.stream().filter(c -> c.getPaytypeId() == 3).collect(Collectors.toList());
                    for (MallOrderPayEntity mallOrderPayEntity : mallOrderPayList) {
                        ApplyRefundPayDetailVo refundPayDetailVo1 = new ApplyRefundPayDetailVo();
                        refundPayDetailVo1.setAmount(mallOrderPayEntity.getPayamount());
                        refundPayDetailVo1.setPayTypeId(mallOrderPayEntity.getPaytypeId());
                        refundPayDetailVos.add(refundPayDetailVo1);
                    }
                    continue;
                }
                refundPayDetailVo = new ApplyRefundPayDetailVo();
                refundPayDetailVo.setAmount(new BigDecimal(pay[1]));
                refundPayDetailVo.setPayTypeId(Integer.valueOf(Integer.parseInt(pay[0])));
                refundPayDetailVos.add(refundPayDetailVo);
            }
        } else {
            refundApplyVo.setCashAmount(new BigDecimal(0));
            refundApplyVo.setBalanceAmount(new BigDecimal(0));
        }
        refundApplyVo.setRemark(String.valueOf(prePayPlanNum));
        refundApplyVo.setOrderMainNo(orderMainNo);
        refundApplyVo.setOrderNo(orderNo);
        refundApplyVo.setSourceEnum(RefundSourceEnum.erp);
        refundApplyVo.setRefundOrderType(refundOrderType);
        refundApplyVo.setReason(reason);
        refundApplyVo.setReturnAmount(returnAmount);
        refundApplyVo.setPayDetailVos(refundPayDetailVos);
        refundApplyVo.setIsRefundCoupon(2);
        refundApplyVo.setOperator(operater);
        refundApplyVo.setOtherTkOrderNo(mallOrderMainEntity.getOrderMainNo());
        BaseJsonVo jsonVo = this.refundInterface.createRefundBill(refundApplyVo, isMilkFlag);
        jsonVo.setValue((Object)"");
        return jsonVo;
    }

    private BaseJsonVo validateErpRight(String ticket) {
        String rtn = HttpRequest.get((String)(this.olderpDomain + "sysproduct/userValidate?ticket=" + ticket), (String)"");
        Map map = JsonUtils.stringToMap((String)rtn);
        this.log.info(rtn);
        String operater = "";
        if (map.get("ticket").toString().equals("1")) {
            operater = map.get("userName").toString();
            return BaseJsonVo.success((Object)operater);
        }
        return BaseJsonVo.error((String)("\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7:" + map.get("message")));
    }

    @RequestMapping(value={"/refundCheck"})
    public BaseJsonVo refundCheck(int refundType, String refundId, String tkStr, String ticket) {
        String operater = "";
        BaseJsonVo baseJsonVo = this.validateErpRight(ticket);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        operater = baseJsonVo.getValue().toString();
        ArrayList<CheckRefundPayDetailVo> payDetailVos = new ArrayList<CheckRefundPayDetailVo>();
        CheckRefundPayDetailVo payDetailVo = null;
        for (String s : tkStr.split("@")) {
            String[] pay = s.split("\\|");
            if (pay.length < 2) {
                return BaseJsonVo.error((String)"\u9000\u6b3e\u660e\u7ec6\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            payDetailVo = new CheckRefundPayDetailVo();
            payDetailVo.setFactReturnAmount(new BigDecimal(pay[1]));
            payDetailVo.setRefundPayId(pay[0]);
            payDetailVo.setOperator(operater);
            payDetailVo.setIsRefundCoupon(2);
            payDetailVos.add(payDetailVo);
        }
        BaseJsonVo jsonVo = this.refundInterface.passOrderRefund(refundId, operater, payDetailVos);
        return jsonVo;
    }

    @RequestMapping(value={"/refundFail"})
    @ResponseBody
    public BaseJsonVo refundFail(String refundId, String reason, String ticket) {
        String operater = "";
        BaseJsonVo baseJsonVo = this.validateErpRight(ticket);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        operater = baseJsonVo.getValue().toString();
        BaseJsonVo jsonVo = this.refundInterface.failOrderRefund(refundId, reason);
        return jsonVo;
    }

    @RequestMapping(value={"/refundCancel"})
    @ResponseBody
    public BaseJsonVo refundCancel(String refundId, String reason, String ticket) {
        String operater = "";
        BaseJsonVo baseJsonVo = this.validateErpRight(ticket);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        operater = baseJsonVo.getValue().toString();
        BaseJsonVo jsonVo = this.refundInterface.cancelOrderRefund(refundId, reason);
        return jsonVo;
    }

    @RequestMapping(value={"/getPayBalanceList"})
    public BaseJsonVo getPayBalanceList(String orderMainNo, String orderNo, String ticket) {
        String operater = "";
        BaseJsonVo baseJsonVo = this.validateErpRight(ticket);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        operater = baseJsonVo.getValue().toString();
        return this.refundInterface.getPayBalanceList(orderMainNo, orderNo);
    }

    @RequestMapping(value={"/getOrderRefundInfo"})
    public BaseJsonVo getOrderRefundInfo(String orderNo) {
        return this.mallRefundPayDetailInterface.getOrderRefundInfo(null, orderNo);
    }
}

