/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.organization;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.organization.entity.KpiEntity;
import cc.lechun.organization.iservice.KpiInterface;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"kpi"})
public class KPIController
extends BaseController {
    @Autowired
    private KpiInterface kpiInterface;
    @Autowired
    private MallUserInterface userInterface;

    @RequestMapping(value={"/getKpis"})
    public BaseJsonVo getKpis(Integer classId, String paperId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (paperId == null) {
            return BaseJsonVo.error((String)"paperId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.kpiInterface.getKpis(paperId, userEntity.getUserId()));
    }

    @RequestMapping(value={"/saveKpi"})
    public BaseJsonVo saveKpi(@RequestParam(value="kpiEntityList") String kpiEntityList) throws AuthorizeException {
        BaseJsonVo baseJson;
        List kpiEntityList1 = JsonUtils.getListByArray(KpiEntity.class, (String)kpiEntityList);
        MallUserEntity userEntity = this.getUser();
        if (kpiEntityList == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        for (KpiEntity kpiEntity : kpiEntityList1) {
            if (kpiEntity.getWeight() == null) {
                kpiEntity.setWeight(BigDecimal.valueOf(0L));
            }
            if (kpiEntity.getLeaderWeight() == null) {
                kpiEntity.setLeaderWeight(BigDecimal.valueOf(0L));
            }
            if (kpiEntity.getLeaderValue() == null) {
                kpiEntity.setLeaderValue(BigDecimal.valueOf(0L));
            }
            if (kpiEntity.getValue() == null) {
                kpiEntity.setValue(BigDecimal.valueOf(0L));
            }
            if (kpiEntity.getFactValue() == null) {
                kpiEntity.setFactValue(BigDecimal.valueOf(0L));
            }
            if (kpiEntity.getMonth() != null && kpiEntity.getMonth() > 0) {
                kpiEntity.setMonthKpi(Integer.valueOf(1));
            } else {
                kpiEntity.setMonthKpi(Integer.valueOf(0));
            }
            if (kpiEntity.getKpi() == null) {
                kpiEntity.setKpi("");
            }
            if (kpiEntity.getKpi().length() > 500) {
                return BaseJsonVo.error((String)"\u56de\u7b54\u6587\u5b57\u4e0d\u80fd\u5927\u4e8e500\u5b57");
            }
            if (kpiEntity.getPaperId() != null) continue;
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e3a\u7a7a");
        }
        try {
            baseJson = this.kpiInterface.saveKpi(kpiEntityList1, userEntity.getUserId());
        }
        catch (RuntimeException e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return baseJson;
    }

    @RequestMapping(value={"/saveKpitest"})
    public BaseJsonVo saveKpitest() throws AuthorizeException {
        BaseJsonVo baseJson;
        ArrayList<KpiEntity> kpiEntities = new ArrayList<KpiEntity>();
        for (int i = 1; i < 2; ++i) {
            KpiEntity kpiEntity = new KpiEntity();
            kpiEntity.setPaperId("1222910163375493120");
            kpiEntity.setKpi("kpi" + i);
            kpiEntity.setWeight(BigDecimal.valueOf(10L));
            kpiEntity.setValue(BigDecimal.valueOf(10000L));
            kpiEntities.add(kpiEntity);
        }
        if (kpiEntities == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        for (KpiEntity kpiEntity : kpiEntities) {
            if (kpiEntity.getPaperId() != null) continue;
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e3a\u7a7a");
        }
        try {
            baseJson = this.kpiInterface.saveKpi(kpiEntities, "3039238394131487336");
        }
        catch (RuntimeException e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return baseJson;
    }

    @RequestMapping(value={"/deleteKpi"})
    public BaseJsonVo deleteKpi(String kpiId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.kpiInterface.deleteKpi(kpiId);
    }

    @RequestMapping(value={"/BuildKpiId"})
    public BaseJsonVo BuildKpiId(String paperId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (!Integer.valueOf(1).equals(userEntity.getIsFinancialAdmin())) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6743\u9650\u6dfb\u52a0\u76ee\u6807\u4ef7\u503c");
        }
        return this.kpiInterface.BuildKpiId(paperId, userEntity.getUserId());
    }

    @RequestMapping(value={"/getMonthKpi"})
    public BaseJsonVo getMonthKpi() throws AuthorizeException {
        List v = this.kpiInterface.getMonthKpi(61, "3296352363991805352");
        return BaseJsonVo.success((Object)v);
    }

    @RequestMapping(value={"/getKpiMonthRanking"})
    public BaseJsonVo getKpiMonthRanking(Integer year, Integer month) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.kpiInterface.getKpiMonthRanking(year, month, userEntity.getUserId());
    }

    @RequestMapping(value={"/getKpiMonthsTotal"})
    public BaseJsonVo getKpiMonthsTotal() throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return BaseJsonVo.success((Object)this.kpiInterface.getKpiMonthsTotal(userEntity.getUserId(), Integer.valueOf(10)));
    }

    @RequestMapping(value={"/getKpiRankingForErp"})
    public BaseJsonVo getKpiRankingForErp(String date, String userMail) throws AuthorizeException {
        return this.kpiInterface.getKpiRankingForErp(date, userMail);
    }

    @RequestMapping(value={"importKpi"}, method={RequestMethod.POST})
    public BaseJsonVo importKpi(@RequestParam(value="file") MultipartFile file) throws IOException, AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        userEntity = (MallUserEntity)this.userInterface.selectByPrimaryKey((Serializable)((Object)userEntity.getUserId()), 0L);
        if (!Integer.valueOf(1).equals(userEntity.getIsFinancialAdmin())) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6743\u9650\u4e0a\u4f20");
        }
        return this.kpiInterface.importKpi(file, userEntity.getUserId());
    }

    @RequestMapping(value={"importOkr"}, method={RequestMethod.POST})
    public BaseJsonVo importOkr(@RequestParam(value="file") MultipartFile file) throws IOException, AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        userEntity = (MallUserEntity)this.userInterface.selectByPrimaryKey((Serializable)((Object)userEntity.getUserId()), 0L);
        if (!Integer.valueOf(1).equals(userEntity.getIsFinancialAdmin())) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6743\u9650\u4e0a\u4f20");
        }
        return this.kpiInterface.importOkr(file, userEntity.getUserId());
    }

    @RequestMapping(value={"saveKpiRemark"})
    public BaseJsonVo saveKpiRemark(String paperId, Integer classId, Integer month, String remark) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.kpiInterface.saveKpiRemark(paperId, classId, month, remark, userEntity.getUserId());
    }

    @RequestMapping(value={"updateFinishFlag"})
    public BaseJsonVo updateFinishFlag(String Id2) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.kpiInterface.updateFinishFlag(Id2, userEntity.getUserId());
    }
}

