/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.quartz;

import cc.lechun.active.form.quartz.QuartzAddForm;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.quartz.QuartzJobGroupEnum;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.quartz.QuartzInterface;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/quartz"})
public class QuartzController
extends BaseController {
    @Autowired
    private QuartzInterface quartzInterface;

    @RequestMapping(value={"/getQuartzList"})
    @ResponseBody
    public PageInfo getQuartzList(PageForm pageForm, String job_name, String job_group) {
        return this.quartzInterface.getQrtzTriggers(pageForm.getCurrentPage(), pageForm.getPageSize(), job_name, job_group);
    }

    @RequestMapping(value={"/getQuartzJobGroupList"})
    @ResponseBody
    public List<QuartzJobGroupEnum> getQuartzJobGroupList() {
        return QuartzJobGroupEnum.getList();
    }

    @RequestMapping(value={"/addQuartzJob"})
    @ResponseBody
    public BaseJsonVo addQuartzJob(QuartzAddForm quartzAddForm) {
        boolean flag;
        if (StringUtils.isEmpty((String)quartzAddForm.getCronExpression())) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)quartzAddForm.getJob_group())) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)quartzAddForm.getJob_name())) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)quartzAddForm.getJobClass().trim())) {
            if (StringUtils.isEmpty((String)quartzAddForm.getSpringBean().trim())) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u662f\u666e\u901a\u4efb\u52a1 \u8fd8\u662f\u81ea\u5b9a\u4e49\u4efb\u52a1");
            }
            flag = this.quartzInterface.addQuartz4Spring(quartzAddForm.getJob_name(), QuartzJobGroupEnum.getQuartzJobGroupEnum((String)quartzAddForm.getJob_group()), quartzAddForm.getDescription(), quartzAddForm.getCronExpression(), quartzAddForm.getSpringBean());
        } else {
            flag = this.quartzInterface.addQuartz4JobClass(quartzAddForm.getJob_name(), QuartzJobGroupEnum.getQuartzJobGroupEnum((String)quartzAddForm.getJob_group()), quartzAddForm.getJobClass(), quartzAddForm.getDescription(), quartzAddForm.getCronExpression());
        }
        if (flag) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u6dfb\u52a0\u5931\u8d25");
    }

    @RequestMapping(value={"/pauseJob"})
    @ResponseBody
    public BaseJsonVo pauseJob(String job_name, String job_group) {
        if (StringUtils.isEmpty((String)job_name)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)job_group)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.quartzInterface.pauseJob(job_name, job_group);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/resumeJob"})
    @ResponseBody
    public BaseJsonVo resumeJob(String job_name, String job_group) {
        if (StringUtils.isEmpty((String)job_name)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)job_group)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.quartzInterface.resumeJob(job_name, job_group);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/deleteJob"})
    @ResponseBody
    public BaseJsonVo deleteJob(String job_name, String job_group) {
        if (StringUtils.isEmpty((String)job_name)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)job_group)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.quartzInterface.deleteJob(job_name, job_group);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/executeOneceJob"})
    @ResponseBody
    public BaseJsonVo executeOneceJob(String job_name, String job_group) {
        if (StringUtils.isEmpty((String)job_name)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)job_group)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.quartzInterface.executeOneceJob(job_name, job_group);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/modifyJobTime"})
    @ResponseBody
    public BaseJsonVo modifyJobTime(String job_name, String job_group, String cron) {
        if (StringUtils.isEmpty((String)job_name)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)job_group)) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)cron)) {
            return BaseJsonVo.error((String)"Cron\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.quartzInterface.modifyJobTime(job_name, job_group, cron);
    }
}

