/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.MallDeliverConfigDetailVo;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigDetailInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/promotion"})
public class MallPromotionController
extends BaseController {
    @Autowired
    private MallPromotionProductInterface promotionProductService;
    @Autowired
    private MallPromotionBuyInterface promotionBuyService;
    @Autowired
    private MallPromotionTimeInterface promotionTimeService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallDeliverConfigDetailInterface configDetailInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    DistributorItemInterface distributorItemInterface;

    @RequestMapping(value={"setOnlineOrOffLine"})
    public BaseJsonVo setOnlineOrOffLine(String promotionId) throws AuthorizeException {
        BaseJsonVo js = this.promotionService.setOnlineOrOffLine(promotionId);
        if (js.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(promotionId, Integer.valueOf(1));
        }
        return js;
    }

    @RequestMapping(value={"promotionList"})
    public PageInfo promotionList(PageForm pageForm, MallPromotionEntity mallPromotionEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.promotionService.getPromotionList(pageForm.getCurrentPage(), pageForm.getPageSize(), mallPromotionEntity, user.getPlatformGroupId());
    }

    @RequestMapping(value={"getPromotion"})
    public BaseJsonVo getPromotion(String promotionId) throws AuthorizeException {
        Integer[] activeTypes = null;
        Object map = new HashedMap();
        List selectDataVos = this.activeInterface.getOptionActiveList(this.getUser().getPlatformGroupId(), activeTypes);
        if (StringUtils.isNotEmpty((String)promotionId)) {
            MallPromotionEntity entity = this.promotionService.getPromotion(promotionId);
            if (entity != null) {
                MallPromotionTimeEntity timeEntity = this.promotionTimeService.getSingleEntity(promotionId);
                map = ObjectConvert.objectConvertToObjectMap((Object)entity);
                if (timeEntity != null && timeEntity.getLimitCount() != null) {
                    map.put("limitCount", String.valueOf(timeEntity.getLimitCount()));
                } else {
                    map.put("limitCount", "0");
                }
                map.put("activeData", selectDataVos);
                return BaseJsonVo.success((Object)map);
            }
            return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        map.put("limitCount", "0");
        map.put("activeData", selectDataVos);
        return BaseJsonVo.success((Object)map);
    }

    @RequestMapping(value={"addPromotion"})
    @ResponseBody
    public BaseJsonVo addPromotion(MallPromotionEntity mallPromotionEntity, Integer limitCount) throws AuthorizeException {
        mallPromotionEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        BaseJsonVo sr = this.promotionService.addPromotion(mallPromotionEntity, limitCount.intValue());
        if (sr.isSuccess()) {
            MallPromotionEntity promotionEntity = (MallPromotionEntity)sr.getValue();
            if (promotionEntity != null) {
                this.distributorItemInterface.initDistributorItem(promotionEntity.getPromotionId(), Integer.valueOf(1));
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"changePromotion"})
    public BaseJsonVo changePromotion(String promotionId) {
        if (this.prepayCardBatchInterface.promotionIsUsed(promotionId).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u4fc3\u9500\u5df2\u88ab\u6c34\u725b\u5976\u5361\u5173\u8054\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BaseJsonVo sr = this.promotionService.changePromotion(promotionId);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(promotionId, Integer.valueOf(1));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delPromotion"})
    public BaseJsonVo delPromotion(MallPromotionEntity mallPromotionEntity) {
        if (this.prepayCardBatchInterface.promotionIsUsed(mallPromotionEntity.getPromotionId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u4fc3\u9500\u5df2\u88ab\u6c34\u725b\u5976\u5361\u5173\u8054\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BaseJsonVo sr = this.promotionService.delPromotion(mallPromotionEntity.getPromotionId());
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallPromotionEntity.getPromotionId(), Integer.valueOf(1));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"clearPromotionBuy"})
    public BaseJsonVo clearPromotionBuy(String promotionId) {
        BaseJsonVo sr = this.promotionBuyService.clearPromotionBuy(promotionId);
        if (sr.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getPromotionProduct"})
    public BaseJsonVo getPromotionProduct(String promotionId) {
        this.promotionProductService.removeCache(promotionId);
        MallPromotionProductEntity promotionProduct = this.promotionProductService.getPromotionProductEntity(promotionId);
        if (promotionProduct != null) {
            return BaseJsonVo.success((Object)promotionProduct);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"addPromotionProduct"})
    @ResponseBody
    public BaseJsonVo addPromotionProduct(MallPromotionProductEntity mallPromotionProductEntity) {
        MallPromotionProductEntity promotionProduct;
        if (mallPromotionProductEntity != null && StringUtils.isNotEmpty((String)mallPromotionProductEntity.getPromotionProductId()) && (promotionProduct = this.promotionProductInterface.getPromotionProduct(mallPromotionProductEntity.getPromotionProductId())).getPromotionPrice().compareTo(mallPromotionProductEntity.getPromotionPrice()) != 0 && this.prepayCardBatchInterface.promotionIsUsed(mallPromotionProductEntity.getPromotionId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u4fc3\u9500\u5df2\u88ab\u6c34\u725b\u5976\u5361\u5173\u8054\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BaseJsonVo sr = this.promotionService.addPromotionProduct(mallPromotionProductEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallPromotionProductEntity.getPromotionId(), Integer.valueOf(1));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getDeliverConfig"})
    public BaseJsonVo getDeliverConfig(String promotionId) {
        List configDetailVos = this.configDetailInterface.getDeliverConfig(promotionId);
        int transportType = this.promotionProductService.getTransportType(promotionId);
        return BaseJsonVo.success((Object)configDetailVos);
    }

    @RequestMapping(value={"saveDeliverConfig"})
    public BaseJsonVo saveDeliverConfig(MallDeliverConfigDetailVo detailVo) throws AuthorizeException {
        return this.configDetailInterface.saveDeliverConfig(detailVo, this.getUser().getUserId());
    }

    @RequestMapping(value={"getPromotionTransportType"})
    public BaseJsonVo getTransportType(String promotionId) {
        int transportType = this.promotionProductService.getTransportType(promotionId);
        return BaseJsonVo.success((Object)transportType);
    }

    @RequestMapping(value={"getPromotionOrder"})
    public BaseJsonVo getPromotionOrder(String promotionId, String start, String end) {
        return BaseJsonVo.success((Object)this.promotionService.getPromotionOrder(promotionId, start, end));
    }

    @RequestMapping(value={"getActivePromotions"})
    public BaseJsonVo getActivePromotions(String bindCode) {
        return BaseJsonVo.success((Object)this.promotionService.getActivePromotions(bindCode));
    }

    @RequestMapping(value={"getActivePromotionsByActiveType"})
    public BaseJsonVo getActivePromotionsByActiveType(Integer activeType) {
        return BaseJsonVo.success((Object)this.promotionService.getActivePromotionsByActiveType(activeType));
    }
}

