/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.shortlink;

import cc.lechun.active.entity.active.MallUrlQueryVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.shortlink.ShortLinkInterface;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shortlink"})
public class ShortLinkController
extends BaseController {
    @Autowired
    private ShortLinkInterface shortLinkService;

    @RequestMapping(value={"/getShortLinkList"})
    public BaseJsonVo getShortLinkList(MallUrlQueryVo mallUrlQueryVo) throws AuthorizeException, IOException {
        return BaseJsonVo.success((Object)this.shortLinkService.getShortLinkList(mallUrlQueryVo));
    }

    @RequestMapping(value={"/getLinkList"})
    public void getLinkList(HttpServletRequest request, HttpServletResponse response, String link) throws AuthorizeException, IOException {
        String shortLink = this.shortLinkService.getShorterUrl(link = link.replace("/", ""));
        response.sendRedirect(StringUtils.isNotEmpty((String)shortLink) ? shortLink : "https://wx.lechun.cc");
    }

    @RequestMapping(value={"/getLink"})
    public void getLink(HttpServletRequest request, HttpServletResponse response, String link) throws AuthorizeException, IOException {
        String shortLink = this.shortLinkService.getShorterUrl(link = link.replace("/", ""));
        response.sendRedirect(StringUtils.isNotEmpty((String)shortLink) ? shortLink : "https://wx.lechun.cc");
    }

    @RequestMapping(value={"/getShortLink"})
    public BaseJsonVo getShortLink(String link) throws AuthorizeException, IOException {
        link = link.replace("/", "");
        return BaseJsonVo.success((Object)this.shortLinkService.getShorterUrl(link));
    }

    @RequestMapping(value={"/delete"})
    public BaseJsonVo delete(String key) throws AuthorizeException, IOException {
        return BaseJsonVo.success((Object)this.shortLinkService.delete(key));
    }

    @RequestMapping(value={"/getLongLink"})
    public String getLongLink(String shortKey) throws AuthorizeException, IOException {
        shortKey = shortKey.replace("/", "");
        return this.shortLinkService.getMallUrl(shortKey);
    }
}

