/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.api;

import cc.lechun.customers.api.CustomerApi;
import cc.lechun.customers.dto.customer.AddressForm;
import cc.lechun.customers.dto.customer.AreaCityProvinceResVo;
import cc.lechun.customers.dto.customer.CustomerDetailDTO;
import cc.lechun.customers.dto.customer.CustomerQueryVo;
import cc.lechun.customers.entity.customer.CustomerAddressEntity;
import cc.lechun.customers.entity.customer.CustomerEntity;
import cc.lechun.customers.entity.customer.CustomerQwEntity;
import cc.lechun.customers.iservice.customer.CustomerAddressInterface;
import cc.lechun.customers.iservice.customer.CustomerInterface;
import cc.lechun.customers.iservice.customer.CustomerOpenIdInterface;
import cc.lechun.customers.iservice.customer.CustomerQwInterface;
import cc.lechun.customers.iservice.vip.MallVipInterface;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerApiImpl
implements CustomerApi {
    @Autowired
    private CustomerInterface customerInterface;
    @Resource
    private MallVipInterface mallVipInterface;
    @Autowired
    private CustomerOpenIdInterface customerOpenIdInterface;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private CustomerQwInterface customerQwInterface;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseJsonVo<CustomerDetailDTO> getCustomerDetailVo(String customerId, Integer platformId) {
        return BaseJsonVo.success((Object)this.customerInterface.getCustomerDetailVo(customerId, platformId));
    }

    public BaseJsonVo<CustomerDetailDTO> getCustomerDetailVoByOpenId(String openId) {
        return BaseJsonVo.success((Object)this.customerInterface.getCustomerDetailByOpenid(openId));
    }

    public BaseJsonVo getCustomerList(CustomerQueryVo customerQueryVo) {
        if (StringUtils.isEmpty((String)customerQueryVo.getOpenId())) {
            customerQueryVo.setOpenId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getCustomerId())) {
            customerQueryVo.setCustomerId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getMobile())) {
            customerQueryVo.setMobile(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getNickName())) {
            customerQueryVo.setNickName(null);
        }
        return BaseJsonVo.success((Object)this.customerInterface.getCustomerList(customerQueryVo));
    }

    public BaseJsonVo getCustomerInfo(String customerId) {
        HashedMap map = new HashedMap();
        map.put("custmerInfo", this.customerInterface.getCustomer(customerId));
        map.put("centerInfo", this.mallVipInterface.centerInfo(customerId));
        map.put("openIdList", this.customerOpenIdInterface.getCustomerOpenidList(customerId));
        return BaseJsonVo.success((Object)map);
    }

    public BaseJsonVo getCustomerAddressList(String customerId) {
        HashedMap map = new HashedMap();
        map.put("addressList", this.customerAddressInterface.getValidCustomerAddressList(customerId, "", -1));
        map.put("addressType", this.customerAddressInterface.getAddressType());
        return BaseJsonVo.success((Object)map);
    }

    public BaseJsonVo getProvinceCityAreaByErp(Integer transportType, Integer isLongPeriodBuy) {
        return BaseJsonVo.success((Object)this.customerAddressInterface.getProvinceCityAreaByErp(transportType, isLongPeriodBuy));
    }

    public BaseJsonVo saveMobile(String customerId, String mobile) {
        return BaseJsonVo.success((Object)this.customerInterface.saveMobile(mobile, customerId));
    }

    public BaseJsonVo updateVipLevel(String customerId, Integer level) {
        this.mallVipInterface.updateVipLevel(customerId, level);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo deleteUserVipInfoCache(String customerId) {
        this.mallVipInterface.deleteUserVipInfoCache(customerId);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo addAddress(AddressForm addressForm) {
        return this.customerAddressInterface.saveCustomerAddress(addressForm);
    }

    public BaseJsonVo updateAddress(AddressForm addressForm) {
        return this.customerAddressInterface.saveCustomerAddress(addressForm);
    }

    public BaseJsonVo deleteCustomerAddress(String customerId, String addrId) {
        return this.customerAddressInterface.deleteCustomerAddress(customerId, addrId);
    }

    public BaseJsonVo getCustomerAddress(String customerId, String addrId) {
        CustomerAddressEntity add = this.customerAddressInterface.getCustomerAddress(addrId);
        if (add == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (!add.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u5730\u5740");
        }
        return BaseJsonVo.success((Object)add);
    }

    public BaseJsonVo<AreaCityProvinceResVo> getAddressByParam(String addrId) {
        this.logger.info("===========getAddressByParam======addrId={}", (Object)addrId);
        AreaCityProvinceResVo areaCityProvince = this.customerAddressInterface.getAddressByParam(Integer.valueOf(addrId).intValue());
        return BaseJsonVo.success((Object)areaCityProvince);
    }

    public BaseJsonVo getCustomerInfoWithQw(CustomerQueryVo customerQueryVo) {
        String customerId;
        if (StringUtils.isEmpty((String)customerQueryVo.getOpenId())) {
            customerQueryVo.setOpenId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getCustomerId())) {
            customerQueryVo.setCustomerId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getMobile())) {
            customerQueryVo.setMobile(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getNickName())) {
            customerQueryVo.setNickName(null);
        }
        if (StringUtils.isEmpty((String)(customerId = this.customerOpenIdInterface.getCustomerId(customerQueryVo.getOpenId())))) {
            HashedMap map = new HashedMap();
            map.put("customerId", "");
            map.put("mobile", "");
            map.put("openId", customerQueryVo.getOpenId());
            map.put("nickName", "");
            return BaseJsonVo.success((Object)map);
        }
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
        if (customerEntity == null) {
            HashedMap map = new HashedMap();
            map.put("customerId", "");
            map.put("mobile", "");
            map.put("openId", customerQueryVo.getOpenId());
            map.put("nickName", "");
            return BaseJsonVo.success((Object)map);
        }
        HashedMap map = new HashedMap();
        map.put("customerId", customerEntity.getCustomerId());
        map.put("mobile", customerEntity.getMobile());
        map.put("openId", customerQueryVo.getOpenId());
        map.put("nickName", customerEntity.getNickName());
        map.put("isLogin", 0);
        map.put("isDelMe", 1);
        List contacts = this.customerQwInterface.getCustomerContacts(customerId);
        if (contacts.size() > 0) {
            if (StringUtils.isNotEmpty((String)customerQueryVo.getQyuserId())) {
                map.put("isLogin", 1);
                List qwEntities = contacts.stream().filter(c -> customerQueryVo.getQyuserId().equals(c.getQyWeixinUserid())).collect(Collectors.toList());
                if (qwEntities.size() > 0) {
                    map.put("defineName", ((CustomerQwEntity)qwEntities.get(0)).getDefineName());
                    if (Integer.valueOf(2).equals(((CustomerQwEntity)qwEntities.get(0)).getSaveSucc())) {
                        map.put("isDelMe", 2);
                    } else if (Integer.valueOf(10).equals(((CustomerQwEntity)qwEntities.get(0)).getDefineStatus()) || Integer.valueOf(20).equals(((CustomerQwEntity)qwEntities.get(0)).getDefineStatus())) {
                        map.put("isDelMe", ((CustomerQwEntity)qwEntities.get(0)).getDefineStatus());
                    }
                } else {
                    map.put("defineName", "");
                }
            } else {
                map.put("defineName", "");
            }
        } else {
            map.put("defineName", "");
        }
        return BaseJsonVo.success((Object)map);
    }

    public BaseJsonVo getCustomerQwTag(String customerId) {
        List tags = this.customerQwInterface.getCustomerTags(customerId);
        List contacts = this.customerQwInterface.getCustomerContacts(customerId);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("tags", tags);
        map.put("contacts", contacts);
        return BaseJsonVo.success(map);
    }
}

