/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.api;

import cc.lechun.customers.api.CustomerBalanceApi;
import cc.lechun.customers.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.customers.apiinvoke.mall.PrepayOrderPlanInvoke;
import cc.lechun.customers.dto.balance.PrepayCardDetailQueryVo;
import cc.lechun.customers.dto.balance.PrepayCardQueryVo;
import cc.lechun.customers.dto.balance.PrepayCardVo;
import cc.lechun.customers.entity.prepay.PrepayCardEntity;
import cc.lechun.customers.iservice.prepay.PrepayCardInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardQueryInterface;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerBalanceApiImpl
implements CustomerBalanceApi {
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    PrepayCardQueryInterface prepayCardQueryInterface;
    @Autowired
    PrepayCardInterface prepayCardService;
    @Autowired
    private PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;
    @Autowired
    PrepayOrderPlanInvoke prepayOrderPlanInvoke;

    public BaseJsonVo getTotalBalance(String customerId) {
        return this.balanceAccountInvoke.getUserBalance(customerId);
    }

    public BaseJsonVo getUserBalanceDetail(String customerId) {
        return this.balanceAccountInvoke.getUserBalanceDetail(customerId);
    }

    public BaseJsonVo increaseManual(String customerId, BigDecimal increaseAmount, String detailSubTypeDesc) {
        return this.balanceAccountInvoke.increaseManual(customerId, increaseAmount, "", detailSubTypeDesc);
    }

    public BaseJsonVo reduceManual(String customerId, BigDecimal reduceAmount, String detailSubTypeDesc) {
        return this.balanceAccountInvoke.reduceManual(customerId, reduceAmount, "", detailSubTypeDesc);
    }

    public BaseJsonVo getPrepayCardVoList(PrepayCardQueryVo prepayCardQueryVo) {
        return BaseJsonVo.success((Object)this.prepayCardQueryInterface.getPrepayCardVoList(prepayCardQueryVo));
    }

    public BaseJsonVo getPrepayCardDetailVoList(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        prepayCardDetailQueryVo.setEndDate(prepayCardDetailQueryVo.getEnd());
        prepayCardDetailQueryVo.setStartDate(prepayCardDetailQueryVo.getStart());
        return BaseJsonVo.success((Object)this.prepayCardPlanDetailInterface.getPrepayCardDetailVoList(prepayCardDetailQueryVo));
    }

    public BaseJsonVo getCardPlanDetail(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        return this.prepayOrderPlanInvoke.getCardPlanDetail(prepayCardDetailQueryVo.getCardId());
    }

    public BaseJsonVo disabledCard(String cardId) {
        return this.prepayCardQueryInterface.disabledCard(cardId);
    }

    public BaseJsonVo disabledCardByCardOrderMainNo(String orderMainNo) {
        PrepayCardEntity param = new PrepayCardEntity();
        param.setOrderMainNo(orderMainNo);
        List list = this.prepayCardService.getList((Object)param);
        if (list != null && list.size() > 0) {
            list.forEach(prepayCardEntity -> this.prepayCardQueryInterface.disabledCard(prepayCardEntity.getCardId()));
        }
        return BaseJsonVo.success((String)"\u64cd\u4f5c\u5b8c\u6210", null);
    }

    public BaseJsonVo cancelPlan(Integer detailedId) {
        return this.prepayCardPlanDetailInterface.cancelPlan(detailedId);
    }

    public BaseJsonVo setCardExpireTime(PrepayCardVo prepayCardVo) {
        return BaseJsonVo.success((Object)this.prepayCardQueryInterface.setCardExpireTime(prepayCardVo));
    }
}

