/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.cashticket;

import cc.lechun.cms.dto.ActiveDTO;
import cc.lechun.customers.apiinvoke.cms.ActiveInvoke;
import cc.lechun.customers.apiinvoke.mall.CouponInvoke;
import cc.lechun.customers.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.customers.entity.cashticket.CashticketBatchEntity;
import cc.lechun.customers.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.customers.entity.cashticket.CashticketCustomerRecordVo;
import cc.lechun.customers.entity.cashticket.CashticketEntity;
import cc.lechun.customers.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.customers.service.cashticket.CashticketBatchService;
import cc.lechun.customers.service.cashticket.CashticketService;
import cc.lechun.framework.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketCustomerService
extends BaseService<CashticketCustomerEntity, Integer>
implements CashticketCustomerInterface {
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private CouponInvoke couponInvoke;
    @Autowired
    private ActiveInvoke activeInvoke;

    public Page<CashticketCustomerEntity> getCustomerCashticketList(String customerId, Integer pageSize, Integer pageCount) {
        Page page = PageHelper.startPage((int)pageCount, (int)pageSize);
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
        cashticketCustomerEntity.setCustomerId(customerId);
        this.cashticketCustomerMapper.getList((Object)cashticketCustomerEntity);
        return page;
    }

    public PageInfo<CashticketCustomerRecordVo> getCustomerCashticketList(String ticketBatchId, String start, String end, String customerId, Integer status, Integer pageSize, Integer pageCount) {
        Page page = PageHelper.startPage((int)pageCount, (int)pageSize);
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        List tempList = this.cashticketCustomerMapper.getCustomerCashList(customerId, start, end, ticketBatchId, status);
        PageInfo pg = page.toPageInfo();
        ArrayList list = new ArrayList();
        tempList.forEach(o -> {
            if (StringUtils.isEmpty((String)o.getTicketBatchId())) {
                return;
            }
            CashticketCustomerRecordVo c = new CashticketCustomerRecordVo();
            BeanUtils.copyProperties((Object)o, (Object)c);
            CashticketEntity cashticketEntity = this.cashticketService.getCashticket(o.getTicketId().intValue());
            if (cashticketEntity != null) {
                BeanUtils.copyProperties((Object)cashticketEntity, (Object)c);
            }
            if (o.getEndTime() != null && o.getEndTime().before(DateUtils.now()) && o.getStatus() == 1) {
                c.setStatus(Integer.valueOf(3));
            }
            c.setEndTime(o.getEndTime());
            c.setBeginTime(o.getBeginTime());
            this.logger.info("{},{}", (Object)cashticketEntity, (Object)c);
            CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(o.getTicketBatchId());
            if (cashticketBatchEntity != null) {
                c.setAmountMin(cashticketBatchEntity.getMinUseamount());
                c.setUsedRule(StringUtils.isNotEmpty((String)cashticketBatchEntity.getRemark()) ? cashticketBatchEntity.getRemark() : "");
                if (cashticketBatchEntity.getStatus().intValue() == CashStatusEnum.jinyong.getValue() && c.getStatus().intValue() == CashStatusEnum.yijihuo.getValue()) {
                    c.setStatus(Integer.valueOf(CashStatusEnum.jinyong.getValue()));
                }
                if (cashticketBatchEntity.getMinUseamount() != null && cashticketBatchEntity.getMinUseamount().compareTo(BigDecimal.ZERO) > 0) {
                    c.setRuleDesc("\u6ee1" + cashticketBatchEntity.getMinUseamount() + "\u51cf\u53ef\u7528");
                } else {
                    c.setRuleDesc("\u65e0\u95e8\u69db");
                }
            }
            c.setCashStatusName(CashStatusEnum.getName((Integer)c.getStatus()));
            if (StringUtils.isNotEmpty((String)o.getBindCode()) && StringUtils.isNotEmpty((String)o.getBindCode())) {
                ActiveDTO activeEntity = (ActiveDTO)this.activeInvoke.getActiveEntityByQrcode(o.getBindCode()).getValue();
                c.setSourceActiveNo(activeEntity == null ? "" : activeEntity.getActiveName());
            }
            list.add(c);
        });
        pg.setList(list);
        return pg;
    }
}

