/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.cashticket;

import cc.lechun.customers.dao.cashticket.CashticketMapper;
import cc.lechun.customers.entity.cashticket.CashticketEntity;
import cc.lechun.customers.iservice.cashticket.CashticketInterface;
import cc.lechun.framework.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketService
extends BaseService<CashticketEntity, Integer>
implements CashticketInterface {
    @Resource
    private CashticketMapper cashticketMapper;
    @Autowired
    private MemcachedService memcachedService;

    public CashticketEntity getCashticket(int ticketId) {
        return (CashticketEntity)this.cashticketMapper.selectByPrimaryKey((Serializable)Integer.valueOf(ticketId));
    }

    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = new CashticketEntity()) != null) {
            cashticketEntity.setTicketId(Integer.valueOf(ticketId));
            cashticketEntity.setStatus(Integer.valueOf(cashStatusEnum.getValue()));
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(Integer.valueOf(1));
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                cashticketEntity.setLaststatus(Integer.valueOf(CashStatusEnum.yijihuo.getValue()));
            }
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (this.cashticketMapper.updateByPrimaryKeySelective((Object)cashticketEntity) > 0) {
                return true;
            }
        }
        return false;
    }
}

