/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.customer;

import cc.lechun.customers.dao.customer.CustomerAddressMapper;
import cc.lechun.customers.dto.customer.AddressForm;
import cc.lechun.customers.dto.customer.AreaCityProvinceResVo;
import cc.lechun.customers.entity.area.AreaCityProvinceVo;
import cc.lechun.customers.entity.area.MallAreaEntity;
import cc.lechun.customers.entity.area.SysProvinceCityAreaVo;
import cc.lechun.customers.entity.customer.CustomerAddressEntity;
import cc.lechun.customers.entity.customer.CustomerAddressVo;
import cc.lechun.customers.iservice.customer.CustomerAddressInterface;
import cc.lechun.framework.common.enums.customer.CustomerAddressTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerAddressService
extends BaseService<CustomerAddressEntity, String>
implements CustomerAddressInterface {
    @Resource
    private CustomerAddressMapper customerAddressMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Value(value="${erp.provinceAreaList.url}")
    private String provinceAreaListUrl;
    @Value(value="${erp.getArea.url}")
    private String getAreaUrl;

    public List<CustomerAddressVo> getValidCustomerAddressList(String customerId, String addressId, int transportType) {
        List addressList = this.getValidCustomerAddressList(customerId);
        if (addressId != null && !addressId.isEmpty()) {
            addressList = addressList.stream().filter(c -> c.getAddrId().equals(addressId)).collect(Collectors.toList());
        }
        ArrayList<CustomerAddressVo> customerAddressVos = new ArrayList<CustomerAddressVo>();
        for (CustomerAddressEntity e : addressList) {
            CustomerAddressVo customerAddressVo = new CustomerAddressVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)e, (Object)customerAddressVo);
                customerAddressVo.setSpeedUp("0");
            }
            catch (Exception e1) {
                this.logger.error("\u83b7\u53d6\u5730\u5740\u5217\u8868\u65f6\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e1);
            }
            List mallAreaEntityList = this.getAreaErp(null, String.valueOf(e.getAreaId()), null);
            if (mallAreaEntityList != null && mallAreaEntityList.size() > 0) {
                for (MallAreaEntity mallAreaEntity : mallAreaEntityList) {
                    int status = mallAreaEntity.getStatus();
                    int nomalStatus = mallAreaEntity.getOrdinaryStatus();
                    customerAddressVo.setEnable(true);
                    if (transportType == 1) {
                        if (status == 1) {
                            customerAddressVo.setEnable(true);
                        } else {
                            customerAddressVo.setEnable(false);
                        }
                    }
                    if (transportType != 2) continue;
                    if (nomalStatus == 1) {
                        customerAddressVo.setEnable(true);
                        continue;
                    }
                    customerAddressVo.setEnable(false);
                }
            } else {
                customerAddressVo.setEnable(false);
            }
            customerAddressVos.add(customerAddressVo);
        }
        return customerAddressVos;
    }

    public List<CustomerAddressEntity> getValidCustomerAddressList(String customerId) {
        CustomerAddressEntity addressEntity = new CustomerAddressEntity();
        addressEntity.setCustomerId(customerId);
        addressEntity.setIsDelete(Short.valueOf((short)0));
        return this.getList((Object)addressEntity, 0L).stream().sorted(Comparator.comparing(CustomerAddressEntity::getLastTime).reversed()).collect(Collectors.toList());
    }

    private List<MallAreaEntity> getAreaErp(String cityId, String areaId, String areaName) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("cityId", cityId);
        mapParam.put("areaId", areaId);
        mapParam.put("areaName", areaName);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.getAreaUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        this.logger.info("*************************getAreaErp********************\u8c03\u7528ERP3.0\u83b7\u53d6areaList\u4f20\u9012\u548c\u8fd4\u56de\u7684\u53c2\u6570*************mapParam={},result={}", (Object)JSON.toJSONString(mapParam), (Object)result);
        if (StringUtils.isNotEmpty((String)result)) {
            JSONObject jsonObject = JSON.parseObject((String)result);
            int status = (Integer)jsonObject.get((Object)"status");
            if (status == 200) {
                boolean success = (Boolean)jsonObject.get((Object)"success");
                if (success) {
                    ArrayList<MallAreaEntity> mallAreaEntityArrayList = new ArrayList<MallAreaEntity>();
                    JSONArray jsonArrayCity = (JSONArray)jsonObject.get((Object)"result");
                    for (JSONObject ob : jsonArrayCity) {
                        String code = (String)ob.get((Object)"code");
                        String name = (String)ob.get((Object)"name");
                        String parentcode = (String)ob.get((Object)"parentcode");
                        Integer nomalstatus = ob.getInteger("nomalstatus");
                        Integer coldstatus = ob.getInteger("coldstatus");
                        Integer freshstatus = ob.getInteger("freshstatus");
                        MallAreaEntity mallAreaEntity = new MallAreaEntity();
                        mallAreaEntity.setAreaId(Integer.valueOf(code));
                        mallAreaEntity.setAreaName(name);
                        mallAreaEntity.setCityId(Integer.valueOf(parentcode));
                        mallAreaEntity.setStatus(Integer.valueOf(coldstatus));
                        mallAreaEntity.setOrdinaryStatus(Integer.valueOf(nomalstatus));
                        mallAreaEntityArrayList.add(mallAreaEntity);
                    }
                    return mallAreaEntityArrayList;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public List<CustomerAddressTypeEnum> getAddressType() {
        return CustomerAddressTypeEnum.getList();
    }

    public Map getProvinceCityAreaByErp(Integer transportType, Integer isLongPeriodBuy) {
        List sysProvinceCityAreaVoList = this.getProvinceCityErpThr(transportType, isLongPeriodBuy);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("provinceVoList", sysProvinceCityAreaVoList);
        return map;
    }

    private List<SysProvinceCityAreaVo> getProvinceCityErpThr(Integer transportType, Integer isLongPeriodBuy) {
        boolean success;
        int nomalStatus = 0;
        int coldStatus = 0;
        int freshStatus = 0;
        if (isLongPeriodBuy == 1) {
            coldStatus = 1;
        } else {
            if (transportType == 1 || transportType == 3) {
                coldStatus = 1;
                freshStatus = 1;
            }
            if (transportType == 2) {
                nomalStatus = 1;
            }
            if (transportType == -1) {
                nomalStatus = 1;
                coldStatus = 1;
                freshStatus = 1;
            }
        }
        HashMap<String, Integer> mapParam = new HashMap<String, Integer>();
        mapParam.put("nomalStatus", nomalStatus);
        mapParam.put("coldStatus", coldStatus);
        mapParam.put("freshStatus", freshStatus);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.provinceAreaListUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        JSONObject jsonObject = JSON.parseObject((String)result);
        int status = (Integer)jsonObject.get((Object)"status");
        HashMap map = new HashMap();
        List<Object> sysProvinceCityAreaVoList = new ArrayList<SysProvinceCityAreaVo>();
        if (status == 200 && (success = ((Boolean)jsonObject.get((Object)"success")).booleanValue())) {
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"result");
            sysProvinceCityAreaVoList = JSON.parseArray((String)jsonArray.toJSONString(), SysProvinceCityAreaVo.class);
            sysProvinceCityAreaVoList.sort((o1, o2) -> o1.getProvinceId() - o2.getProvinceId());
        }
        return sysProvinceCityAreaVoList;
    }

    @Transactional
    public BaseJsonVo saveCustomerAddress(AddressForm form) {
        BaseJsonVo vo = this.validateAddress(form);
        if (!vo.isSuccess()) {
            return vo;
        }
        CustomerAddressEntity customerAddressEntity = new CustomerAddressEntity();
        customerAddressEntity.setCustomerId(form.getCustomerId());
        customerAddressEntity.setAddress(form.getAddress());
        customerAddressEntity.setConsigneeName(form.getConsigneename());
        customerAddressEntity.setConsigneePhone(form.getConsingeephone());
        customerAddressEntity.setAddressType(Integer.valueOf(form.getAddresstype()));
        customerAddressEntity.setCreateTime(DateUtils.now());
        customerAddressEntity.setConsigneeTel("");
        customerAddressEntity.setLastTime(DateUtils.now());
        AreaCityProvinceVo areaCityProvince = this.customerAddressMapper.getAreaCityProvinceForAreaId(form.getAreaid());
        customerAddressEntity.setAreaId(Integer.valueOf(form.getAreaid()));
        customerAddressEntity.setAreaName(areaCityProvince.getAreaName());
        customerAddressEntity.setCityId(Integer.valueOf(areaCityProvince.getCityId()));
        customerAddressEntity.setCityName(areaCityProvince.getCityName());
        customerAddressEntity.setProvinceId(Integer.valueOf(areaCityProvince.getProvinceId()));
        customerAddressEntity.setProvinceName(areaCityProvince.getProvinceName());
        if (StringUtils.isEmpty((String)form.getAddrId())) {
            customerAddressEntity.setAddrId(RandomUtils.generateStrId());
            this.insertSelective((Object)customerAddressEntity);
        } else {
            customerAddressEntity.setAddrId(form.getAddrId());
            this.updateByPrimaryKeySelective((Object)customerAddressEntity);
        }
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)customerAddressEntity);
    }

    private void removeCache(String customerId, String addrId) {
        this.memcachedService.delete("getCustomerAddress", addrId);
        this.memcachedService.delete("getValidCustomerAddressList", customerId);
    }

    private BaseJsonVo validateAddress(AddressForm form) {
        if (StringUtils.isEmpty((String)form.getConsingeephone())) {
            return BaseJsonVo.paramError((String)"\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)form.getConsigneename())) {
            return BaseJsonVo.paramError((String)"\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)form.getAddress())) {
            return BaseJsonVo.paramError((String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (form.getAddresstype() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5730\u5740\u7c7b\u578b");
        }
        if (form.getAreaid() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u57ce\u5e02");
        }
        return BaseJsonVo.success(null);
    }

    @Transactional
    public BaseJsonVo deleteCustomerAddress(String customerId, String addrId) {
        CustomerAddressEntity customerAddressEntity = this.getCustomerAddress(addrId);
        if (customerAddressEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (!customerAddressEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u5730\u5740");
        }
        if (Short.valueOf("1").equals(customerAddressEntity.getIsDelete())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u5730\u5740\u5df2\u7ecf\u5220\u9664");
        }
        customerAddressEntity.setIsDelete(Short.valueOf((short)1));
        this.updateByPrimaryKeySelective((Object)customerAddressEntity);
        this.removeCache(customerAddressEntity.getCustomerId(), customerAddressEntity.getAddrId());
        return BaseJsonVo.success((Object)"");
    }

    public CustomerAddressEntity getCustomerAddress(@ParameterValueKeyProvider String addrId) {
        return (CustomerAddressEntity)this.customerAddressMapper.selectByPrimaryKey((Serializable)((Object)addrId));
    }

    public AreaCityProvinceResVo getAddressByParam(int areaid) {
        AreaCityProvinceResVo areaCityProvinceResVo = this.customerAddressMapper.getAddressByParam(areaid);
        return areaCityProvinceResVo;
    }
}

