/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.customer;

import cc.lechun.customers.dao.customer.CustomerMapper;
import cc.lechun.customers.dto.customer.CustomerDetailDTO;
import cc.lechun.customers.dto.customer.CustomerListVo;
import cc.lechun.customers.dto.customer.CustomerQueryVo;
import cc.lechun.customers.entity.customer.CustomerDetailVo;
import cc.lechun.customers.entity.customer.CustomerEntity;
import cc.lechun.customers.entity.customer.CustomerOpenidEntity;
import cc.lechun.customers.iservice.customer.CustomerInterface;
import cc.lechun.customers.iservice.customer.CustomerOnlineInterface;
import cc.lechun.customers.iservice.customer.CustomerOpenIdInterface;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerService
extends BaseService<CustomerEntity, String>
implements CustomerInterface {
    @Autowired
    private CustomerOnlineInterface customerOnlineInterface;
    @Resource
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerOpenIdInterface openIdInterface;

    public CustomerDetailDTO getCustomerDetailVo(String customerId, Integer platformId) {
        CustomerDetailVo customerDetailVo = (CustomerDetailVo)this.listToEntiy(this.customerMapper.getCustomerDetail(customerId, platformId.intValue()));
        CustomerDetailDTO customerDetailDTO = new CustomerDetailDTO();
        if (customerDetailVo != null && StringUtils.isNotEmpty((String)customerDetailVo.getCustomerId())) {
            BeanUtils.copyProperties((Object)customerDetailVo, (Object)customerDetailDTO);
        }
        return customerDetailDTO;
    }

    public CustomerDetailVo getCustomerDetailByOpenid(String openId) {
        return (CustomerDetailVo)this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid2(openId));
    }

    public PageInfo<CustomerListVo> getCustomerList(CustomerQueryVo customerQueryVo) {
        this.logger.info("\u641c\u7d22\u6761\u4ef6:{}", (Object)customerQueryVo.toString());
        ArrayList resultList = new ArrayList();
        if (customerQueryVo.getIsOnLine()) {
            PageInfo cusertomerOnline = this.customerOnlineInterface.getCustomerList(customerQueryVo);
            if (cusertomerOnline == null) {
                return null;
            }
            cusertomerOnline.getList().forEach(c -> {
                CustomerEntity customerEntity = this.getCustomer(c.getCustomerId());
                CustomerListVo customerListVo = new CustomerListVo();
                BeanUtils.copyProperties((Object)customerEntity, (Object)customerListVo);
                customerListVo.setOnLine(customerQueryVo.getIsOnLine());
                customerListVo.setConsultTime(c.getCreateTime());
                customerListVo.setOpenId(customerEntity.getChannelCustomerId());
                resultList.add(customerListVo);
            });
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(resultList);
            pageInfo.setTotal(cusertomerOnline.getTotal());
            return pageInfo;
        }
        CustomerEntity customerEntity = new CustomerEntity();
        if (StringUtils.isNotEmpty((String)customerQueryVo.getMobile())) {
            customerEntity.setMobile(customerQueryVo.getMobile());
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getOpenId())) {
            CustomerOpenidEntity query = new CustomerOpenidEntity();
            query.setOpenId(customerQueryVo.getOpenId());
            CustomerOpenidEntity customerOpenidEntity = (CustomerOpenidEntity)this.openIdInterface.getSingle((Object)query, 0L);
            if (customerOpenidEntity != null) {
                customerEntity.setCustomerId(customerOpenidEntity.getCustomerId());
            } else {
                customerEntity.setChannelCustomerId(customerQueryVo.getOpenId());
            }
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getCustomerId())) {
            customerEntity.setCustomerId(customerQueryVo.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getNickName())) {
            customerEntity.setNickName(SqlUtils.sqlLike((String)customerQueryVo.getNickName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_Suffix));
        }
        customerEntity.setStatus(Integer.valueOf(1));
        if (customerQueryVo.getCurrentPage() == null) {
            customerQueryVo.setCurrentPage(Integer.valueOf(1));
        }
        if (customerQueryVo.getPageSize() == null) {
            customerQueryVo.setPageSize(Integer.valueOf(20));
        }
        Page page = PageHelper.startPage((int)customerQueryVo.getCurrentPage(), (int)customerQueryVo.getPageSize());
        page.setOrderBy("CUSTOMER_ID desc");
        this.logger.info("\u67e5\u8be2\u7528\u6237:{}", (Object)customerEntity.toString());
        super.getList((Object)customerEntity, 0L);
        List list = page.toPageInfo().getList();
        list.forEach(c -> {
            CustomerListVo customerListVo = new CustomerListVo();
            BeanUtils.copyProperties((Object)c, (Object)customerListVo);
            customerListVo.setOnLine(customerQueryVo.getIsOnLine());
            customerListVo.setOpenId(c.getChannelCustomerId());
            customerListVo.setNickName(c.getNickName());
            resultList.add(customerListVo);
        });
        PageInfo pg = page.toPageInfo();
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(pg.getTotal());
        return pg2;
    }

    public CustomerEntity getCustomer(String customerId) {
        return (CustomerEntity)super.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    public List<CustomerEntity> getCustomerByMobile(String mobile, Integer platformGroupId) {
        CustomerEntity search = new CustomerEntity();
        search.setMobile(mobile);
        search.setPlatformGroupId(platformGroupId);
        return this.getList((Object)search).stream().sorted(Comparator.comparing(CustomerEntity::getCreateTime)).collect(Collectors.toList());
    }

    public BaseJsonVo saveMobile(String mobile, String customerId) {
        CustomerEntity customerNew = this.getCustomer(customerId);
        if (customerNew == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7528\u6237");
        }
        String old_mobile = customerNew.getMobile();
        List customer4Mobiles = this.getCustomerByMobile(mobile, customerNew.getPlatformGroupId());
        if (customer4Mobiles != null && customer4Mobiles.size() > 0) {
            return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\uff0c\u8bf7\u66f4\u6362\u4e3a\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        CustomerEntity customer = new CustomerEntity();
        customer.setCustomerId(customerId);
        customer.setMobile(mobile);
        int k = this.updateByPrimaryKeySelective((Object)customer);
        if (k >= 1) {
            return BaseJsonVo.success((Object)"\u624b\u673a\u53f7\u4fee\u6539\u6210\u529f");
        }
        return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
    }

    private <T> T listToEntiy(List<T> ls) {
        if (ls != null && ls.size() > 0) {
            return ls.get(0);
        }
        return null;
    }
}

