/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.prepay;

import cc.lechun.cms.dto.PromotionDTO;
import cc.lechun.customers.apiinvoke.cms.PromotionInvoke;
import cc.lechun.customers.apiinvoke.mall.PrepayOrderPlanInvoke;
import cc.lechun.customers.dao.prepay.PrepayCardPlanDetailMapper;
import cc.lechun.customers.dto.balance.PrepayCardDetailQueryVo;
import cc.lechun.customers.entity.customer.CustomerAddressEntity;
import cc.lechun.customers.entity.prepay.PrepayCardDetailVo;
import cc.lechun.customers.entity.prepay.PrepayCardPlanDetailEntity;
import cc.lechun.customers.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.customers.iservice.customer.CustomerAddressInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardPlanDetailService
extends BaseService<PrepayCardPlanDetailEntity, Integer>
implements PrepayCardPlanDetailInterface {
    @Resource
    private PrepayCardPlanDetailMapper prepayCardPlanDetailMapper;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private PromotionInvoke promotionInvoke;
    @Autowired
    PrepayOrderPlanInvoke prepayOrderPlanInvoke;

    public BaseJsonVo cancelPlan(Integer detailedId) {
        PrepayCardPlanDetailEntity prepayCardPlanDetailEntity = (PrepayCardPlanDetailEntity)this.prepayCardPlanDetailMapper.selectByPrimaryKey((Serializable)detailedId);
        if (prepayCardPlanDetailEntity != null && prepayCardPlanDetailEntity.getDetailedId() != null && prepayCardPlanDetailEntity.getStatus().intValue() != PrepayCardPlanStatusEnum.ACTIVE.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212" + PrepayCardPlanStatusEnum.getName((int)prepayCardPlanDetailEntity.getStatus()) + "\u4e0d\u80fd\u53d6\u6d88"));
        }
        return this.prepayCardPlanDetailMapper.cancelPlan(detailedId.intValue(), prepayCardPlanDetailEntity.getStatus().intValue()) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    public PageInfo<PrepayCardDetailVo> getPrepayCardDetailVoList(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        Page page = PageHelper.startPage((int)prepayCardDetailQueryVo.getCurrentPage(), (int)prepayCardDetailQueryVo.getPageSize());
        if (StringUtils.isNotEmpty((String)prepayCardDetailQueryVo.getOrderBy())) {
            page.setOrderBy(prepayCardDetailQueryVo.getOrderBy());
        }
        if (prepayCardDetailQueryVo.getOrderSource() != null && prepayCardDetailQueryVo.getOrderSource() == 0) {
            prepayCardDetailQueryVo.setOrderSource(null);
        }
        if (StringUtils.isEmpty((String)prepayCardDetailQueryVo.getCardId())) {
            prepayCardDetailQueryVo.setCardId(null);
        }
        this.prepayCardPlanDetailMapper.getListByDate(prepayCardDetailQueryVo);
        List list = page.toPageInfo().getList();
        ArrayList resultList = new ArrayList();
        list.forEach(c -> {
            BaseJsonVo jsonVo;
            PrepayCardDetailVo prepayCardDetailVo = new PrepayCardDetailVo();
            BeanUtils.copyProperties((Object)c, (Object)prepayCardDetailVo);
            prepayCardDetailVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            CustomerAddressEntity customerAddressEntity = this.customerAddressInterface.getCustomerAddress(c.getAddrId());
            BeanUtils.copyProperties((Object)customerAddressEntity, (Object)prepayCardDetailVo);
            prepayCardDetailVo.setStatus(c.getStatus());
            prepayCardDetailVo.setStatusName(PrepayCardPlanStatusEnum.getName((int)c.getStatus()));
            prepayCardDetailVo.setCreateTime(c.getCreateTime());
            if (StringUtils.isNotEmpty((String)c.getPromotionId()) && (jsonVo = this.promotionInvoke.getPromotion(c.getPromotionId())).isSuccess()) {
                prepayCardDetailVo.setPromotionName(jsonVo.getValue() == null ? "" : ((PromotionDTO)jsonVo.getValue()).getPromotionName());
            }
            resultList.add(prepayCardDetailVo);
        });
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(page.getTotal());
        return pg2;
    }

    public BaseJsonVo saveCardPlanAddress(Integer detailedId, String addrId) {
        PrepayCardPlanDetailEntity update = new PrepayCardPlanDetailEntity();
        update.setDetailedId(detailedId);
        update.setAddrId(addrId);
        return this.prepayCardPlanDetailMapper.updateByPrimaryKeySelective((Object)update) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    public BaseJsonVo saveCardPlanPickDate(Integer detailedId, Date pickDate) {
        PrepayCardPlanDetailEntity update = new PrepayCardPlanDetailEntity();
        update.setDetailedId(detailedId);
        update.setPickTime(pickDate);
        return this.prepayCardPlanDetailMapper.updateByPrimaryKeySelective((Object)update) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }
}

