/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.prepay;

import cc.lechun.customers.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.customers.dto.balance.PrepayCardPlanVo;
import cc.lechun.customers.dto.balance.PrepayCardQueryVo;
import cc.lechun.customers.dto.balance.PrepayCardVo;
import cc.lechun.customers.entity.customer.CustomerAddressEntity;
import cc.lechun.customers.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.customers.entity.prepay.PrepayCardEntity;
import cc.lechun.customers.entity.prepay.PrepayCardPlanDetailEntity;
import cc.lechun.customers.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.customers.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.customers.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.customers.iservice.customer.CustomerAddressInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardQueryInterface;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.MallSelectDataVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardQueryService
implements PrepayCardQueryInterface {
    @Autowired
    private PrepayCardInterface prepayCardService;
    @Autowired
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchService;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;

    public BaseJsonVo saveCardPlanPickDate(PrepayCardPlanVo prepayCardPlanVo) {
        PrepayCardEntity prepayCardEntity;
        PrepayCardPlanDetailEntity prepayCardPlanDetailEntity = (PrepayCardPlanDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey((Serializable)prepayCardPlanVo.getDetailedId());
        if (prepayCardPlanDetailEntity == null || prepayCardPlanDetailEntity.getDetailedId() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(prepayCardPlanDetailEntity.getStatus(), PrepayCardPlanStatusEnum.NOEFFECT.getValue()) || Objects.equals(prepayCardPlanDetailEntity.getStatus(), PrepayCardPlanStatusEnum.FINISH.getValue())) {
            return BaseJsonVo.error((String)("\u8ba1\u5212" + PrepayCardPlanStatusEnum.getName((int)prepayCardPlanDetailEntity.getStatus()) + ",\u4e0d\u80fd\u4fee\u6539!"));
        }
        if (StringUtils.isNotEmpty((String)prepayCardPlanDetailEntity.getOrderMainNo())) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u5df2\u751f\u6210\u8ba2\u5355\uff0c\u8bf7oms\u91cc\u4fee\u6539\u8ba2\u5355");
        }
        if (StringUtils.isNotEmpty((String)prepayCardPlanDetailEntity.getCardId()) && (prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardPlanDetailEntity.getCardId()))) == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361");
        }
        prepayCardPlanVo.setPickupDate(DateUtils.getDateFromString((String)prepayCardPlanVo.getPickDate(), (String)"yyyy-MM-dd"));
        if (prepayCardPlanVo.getPickupDate().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u63d0\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        return this.prepayCardPlanDetailService.saveCardPlanPickDate(prepayCardPlanVo.getDetailedId(), prepayCardPlanVo.getPickupDate());
    }

    public BaseJsonVo saveCardPlanAddress(Integer detailedId, String addrId) {
        PrepayCardEntity prepayCardEntity;
        PrepayCardPlanDetailEntity prepayCardPlanDetailEntity = (PrepayCardPlanDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey((Serializable)detailedId);
        if (prepayCardPlanDetailEntity == null || prepayCardPlanDetailEntity.getDetailedId() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)prepayCardPlanDetailEntity.getCardId()) && (prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardPlanDetailEntity.getCardId()))) == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361");
        }
        CustomerAddressEntity customerAddressEntity = this.customerAddressInterface.getCustomerAddress(addrId);
        if (customerAddressEntity == null || customerAddressEntity.getIsDelete() == 1) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5730\u5740\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        return this.prepayCardPlanDetailService.saveCardPlanAddress(detailedId, addrId);
    }

    public BaseJsonVo setCardExpireTime(PrepayCardVo prepayCardVo) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardVo.getCardId()));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361");
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue() && prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)("\u5f53\u524d\u5361" + PrepayCardStatusEnum.getName((int)prepayCardEntity.getStatus()) + "\u4e0d\u80fd\u5ef6\u671f"));
        }
        if (prepayCardEntity.getEndTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u5f53\u524d\u5361\u8fc7\u671f\u65f6\u95f4:" + prepayCardEntity.getEndTime() + "\u65e0\u987b\u5ef6\u671f"));
        }
        PrepayCardEntity update = new PrepayCardEntity();
        update.setCardId(prepayCardVo.getCardId());
        update.setEndTime(prepayCardVo.getEndTime());
        return this.prepayCardService.updateByPrimaryKeySelective((Object)update) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    public PageInfo<PrepayCardVo> getPrepayCardVoList(PrepayCardQueryVo prepayCardQueryVo) {
        PrepayCardEntity query = new PrepayCardEntity();
        BeanUtils.copyProperties((Object)prepayCardQueryVo, (Object)query);
        if (StringUtils.isNotEmpty((String)prepayCardQueryVo.getCustomerId())) {
            query.setBelongCustomerId(prepayCardQueryVo.getCustomerId());
        }
        if (prepayCardQueryVo.getOrderSource() != null && prepayCardQueryVo.getOrderSource() == 0) {
            query.setOrderSource(null);
        }
        if (StringUtils.isEmpty((String)prepayCardQueryVo.getCardId())) {
            query.setCardId(null);
        }
        if (StringUtils.isNotEmpty((String)prepayCardQueryVo.getOrderMainNo())) {
            query.setOrderMainNo(prepayCardQueryVo.getOrderMainNo());
        }
        Page page = PageHelper.startPage((int)prepayCardQueryVo.getPageCount(), (int)prepayCardQueryVo.getPageSize());
        page.setOrderBy("CREATE_TIME desc ");
        this.prepayCardService.getList((Object)query, 0L);
        List list = page.toPageInfo().getList();
        ArrayList resultList = new ArrayList();
        list.forEach(c -> {
            PrepayCardVo prepayCardVo = new PrepayCardVo();
            BeanUtils.copyProperties((Object)c, (Object)prepayCardVo);
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey((Serializable)c.getBatchId());
            prepayCardVo.setBatchName(prepayCardBatchEntity.getBatchName());
            prepayCardVo.setTitle(prepayCardBatchEntity.getTitle());
            prepayCardVo.setBindCode(prepayCardBatchEntity.getBindCode());
            if (c.getEndTime() != null && c.getEndTime().before(DateUtils.now()) && c.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
                prepayCardVo.setStatus(Integer.valueOf(PrepayCardStatusEnum.NOEFFECT.getValue()));
            }
            prepayCardVo.setStatusName(PrepayCardStatusEnum.getName((int)prepayCardVo.getStatus()));
            prepayCardVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            prepayCardVo.setCardTypeName(PrepayCardTypeEnum.getName((int)c.getCardType()));
            PrepayCardPlanDetailEntity prepayCardDetailEntity = new PrepayCardPlanDetailEntity();
            prepayCardDetailEntity.setCardId(c.getCardId());
            List detailList = this.prepayCardPlanDetailService.getList((Object)prepayCardDetailEntity, 0L);
            Integer noDeliveryNum = 0;
            if (detailList.size() > 0) {
                for (int j = 0; j < detailList.size(); ++j) {
                    if (((PrepayCardPlanDetailEntity)detailList.get(j)).getStatus().intValue() != PrepayCardPlanStatusEnum.DELIVERY.getValue() && ((PrepayCardPlanDetailEntity)detailList.get(j)).getStatus().intValue() != PrepayCardPlanStatusEnum.ACTIVE.getValue() || ((PrepayCardPlanDetailEntity)detailList.get(j)).getPickTime() == null || !((PrepayCardPlanDetailEntity)detailList.get(j)).getPickTime().after(DateUtils.currentDate())) continue;
                    noDeliveryNum = noDeliveryNum + ((PrepayCardPlanDetailEntity)detailList.get(j)).getQuantity();
                }
                prepayCardVo.setNoDeliveryNum(noDeliveryNum);
            } else {
                prepayCardVo.setNoDeliveryNum(noDeliveryNum);
            }
            resultList.add(prepayCardVo);
        });
        resultList.sort((c1, c2) -> c1.getStatus() - c2.getStatus());
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(page.getTotal());
        return pg2;
    }

    public List<MallSelectDataVo> getOrderSourceNameList() {
        PrepayCardEntity query = new PrepayCardEntity();
        List list = this.prepayCardService.getList((Object)query);
        List orderSourceList = list.stream().map(PrepayCardEntity::getOrderSource).collect(Collectors.toList());
        HashSet set = new HashSet(orderSourceList);
        ArrayList<MallSelectDataVo> sourceList = new ArrayList<MallSelectDataVo>();
        for (Integer source : set) {
            MallSelectDataVo selectDataVo = new MallSelectDataVo();
            selectDataVo.setName(OrderSourceEnum.getName((int)source));
            selectDataVo.setId(source.toString());
            sourceList.add(selectDataVo);
        }
        return sourceList;
    }

    public BaseJsonVo disabledCard(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361");
        }
        if (prepayCardEntity.getRemainCount() == 0) {
            return BaseJsonVo.error((String)"\u7981\u7528\u5931\u8d25\uff0c\u5361\u8ba1\u5212\u90fd\u5df2\u914d\u9001!");
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue() || prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.UNTAKED.getValue()) {
            BaseJsonVo to;
            BaseJsonVo b = this.disabledCard(prepayCardEntity);
            if (b.isSuccess() && !(to = this.balanceAccountInvoke.toggleSpecialCard(prepayCardEntity.getRelateCardNo(), Integer.valueOf(-1), "")).isSuccess()) {
                return to;
            }
            return b;
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            BaseJsonVo baseJsonVo = this.disabledCard(prepayCardEntity);
            if (baseJsonVo.isSuccess()) {
                BaseJsonVo to = this.balanceAccountInvoke.toggleSpecialCard(prepayCardEntity.getRelateCardNo(), Integer.valueOf(-1), "");
                if (!to.isSuccess()) {
                    return to;
                }
                return BaseJsonVo.success((Object)"\u5df2\u7981\u7528\uff0c\u8be5\u5361\u8fd8\u6709\u8ba2\u5355\u4e2d\u914d\u9001\u4e2d\u8bf7\u6839\u636e\u5b9e\u9645\u5904\u7406\u8be5\u5361\u4e0b\u5c5e\u8ba2\u5355");
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)("\u5361" + PrepayCardStatusEnum.getName((int)prepayCardEntity.getStatus()) + "\u65e0\u6cd5\u7981\u7528"));
    }

    private BaseJsonVo disabledCard(PrepayCardEntity prepayCardEntity) {
        PrepayCardEntity update = new PrepayCardEntity();
        update.setStatus(Integer.valueOf(PrepayCardStatusEnum.NOEFFECT.getValue()));
        update.setRemainCount(Integer.valueOf(0));
        update.setCardId(prepayCardEntity.getCardId());
        return this.prepayCardService.updateByPrimaryKeySelective((Object)update) > 0 ? BaseJsonVo.success((Object)"\u5df2\u7981\u7528") : BaseJsonVo.error((String)"\u7981\u7528\u5931\u8d25\u8bf7\u91cd\u8bd5");
    }
}

